/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.sdm.undo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.diagram.sdm.undo.CommandState;
import oracle.diagram.sdm.undo.StateHelper;
import oracle.ide.Context;

public abstract class StatefulDelegate {
    private List<CommandState> _undoState = null;
    private List<CommandState> _redoState = null;

    public void addUndoState(CommandState state) {
        if (this._undoState == null) {
            this._undoState = new ArrayList<CommandState>();
        }
        this._undoState.add(state);
    }

    public void addRedoState(CommandState state) {
        if (this._redoState == null) {
            this._redoState = new ArrayList<CommandState>();
        }
        this._redoState.add(state);
    }

    public void applyUndoState() {
        if (this._undoState != null) {
            for (CommandState state : this._undoState) {
                state.apply();
            }
        }
    }

    public void applyRedoState() {
        if (this._redoState != null) {
            for (CommandState state : this._redoState) {
                state.apply();
            }
        }
    }

    protected abstract Collection<StateHelper> getStateHelpers();

    public void storeUndoState(Context context) {
        this.storeState(context, true);
    }

    public void storeRedoState(Context context) {
        this.storeState(context, false);
    }

    public void clearState() {
        if (this._undoState != null) {
            this._undoState.clear();
            this._undoState = null;
        }
        if (this._redoState != null) {
            this._redoState.clear();
            this._redoState = null;
        }
    }

    private void storeState(Context context, boolean undo) {
        for (StateHelper h : this.getStateHelpers()) {
            Object state = h.createState(context);
            if (state == null) continue;
            if (undo) {
                this.addUndoState(new CommandState(h, state));
                continue;
            }
            this.addRedoState(new CommandState(h, state));
        }
    }
}

