/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.sdm.undo;

import java.util.Collection;
import oracle.diagram.sdm.undo.CommandState;
import oracle.diagram.sdm.undo.StateHelper;
import oracle.diagram.sdm.undo.StatefulDelegate;
import oracle.ide.Context;
import oracle.ide.controller.Command;

public abstract class StatefulCommand
extends Command {
    private boolean _first = true;
    private StatefulDelegate _delegate = new StatefulDelegate(){

        @Override
        protected Collection<StateHelper> getStateHelpers() {
            return StatefulCommand.this.getStateHelpers();
        }
    };

    public StatefulCommand(int id, int type, String description) {
        super(id, type, description);
    }

    public void addUndoState(CommandState state) {
        this._delegate.addUndoState(state);
    }

    public void addRedoState(CommandState state) {
        this._delegate.addRedoState(state);
    }

    protected void applyUndoState() {
        this._delegate.applyUndoState();
    }

    protected void applyRedoState() {
        this._delegate.applyRedoState();
    }

    public void setContext(Context context) {
        super.setContext(context);
        this._first = true;
        this._delegate.clearState();
    }

    protected abstract Collection<StateHelper> getStateHelpers();

    protected void storeState(Context context, boolean undo) {
        if (undo) {
            this._delegate.storeUndoState(context);
        } else {
            this._delegate.storeRedoState(context);
        }
    }

    public final int doit() throws Exception {
        boolean wasFirst = this._first;
        if (this._first) {
            this._first = false;
            this.storeState(this.getContext(), true);
        }
        int res = this.doitImpl();
        if (!wasFirst) {
            this.applyRedoState();
        } else {
            this.storeState(this.getContext(), false);
        }
        return res;
    }

    protected abstract int doitImpl() throws Exception;

    protected abstract int undoImpl() throws Exception;

    public final int undo() throws Exception {
        int res = this.undoImpl();
        this.applyUndoState();
        return res;
    }
}

