/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.sdm.undo;

import ilog.views.sdm.IlvSDMModel;
import ilog.views.sdm.model.IlvFilterSDMModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.diagram.sdm.undo.SDMAddObjectCommand;
import oracle.diagram.sdm.undo.SDMModelAdjustingCommand;
import oracle.diagram.sdm.undo.SDMRemoveObjectCommand;
import oracle.diagram.sdm.undo.SDMSetFromCommand;
import oracle.diagram.sdm.undo.SDMSetIDCommand;
import oracle.diagram.sdm.undo.SDMSetPropertyCommand;
import oracle.diagram.sdm.undo.SDMSetToCommand;
import oracle.diagram.sdm.undo.SDMUndoFilterConstants;
import oracle.diagram.sdm.undo.StateHelper;
import oracle.ide.Context;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;

public class SDMUndoFilter
extends IlvFilterSDMModel
implements SDMUndoFilterConstants {
    private List<ContextAndMask> _contextStack = new ArrayList<ContextAndMask>();
    private List<StateHelper> _stateHelpers = new ArrayList<StateHelper>();

    public SDMUndoFilter(IlvSDMModel model) {
        super(model);
    }

    public final void addStateHelper(StateHelper helper) {
        this._stateHelpers.add(helper);
    }

    public final void removeStateHelper(StateHelper helper) {
        this._stateHelpers.remove(helper);
    }

    public final Collection<StateHelper> getStateHelpers() {
        return Collections.unmodifiableList(this._stateHelpers);
    }

    protected final boolean isCapturing(int mask) {
        return (this.getActiveMask() & mask) != 0;
    }

    protected int getActiveMask() {
        return !this._contextStack.isEmpty() ? this._contextStack.get(this._contextStack.size() - 1).getMask() : 0;
    }

    protected Context getActiveContext() {
        return !this._contextStack.isEmpty() ? this._contextStack.get(this._contextStack.size() - 1).getContext() : null;
    }

    public void captureUndo(Context ctxt, Runnable task) {
        this.captureUndo(ctxt, 65535, task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void captureUndo(Context ctxt, int mask, Runnable task) {
        if (ctxt == null) {
            throw new IllegalArgumentException("Context must not be null");
        }
        this._contextStack.add(new ContextAndMask(ctxt, mask | 0x40));
        try {
            task.run();
        }
        finally {
            this._contextStack.remove(this._contextStack.size() - 1);
        }
    }

    protected void invokeCommand(Command cmd) {
        cmd.setContext(this.getActiveContext());
        try {
            CommandProcessor.getInstance().invoke(cmd);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setAdjusting(boolean adjusting) {
        if (this.isCapturing(64)) {
            this.invokeCommand(new SDMModelAdjustingCommand(this.getFilteredModel(), adjusting));
        } else {
            super.setAdjusting(adjusting);
        }
    }

    public void setID(Object obj, String id) {
        String oldID = super.getID(obj);
        if (SDMUndoFilter.areEqual(oldID, id)) {
            return;
        }
        if (this.isCapturing(1)) {
            this.invokeCommand(new SDMSetIDCommand(this.getFilteredModel(), obj, oldID, id));
        } else {
            super.setID(obj, id);
        }
    }

    public void addObject(Object obj, Object parent, Object before) {
        if (this.isCapturing(4)) {
            this.invokeCommand(new SDMAddObjectCommand(this.getFilteredModel(), obj, parent, before));
        } else {
            super.addObject(obj, parent, before);
        }
    }

    public void removeObject(Object obj) {
        if (this.isCapturing(8)) {
            this.invokeCommand(new SDMRemoveObjectCommand(this.getFilteredModel(), obj));
        } else {
            super.removeObject(obj);
        }
    }

    public void setObjectProperty(Object obj, String property, Object value) {
        Object oldValue = super.getObjectProperty(obj, property);
        if (SDMUndoFilter.areEqual(oldValue, value)) {
            return;
        }
        if (this.isCapturing(2)) {
            this.invokeCommand(new SDMSetPropertyCommand(this.getFilteredModel(), obj, property, oldValue, value));
        } else {
            super.setObjectProperty(obj, property, value);
        }
    }

    public void setFrom(Object obj, Object from) {
        Object oldFrom = super.getFrom(obj);
        if (oldFrom == from) {
            return;
        }
        if (this.isCapturing(16)) {
            this.invokeCommand(new SDMSetFromCommand(this.getFilteredModel(), obj, oldFrom, from));
        } else {
            super.setFrom(obj, from);
        }
    }

    public void setTo(Object obj, Object to) {
        Object oldTo = super.getTo(obj);
        if (oldTo == to) {
            return;
        }
        if (this.isCapturing(32)) {
            this.invokeCommand(new SDMSetToCommand(this.getFilteredModel(), obj, oldTo, to));
        } else {
            super.setTo(obj, to);
        }
    }

    protected static boolean areEqual(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        return o1 != null && o2 != null && o1.equals(o2);
    }

    protected static class ContextAndMask {
        private final Context _context;
        private final int _mask;

        public ContextAndMask(Context context, int mask) {
            this._context = context;
            this._mask = mask;
        }

        public Context getContext() {
            return this._context;
        }

        public int getMask() {
            return this._mask;
        }
    }
}

