/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.sdm.migrate;

import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.sdm.IlvSDMModel;
import ilog.views.sdm.model.IlvDefaultSDMModel;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.diagram.oppparse.OPPContainer;
import oracle.diagram.oppparse.OPPDiagram;
import oracle.diagram.oppparse.OPPDiagramEdge;
import oracle.diagram.oppparse.OPPDiagramNode;
import oracle.diagram.oppparse.OPPDiagramParser;
import oracle.diagram.oppparse.OPPDiagramShape;
import oracle.diagram.oppparse.OPPDiagramVisitor;
import oracle.diagram.oppparse.OPPEdgeRoute;
import oracle.diagram.oppparse.OPPTopLevelShape;
import oracle.diagram.sdm.graphic.PolyPointsPersistedUtil;
import oracle.diagram.sdm.migrate.SDMModelWriter;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;

public class MigrateToSDM {
    private static final String CSS_PROPERTY = "CSSclass";
    private static final String SDM_PREFIX = "sdm:";
    private static final Set<Feature> NOTE_FEATURES = Collections.unmodifiableSet(Collections.singleton(Feature.SIZE_PERSISTED));
    private static final Set<Feature> ATTACHMENT_FEATURES = Collections.unmodifiableSet(Collections.singleton(Feature.POLYPOINTS_PERSISTED));
    private final boolean _useRDF;
    private final Map<OPPTopLevelShape, Object> _mapOPPToSDM = new HashMap<OPPTopLevelShape, Object>(1365);
    private final List<OPPDiagramEdge> _edgesToConnect = new ArrayList<OPPDiagramEdge>(512);
    private IlvSDMModel _model;
    private final OPPDiagramVisitor _visitor = new DiagramVisitor();
    private int _noteCount;
    private int _attachmentCount;

    public static IlvSDMModel migrateToNewModel(URL oldDiagramURL, MigrateToSDM migrator) throws Exception {
        OPPDiagram diagram = OPPDiagramParser.parseDiagram(oldDiagramURL);
        return MigrateToSDM.migrateToNewModel(diagram, migrator);
    }

    public static IlvSDMModel migrateToNewModel(OPPDiagram diagram, MigrateToSDM migrator) {
        migrator.clear();
        diagram.visit(migrator.getDiagramVisitor());
        migrator.connectRemainingEdges();
        return migrator.getModel();
    }

    private final OPPDiagramVisitor getDiagramVisitor() {
        return this._visitor;
    }

    protected MigrateToSDM(boolean useRDF) {
        this._useRDF = useRDF;
    }

    protected final boolean isUsingRDF() {
        return this._useRDF;
    }

    protected String makePropertyName(String propertyName) {
        if (this.isUsingRDF() && propertyName.indexOf(58) == -1) {
            return SDM_PREFIX + propertyName;
        }
        return propertyName;
    }

    protected IlvSDMModel createSDMModel() {
        return new IlvDefaultSDMModel();
    }

    protected Set<Feature> getOptionalFeatures(Object sdmObject) {
        if (this.getDefaultNoteTag().equals(this.getModel().getTag(sdmObject))) {
            return this.getDefaultNoteFeatures();
        }
        if (this.getDefaultAttachmentTag().equals(this.getModel().getTag(sdmObject))) {
            return this.getDefaultAttachmentFeatures();
        }
        return Collections.emptySet();
    }

    protected String getTag(OPPTopLevelShape shape) {
        if ("DiagramNote".equals(shape.getPrimaryElementReference().getType())) {
            return this.getDefaultNoteTag();
        }
        if ("DiagramNoteConnector".equals(shape.getPrimaryElementReference().getType())) {
            return this.getDefaultAttachmentTag();
        }
        return shape.getPrimaryElementReference().getType();
    }

    protected String getDefaultNoteTag() {
        return "note";
    }

    protected Set<Feature> getDefaultNoteFeatures() {
        return NOTE_FEATURES;
    }

    protected String getDefaultNoteTextProperty() {
        return "label";
    }

    protected String getDefaultAttachmentTag() {
        return "attachment";
    }

    protected Set<Feature> getDefaultAttachmentFeatures() {
        return ATTACHMENT_FEATURES;
    }

    protected String getCSSClass(OPPTopLevelShape shape) {
        return null;
    }

    protected void initializeNodeProperties(Object sdmNode, OPPDiagramNode node) {
        String css = this.getCSSClass(node);
        if (css != null) {
            this.getModel().setObjectProperty(sdmNode, CSS_PROPERTY, (Object)css);
        }
        this.getModel().setObjectProperty(sdmNode, this.makePropertyName("x"), (Object)node.getPosition().getX());
        this.getModel().setObjectProperty(sdmNode, this.makePropertyName("y"), (Object)node.getPosition().getY());
        Set<Feature> features = this.getOptionalFeatures(sdmNode);
        if (features.contains((Object)Feature.SIZE_PERSISTED)) {
            this.getModel().setObjectProperty(sdmNode, this.makePropertyName("sdm:nodeWidth"), (Object)Float.valueOf(node.getCurrentSize().getWidth()));
            this.getModel().setObjectProperty(sdmNode, this.makePropertyName("sdm:nodeHeight"), (Object)Float.valueOf(node.getCurrentSize().getHeight()));
        }
        if (this.getDefaultNoteTag().equals(this.getModel().getTag(sdmNode))) {
            String text = (String)node.getDisplayData().getPropertyValue("text");
            this.getModel().setObjectProperty(sdmNode, this.getDefaultNoteTextProperty(), (Object)text);
        }
    }

    protected void initializeLinkProperties(Object sdmLink, OPPDiagramEdge edge) {
        Set<Feature> features;
        String css = this.getCSSClass(edge);
        if (css != null) {
            this.getModel().setObjectProperty((Object)edge, CSS_PROPERTY, (Object)css);
        }
        if ((features = this.getOptionalFeatures(sdmLink)).contains((Object)Feature.POLYPOINTS_PERSISTED)) {
            OPPEdgeRoute route = edge.getOriginalRoute();
            OPPDiagramShape src = route.getSource();
            OPPDiagramShape dst = route.getDestination();
            Rectangle2D r1 = src.getCurrentExtent();
            IlvRect rSrc = new IlvRect((float)r1.getX(), (float)r1.getY(), (float)r1.getWidth(), (float)r1.getHeight());
            Rectangle2D r2 = dst.getCurrentExtent();
            IlvRect rDst = new IlvRect((float)r2.getX(), (float)r2.getY(), (float)r2.getWidth(), (float)r2.getHeight());
            List<Point2D> p = route.getPoints();
            IlvPoint[] points = new IlvPoint[p.size()];
            int i = 0;
            for (Point2D point : p) {
                points[i++] = new IlvPoint((float)point.getX(), (float)point.getY());
            }
            String data = PolyPointsPersistedUtil.encodeLinkData(rSrc, points, rDst);
            this.getModel().setObjectProperty(sdmLink, this.makePropertyName("sdm:polyPoints"), (Object)data);
        }
    }

    protected void initializeObjectID(Object sdmObject, OPPTopLevelShape shape) {
        if (this.getDefaultNoteTag().equals(this.getModel().getTag(sdmObject))) {
            String id = this.getDefaultNoteTag() + ++this._noteCount;
            this.getModel().setID(sdmObject, id);
        } else if (this.getDefaultAttachmentTag().equals(this.getModel().getTag(sdmObject))) {
            String id = this.getDefaultAttachmentTag() + ++this._attachmentCount;
            this.getModel().setID(sdmObject, id);
        } else {
            this.getModel().setID(sdmObject, shape.getPrimaryElementReference().getValue());
        }
    }

    protected final IlvSDMModel getModel() {
        return this._model;
    }

    protected void clear() {
        this._attachmentCount = 0;
        this._noteCount = 0;
        this._model = null;
        this._mapOPPToSDM.clear();
        this._edgesToConnect.clear();
    }

    private final Object createAndAddShape(OPPTopLevelShape shape) {
        boolean isNode = shape instanceof OPPDiagramNode;
        String tag = this.getTag(shape);
        if (tag != null) {
            Object sdmParent;
            OPPContainer parent = shape.getParent();
            boolean root = parent instanceof OPPDiagram;
            Object object = sdmParent = root ? null : this._mapOPPToSDM.get(shape);
            if (!root && sdmParent == null) {
                return null;
            }
            Object sdm = isNode ? this.getModel().createNode(tag) : this.getModel().createLink(tag);
            this._mapOPPToSDM.put(shape, sdm);
            this.getModel().addObject(sdm, sdmParent, null);
            if (!isNode) {
                OPPDiagramEdge edge = (OPPDiagramEdge)shape;
                if (!this.connectEdge(edge, sdm)) {
                    this._edgesToConnect.add(edge);
                }
            } else {
                this.initializeObjectID(sdm, shape);
                this.initializeNodeProperties(sdm, (OPPDiagramNode)shape);
            }
            return sdm;
        }
        return null;
    }

    private final boolean connectEdge(OPPDiagramEdge edge, Object sdmLink) {
        OPPDiagramShape src = edge.getOriginalRoute().getSource();
        OPPDiagramShape dst = edge.getOriginalRoute().getDestination();
        if (src == null || dst == null) {
            return false;
        }
        Object sdmFrom = this._mapOPPToSDM.get(src);
        Object sdmTo = this._mapOPPToSDM.get(dst);
        if (sdmFrom == null || sdmTo == null) {
            return false;
        }
        this.getModel().setFrom(sdmLink, sdmFrom);
        this.getModel().setTo(sdmLink, sdmTo);
        this.initializeObjectID(sdmLink, edge);
        this.initializeLinkProperties(sdmLink, edge);
        return true;
    }

    private final void connectRemainingEdges() {
        ArrayList<OPPDiagramEdge> todo = new ArrayList<OPPDiagramEdge>(this._edgesToConnect.size());
        while (true) {
            todo.clear();
            for (OPPDiagramEdge edge : this._edgesToConnect) {
                Object link;
                if (this.connectEdge(edge, link = this._mapOPPToSDM.get(edge))) continue;
                todo.add(edge);
            }
            if (todo.size() == this._edgesToConnect.size()) break;
            this._edgesToConnect.clear();
            this._edgesToConnect.addAll(todo);
        }
        for (OPPDiagramEdge edge : this._edgesToConnect) {
            this.getModel().removeObject(this._mapOPPToSDM.get(edge));
        }
    }

    public static void main(String[] args) throws Exception {
        URL src = URLFactory.newFileURL((String)args[0]);
        IlvSDMModel model = MigrateToSDM.migrateToNewModel(src, new MigrateToSDM(true));
        URL dst = URLFactory.replacePathPart((URL)src, (String)(URLFileSystem.getPathNoExt((URL)src) + "_migrated.xml"));
        SDMModelWriter.saveDocument(SDMModelWriter.buildDocument(model, true), dst);
    }

    private final class DiagramVisitor
    implements OPPDiagramVisitor {
        private DiagramVisitor() {
        }

        @Override
        public void visitDiagram(OPPDiagram diagram) {
            MigrateToSDM.this._model = MigrateToSDM.this.createSDMModel();
        }

        @Override
        public void visitEdgeShape(OPPDiagramEdge edge) {
            MigrateToSDM.this.createAndAddShape(edge);
        }

        @Override
        public void visitNodeShape(OPPDiagramNode node) {
            MigrateToSDM.this.createAndAddShape(node);
        }
    }

    public static enum Feature {
        POLYPOINTS_PERSISTED,
        SIZE_PERSISTED;

    }
}

