/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.sdm.menu;

import ilog.views.sdm.IlvSDMEngine;
import java.awt.Component;
import java.util.Enumeration;
import javax.swing.JMenuItem;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.framework.menu.ViewDiagramContextMenuPlugin;
import oracle.diagram.sdm.context.SDMDiagramContextUtil;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.ToggleAction;
import oracle.ide.view.View;

public class SDMViewDiagramContextMenuPlugin
extends ViewDiagramContextMenuPlugin {
    public SDMViewDiagramContextMenuPlugin(DiagramContext context, View view) {
        super(context, view);
    }

    @Override
    protected void menuWillShow(ContextMenu contextMenu) {
        super.menuWillShow(contextMenu);
        if (this.isDeleteAvailable(contextMenu)) {
            IdeAction delete = IdeActions.getEditDeleteAction();
            Component c = contextMenu.getChildById(contextMenu.getGUI(true), delete.getCommandId());
            if (c == null) {
                JMenuItem m = contextMenu.createMenuItem((ToggleAction)delete, MenuConstants.WEIGHT_EDIT_DELETE);
                contextMenu.add((Component)m, MenuConstants.SECTION_EDIT_CTXT_MENU);
            }
        }
    }

    protected boolean isDeleteAvailable(ContextMenu contextMenu) {
        IlvSDMEngine engine = SDMDiagramContextUtil.getSDMEngine(this.getDiagramContext());
        if (engine != null) {
            Enumeration e = engine.getSelectedObjects();
            return e.hasMoreElements();
        }
        return false;
    }
}

