/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.sdm.interaction;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvLinkConnector;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvTransformer;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.IlvSDMModel;
import ilog.views.sdm.model.IlvSDMLink;
import ilog.views.sdm.model.IlvSDMNode;
import ilog.views.sdm.renderer.IlvRendererUtil;
import ilog.views.sdm.renderer.IlvSDMRenderer;
import ilog.views.sdm.renderer.IlvStyleSheetRenderer;
import ilog.views.sdm.util.IlvSDMConstants;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.interaction.CoreLinkReconnectInteractor;
import oracle.diagram.framework.graphic.GraphicConnector;
import oracle.diagram.framework.graphic.GraphicPin;
import oracle.diagram.framework.manager.ManagerUtil;
import oracle.diagram.framework.readonly.ReadOnlyUtil;
import oracle.diagram.sdm.engine.SDMEngineUtil;
import oracle.diagram.sdm.graphic.PolyPointsPersisted;
import oracle.diagram.sdm.graphic.PolyPointsPersistedUtil;
import oracle.diagram.sdm.interaction.SDMSelectInteractor;
import oracle.diagram.sdm.undo.SDMUndoUtil;
import oracle.diagram.sdm.undo.StateHelper;
import oracle.diagram.sdm.undo.StatefulCommand;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;

public class SDMLinkReconnectInteractor
extends CoreLinkReconnectInteractor
implements IlvSDMConstants {
    private Object _sdmLink = null;
    private Object _sdmAnchorNode = null;

    public SDMLinkReconnectInteractor(SDMSelectInteractor selectInteractor) {
        super(selectInteractor);
    }

    protected boolean acceptSource(Object link, Object source) {
        if (link instanceof IlvSDMLink && source instanceof IlvSDMNode && "attachment".equals(((IlvSDMLink)link).getTag())) {
            return "note".equals(((IlvSDMNode)source).getTag());
        }
        return true;
    }

    protected boolean acceptDestination(Object link, Object destination) {
        return true;
    }

    protected void highlight(Object target) {
        try {
            this.setAdjusting(true);
            this.getEngine().addPseudoClass(target, "__highlighted");
            this.getEngine().setSelected(target, true);
        }
        finally {
            this.setAdjusting(false);
        }
    }

    protected void unHighlight(Object target) {
        try {
            this.setAdjusting(true);
            this.getEngine().removePseudoClass(target, "__highlighted");
            SDMEngineUtil.setSelected(this.getEngine(), target, false);
        }
        finally {
            this.setAdjusting(false);
        }
    }

    protected final IlvSDMEngine getEngine() {
        return IlvSDMEngine.getSDMEngine((IlvGrapher)((IlvGrapher)this.getManagerView().getManager()));
    }

    @Override
    protected void endReconnection() {
        IlvSDMEngine ilvsdmengine = this.getEngine();
        Enumeration oldSelection = ilvsdmengine.getSelectedObjects();
        ilvsdmengine.deselectAllObjects();
        super.endReconnection();
        while (oldSelection.hasMoreElements()) {
            ilvsdmengine.setSelected(oldSelection.nextElement(), true);
        }
    }

    protected boolean isModelUndoRequired(IlvSDMModel model, Object link) {
        return true;
    }

    protected String getUndoName() {
        return UNDO_NAME;
    }

    protected Command createModelReconnectCommand(final IlvSDMModel model, final Object link, final Object oldEnd, final Object newEnd, final boolean isSrcEnd) {
        final IlvSDMEngine engine = this.getEngine();
        final String[] pointData = new String[2];
        return new StatefulCommand(Ide.findOrCreateCmdID((String)"SDM Link Model Reconnect"), 0, this.getUndoName()){

            @Override
            protected int doitImpl() throws Exception {
                IlvLinkImage linkGraphic = (IlvLinkImage)engine.getGraphic(link, false);
                if (linkGraphic instanceof PolyPointsPersisted && pointData[0] == null) {
                    pointData[0] = ((PolyPointsPersisted)linkGraphic).getPointData();
                }
                if (isSrcEnd) {
                    model.setFrom(link, newEnd);
                } else {
                    model.setTo(link, newEnd);
                }
                if (pointData[1] != null) {
                    linkGraphic = (IlvLinkImage)engine.getGraphic(link, false);
                    PolyPointsPersistedUtil.resolveConnections(engine, link, linkGraphic, pointData[1]);
                    PolyPointsPersistedUtil.updatePoints((IlvLinkImage)engine.getGraphic(link, false), pointData[1]);
                }
                return 0;
            }

            @Override
            protected int undoImpl() throws Exception {
                IlvLinkImage linkGraphic = (IlvLinkImage)engine.getGraphic(link, false);
                if (linkGraphic instanceof PolyPointsPersisted && pointData[1] == null) {
                    pointData[1] = ((PolyPointsPersisted)linkGraphic).getPointData();
                }
                if (isSrcEnd) {
                    model.setFrom(link, oldEnd);
                } else {
                    model.setTo(link, oldEnd);
                }
                if (pointData[0] != null) {
                    linkGraphic = (IlvLinkImage)engine.getGraphic(link, false);
                    PolyPointsPersistedUtil.resolveConnections(engine, link, linkGraphic, pointData[0]);
                    PolyPointsPersistedUtil.updatePoints(linkGraphic, pointData[0]);
                }
                return 0;
            }

            @Override
            protected Collection<StateHelper> getStateHelpers() {
                return SDMUndoUtil.getStateHelpers(model);
            }
        };
    }

    @Override
    protected void mouseReleased(MouseEvent mouseevent) {
        IlvSDMEngine engine = this.getEngine();
        super.mouseReleased(mouseevent);
        if (engine.isLinkLayoutEnabled()) {
            engine.performLinkLayout();
        } else {
            SDMEngineUtil.ensureLinkConnections(engine);
        }
    }

    @Override
    protected IlvGraphic getLinkEnd(boolean origin) {
        GraphicPin pin = GraphicPin.findPin(this.getLink(), origin);
        return pin != null ? pin.getGraphic() : super.getLinkEnd(origin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reconnect(Object obj) {
        CommandProcessor.getInstance().beginTrans(this.getUndoName());
        this.setAdjusting(true);
        IlvSDMModel ilvsdmmodel = this.getEngine().getModel();
        try {
            if (this.isModelUndoRequired(ilvsdmmodel, this._sdmLink)) {
                Command modelCommand = this.createModelReconnectCommand(ilvsdmmodel, this._sdmLink, this.isReconnectingSource() ? ilvsdmmodel.getFrom(this._sdmLink) : ilvsdmmodel.getTo(this._sdmLink), obj, this.isReconnectingSource());
                modelCommand.setContext(((SDMSelectInteractor)this.getSelectInteractor()).getContext());
                try {
                    CommandProcessor.getInstance().invoke(modelCommand);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else if (this.isReconnectingSource()) {
                ilvsdmmodel.setFrom(this._sdmLink, obj);
            } else {
                ilvsdmmodel.setTo(this._sdmLink, obj);
            }
            IlvGraphic to = this.getEngine().getGraphic(obj, false);
            if (to != null) {
                IlvLinkImage ilvlinkimage = (IlvLinkImage)this.getEngine().getGraphic(this.getSDMLink(), false);
                if (!ilvsdmmodel.isLink(obj)) {
                    IlvLinkConnector ilvlinkconnector = IlvLinkConnector.GetAttached((IlvGraphic)to);
                    if (ilvlinkconnector != null) {
                        IlvTransformer ilvtransformer = this.getManagerView().getTransformer();
                        ilvlinkconnector.connectLink(ilvlinkimage, this.getTrackPoint(), this.isReconnectingSource(), ilvtransformer);
                    }
                } else {
                    GraphicConnector gc = GraphicConnector.findOrCreateConnector(to);
                    IlvManager mgr = ManagerUtil.getTransformingManager(to);
                    IlvTransformer tx = mgr.getDrawingTransformer(this.getManagerView());
                    gc.connectLink(ilvlinkimage, this.getTrackPoint(), this.isReconnectingSource(), tx);
                    if (ilvlinkimage instanceof PolyPointsPersisted) {
                        String pointData = ((PolyPointsPersisted)ilvlinkimage).getPointData();
                        IlvRendererUtil.updateObjectProperties((IlvSDMEngine)this.getEngine(), (Object)this._sdmLink, (String)"sdm:polyPoints", (Object)pointData, null);
                    }
                }
            }
        }
        finally {
            this.setAdjusting(false);
            CommandProcessor.getInstance().endTrans();
        }
    }

    protected final Object getSDMLink() {
        return this._sdmLink;
    }

    protected final void setSDMLink(Object link) {
        this._sdmLink = link;
    }

    protected final Object getSDMAnchorNode() {
        return this._sdmAnchorNode;
    }

    protected final void setSDMAnchorNode(Object obj) {
        this._sdmAnchorNode = obj;
    }

    @Override
    protected final IlvGrapher getGrapher() {
        return this.getEngine().getGrapher();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.setSDMLink(null);
        this.setSDMAnchorNode(null);
    }

    @Override
    protected boolean initializeFromHit(IlvGraphic hit) {
        Object obj = this.getEngine().getObject(hit);
        if (obj != null) {
            IlvGraphicEnumeration links;
            IlvGrapher grapher = this.getGrapher();
            if (hit instanceof IlvLinkImage) {
                boolean result = super.initializeFromHit(hit);
                if (result) {
                    this.setSDMLink(obj);
                }
                return result;
            }
            if (grapher.isNode(hit) && this.isAnchor(obj) && (links = grapher.getLinks(hit)).hasMoreElements()) {
                IlvLinkImage link = (IlvLinkImage)links.nextElement();
                boolean result = super.initializeFromHit((IlvGraphic)link);
                if (result) {
                    this.setSDMLink(this.getEngine().getObject((IlvGraphic)link));
                    this.setSDMAnchorNode(obj);
                }
                return result;
            }
        }
        return false;
    }

    @Override
    protected void initializeTracking(boolean source) {
        IlvSDMModel model = this.getEngine().getModel();
        if (source) {
            Object from = model.getFrom(this.getSDMLink());
            if (this.isAnchor(from)) {
                this.setSDMAnchorNode(from);
            }
            this.setTargetGraphic(this.getEngine().getGraphic(from, true));
        } else {
            Object to = model.getTo(this.getSDMLink());
            if (this.isAnchor(to)) {
                this.setSDMAnchorNode(to);
            }
            this.setTargetGraphic(this.getEngine().getGraphic(to, true));
        }
    }

    @Override
    protected final boolean isValidReconnectionTarget(IlvGraphic target) {
        IlvSDMModel model = this.getEngine().getModel();
        Object obj = this.getEngine().getObject(target);
        if (obj != null && !this.isAnchor(obj) && (this.isReconnectingSource() ? !this.acceptSource(this.getSDMLink(), obj) : !this.acceptDestination(this.getSDMLink(), obj))) {
            return false;
        }
        if (obj == null) {
            return false;
        }
        Object obj1 = model.getParent(this.getSDMLink());
        while (obj1 != null) {
            if (obj == obj1) {
                return false;
            }
            obj1 = model.getParent(obj1);
        }
        return true;
    }

    @Override
    protected void createAnchorTarget() {
    }

    protected final DiagramContext getDiagramContext() {
        IlvManagerView view = this.getManagerView();
        if (view == null) {
            throw new IllegalStateException("Interactor is not attached to a view");
        }
        return DiagramContext.getDiagramContext(view);
    }

    @Override
    protected void connectTarget(IlvGraphic target) throws Exception {
        if (target != null && !ReadOnlyUtil.checkWritableReconnectLink(this.getDiagramContext(), this.getLink(), this.isReconnectingSource() ? this.getLink().getFrom() : this.getLink().getTo(), target, this.isReconnectingSource())) {
            return;
        }
        IlvSDMModel model = this.getEngine().getModel();
        Object obj1 = this.getEngine().getObject(this.getTargetGraphic());
        if (obj1 != null) {
            IlvGraphicBag ilvgraphicbag;
            IlvGraphic ilvgraphic1;
            this.reconnect(obj1);
            if (this.getSDMAnchorNode() != null && model.getFrom(this.getSDMLink()) != this.getSDMAnchorNode() && model.getTo(this.getSDMLink()) != this.getSDMAnchorNode() && (ilvgraphic1 = this.getEngine().getGraphic(this.getSDMAnchorNode(), true)) != null && (ilvgraphicbag = ilvgraphic1.getGraphicBag()) instanceof IlvGrapher && ((IlvGrapher)ilvgraphicbag).isNode(ilvgraphic1) && ((IlvGrapher)ilvgraphicbag).getLinksCount(ilvgraphic1) <= 1) {
                model.removeObject(this.getSDMAnchorNode());
            }
        }
    }

    @Override
    protected final void showTargetFeedback(IlvGraphic target, boolean on) {
        if (on) {
            this.highlight(this.getEngine().getObject(target));
        } else {
            this.unHighlight(this.getEngine().getObject(target));
        }
    }

    @Override
    protected void setAdjusting(boolean adjusting) {
        this.getEngine().setAdjusting(adjusting);
    }

    @Override
    protected void cleanup() {
        this.setSDMLink(null);
        this.setSDMAnchorNode(null);
    }

    @Override
    protected Collection<IlvLinkImage> getDependentLinks() {
        Object linkObj = this.getSDMLink();
        if (linkObj != null) {
            LinkedList<IlvLinkImage> linkList = new LinkedList<IlvLinkImage>();
            IlvSDMEngine engine = this.getEngine();
            IlvSDMModel model = engine.getModel();
            Enumeration allObjects = engine.getAllObjects();
            while (allObjects.hasMoreElements()) {
                Object o = allObjects.nextElement();
                if (!model.isLink(o) || model.getFrom(o) != linkObj && model.getTo(o) != linkObj) continue;
                linkList.add((IlvLinkImage)engine.getGraphic(o, false));
            }
            return linkList;
        }
        return null;
    }

    private boolean isAnchor(Object obj) {
        IlvSDMEngine engine = this.getEngine();
        if ("anchor".equals(engine.getModel().getTag(obj))) {
            return true;
        }
        String s = this.getCSSClassPropertyName();
        return s != null && "anchor".equals(engine.getModel().getObjectProperty(obj, s));
    }

    private final String getCSSClassPropertyName() {
        IlvSDMRenderer ilvsdmrenderer = IlvRendererUtil.getRenderer((IlvSDMEngine)this.getEngine(), (String)"StyleSheet");
        if (ilvsdmrenderer != null && ilvsdmrenderer instanceof IlvStyleSheetRenderer) {
            return ((IlvStyleSheetRenderer)ilvsdmrenderer).getCssClassPropertyName();
        }
        return null;
    }

    @Override
    protected IlvLinkImage getLink() {
        IlvSDMEngine engine = this.getEngine();
        if (engine == null || this.getSDMLink() == null) {
            return super.getLink();
        }
        return (IlvLinkImage)engine.getGraphic(this.getSDMLink(), true);
    }
}

