/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.sdm.interaction;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvManager;
import ilog.views.IlvManagerFrame;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvTransformer;
import ilog.views.graphic.composite.IlvCompositeGraphic;
import ilog.views.internal.IlvGraphicManagerFrame;
import ilog.views.sdm.IlvSDMEngine;
import java.awt.event.MouseEvent;
import oracle.diagram.sdm.interaction.SDMSelectInteractor;

public class SDMCompositeSelectInteractor
extends SDMSelectInteractor {
    private IlvSDMEngine _engine;
    private final IlvPoint _lastPoint = new IlvPoint();

    protected void attach(IlvManagerView view) {
        super.attach(view);
        if (!(view.getManager() instanceof IlvGrapher) || (this._engine = IlvSDMEngine.getSDMEngine((IlvGrapher)((IlvGrapher)view.getManager()))) == null) {
            view.popInteractor();
            throw new IllegalStateException("SDMCompositeSelectInteractor can only be used with an IlvManagerView based on IlvSDMEngine");
        }
    }

    public void deSelectObject(IlvGraphic graphic) {
        super.deSelectObject(graphic);
        this.modifySelection(graphic, this._lastPoint, false);
    }

    public void selectObject(IlvGraphic graphic) {
        super.selectObject(graphic);
        this.modifySelection(graphic, this._lastPoint, true);
    }

    @Override
    protected void mousePressed(MouseEvent mouseEvent, boolean isMultiSelect, boolean isPrimary) {
        if (isPrimary && !isMultiSelect) {
            this._lastPoint.move((float)mouseEvent.getX(), (float)mouseEvent.getY());
            IlvManager mgr = this.getManager();
            IlvGraphic graphic = mgr.getObject(this._lastPoint, this.getManagerView(), true);
            if (graphic != null) {
                this.modifySelection(graphic);
            }
        }
        super.mousePressed(mouseEvent, isMultiSelect, isPrimary);
    }

    @Override
    public void deSelectAll() {
        super.deSelectAll();
        if (this._engine != null) {
            this._engine.deselectAllObjects();
        }
    }

    private void modifySelection(IlvGraphic graphic, IlvPoint p, boolean select) {
        Object obj;
        IlvSDMEngine engine = IlvSDMEngine.getSDMEngine((IlvGraphic)graphic);
        if (engine != null && (obj = this.findSDMObjectInComposite(engine, graphic, p, this.getManagerView())) != null) {
            if (select) {
                super.deSelectObject(graphic);
            } else {
                super.selectObject(graphic);
            }
            engine.setSelected(obj, select);
        }
    }

    private void modifySelection(IlvGraphic graphic) {
        Object obj;
        IlvSDMEngine engine = IlvSDMEngine.getSDMEngine((IlvGraphic)graphic);
        if (engine != null && (obj = this.findSDMObjectInComposite(engine, graphic, this._lastPoint, this.getManagerView())) != null && engine.getGrapher().isSelected(graphic)) {
            super.deSelectObject(graphic);
        }
    }

    private Object findSDMObjectInComposite(IlvSDMEngine engine, IlvGraphic graphic, IlvPoint point, IlvManagerView view) {
        IlvGraphic frameGraphic;
        IlvManagerFrame frame;
        IlvGraphicBag bag = graphic.getGraphicBag();
        IlvManager mgr = bag instanceof IlvManager ? (IlvManager)bag : null;
        graphic = engine.getRenderer().getEncapsulatedGraphic(graphic);
        IlvCompositeGraphic composite = null;
        if (graphic instanceof IlvCompositeGraphic) {
            composite = (IlvCompositeGraphic)graphic;
        } else if (graphic instanceof IlvManager && (frame = ((IlvManager)graphic).getFrame()) instanceof IlvGraphicManagerFrame && (frameGraphic = ((IlvGraphicManagerFrame)frame).getFrameGraphic()) instanceof IlvCompositeGraphic) {
            composite = (IlvCompositeGraphic)frameGraphic;
        }
        if (composite != null) {
            Object obj;
            IlvTransformer tx = mgr == null ? view.getTransformer() : mgr.getDrawingTransformer(view);
            IlvPoint tmp = new IlvPoint(point);
            tx.inverse(tmp);
            if (engine != null && (obj = SDMCompositeSelectInteractor.recurseFind(engine, composite, point, tmp, tx)) != null) {
                return obj;
            }
        }
        return null;
    }

    private static Object recurseFind(IlvSDMEngine engine, IlvCompositeGraphic composite, IlvPoint point, IlvPoint txPoint, IlvTransformer tx) {
        IlvGraphic[] children = composite.getChildren();
        if (children != null && children.length > 0) {
            for (int i = children.length - 1; i > -1; --i) {
                Object obj;
                IlvGraphic child = children[i];
                if (child == null) continue;
                if (child instanceof IlvCompositeGraphic && (obj = SDMCompositeSelectInteractor.recurseFind(engine, (IlvCompositeGraphic)child, point, txPoint, tx)) != null) {
                    return obj;
                }
                if (!child.contains(txPoint, point, tx) || (obj = engine.getObject(child)) == null) continue;
                return obj;
            }
        }
        return null;
    }
}

