/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.oppparse;

import oracle.diagram.oppparse.OPPDiagram;
import oracle.diagram.oppparse.OPPDimension;
import oracle.diagram.oppparse.OPPInsets;
import oracle.diagram.oppparse.OPPParseConstants;
import oracle.diagram.oppparse.OPPParseUtil;
import oracle.diagram.oppparse.OPPXMLElementAdapter;
import oracle.xml.parser.v2.XMLElement;

public final class OPPPrintSettings
extends OPPXMLElementAdapter
implements OPPParseConstants {
    private final OPPDiagram _parent;
    private final OPPDimension _paperSize;
    private final OPPInsets _paperMargins;
    private final boolean _isPortrait;
    private final String _printer;

    OPPPrintSettings(OPPDiagram parent, XMLElement source) {
        super(source);
        this._parent = parent;
        XMLElement paperSize = OPPParseUtil.getNamedChild(source, "dimension", "paperSize");
        this._paperSize = paperSize != null ? (OPPDimension)OPPParseUtil.parseTypedProperty(paperSize) : null;
        XMLElement paperMargins = OPPParseUtil.getNamedChild(source, "insets", "paperMargins");
        this._paperMargins = paperMargins != null ? (OPPInsets)OPPParseUtil.parseTypedProperty(paperMargins) : null;
        XMLElement orientation = OPPParseUtil.getNamedChild(source, "integer", "paperOrientation");
        this._isPortrait = orientation != null ? (Integer)OPPParseUtil.parseTypedProperty(orientation) == 1 : true;
        XMLElement printerName = OPPParseUtil.getNamedChild(source, null, "printerName");
        this._printer = printerName != null ? (String)OPPParseUtil.parseTypedProperty(printerName) : null;
    }

    public final OPPDiagram getParent() {
        return this._parent;
    }

    public final OPPDimension getPaperSize() {
        return this._paperSize;
    }

    public final OPPInsets getPaperMargins() {
        return this._paperMargins;
    }

    public final boolean isPortrait() {
        return this._isPortrait;
    }

    public final boolean isLandscape() {
        return !this._isPortrait;
    }

    public final String getPrinterName() {
        return this._printer;
    }
}

