/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.view;

import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewDecoration;
import ilog.views.IlvManagerViewInteractor;
import ilog.views.IlvRect;
import ilog.views.graphic.IlvText;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.geom.Area;
import oracle.diagram.core.interaction.CoreMakeRectangleInteractor;
import oracle.diagram.framework.view.HintTextDecoration;

public class HintTextViewDecoration
extends HintTextDecoration
implements IlvManagerViewDecoration {
    public HintTextViewDecoration(IlvManagerView view, String hint) {
        super(view, hint);
    }

    public void paint(Graphics graphics, IlvManagerView view) {
        if (this.requiresIsEmptyRecalc()) {
            this.updateCachedEmptyState();
        }
        if (this.isEmpty()) {
            Shape oldClipShape = null;
            IlvManagerViewInteractor i = view.getInteractor();
            if (i instanceof CoreMakeRectangleInteractor) {
                CoreMakeRectangleInteractor mri = (CoreMakeRectangleInteractor)i;
                IlvRect r = mri.getGhostRectangle();
                if (r.width > 0.0f || r.height > 0.0f) {
                    oldClipShape = graphics.getClip();
                    if (mri.isRotationAllowed()) {
                        view.getTransformer().apply(r);
                    }
                    Area newClipShape = new Area(oldClipShape);
                    newClipShape.subtract(new Area((Shape)r));
                    graphics.setClip(newClipShape);
                }
            }
            if (this.requiresPositionRecalc()) {
                this.updateCachedPosition(view.getTransformer());
            }
            IlvText graphic = this.getHintTextGraphic();
            graphic.draw(graphics, view.getTransformer());
            if (oldClipShape != null) {
                graphics.setClip(oldClipShape);
            }
        }
    }
}

