/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.view;

import ilog.views.IlvGrid;
import ilog.views.IlvPoint;
import ilog.views.IlvTransformer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.diagram.framework.view.GridDecoration;

public class DecoratedGrid
extends IlvGrid {
    private final List<GridDecoration> _decorations = new ArrayList<GridDecoration>();

    public DecoratedGrid() {
    }

    public void clean() {
        this._decorations.clear();
    }

    public DecoratedGrid(Color color, IlvPoint origin, float hspacing, float vspacing, boolean visible, boolean active) {
        super(color, origin, hspacing, vspacing, visible, active);
    }

    public void addGridDecoration(GridDecoration decoration) {
        if (decoration == null) {
            throw new IllegalArgumentException("decoration must not be null");
        }
        this._decorations.add(decoration);
    }

    public void removeGridDecoration(GridDecoration decoration) {
        if (decoration == null) {
            throw new IllegalArgumentException("decoration must not be null");
        }
        this._decorations.remove(decoration);
    }

    protected void draw(Graphics g, IlvTransformer tx, Rectangle r) {
        super.draw(g, tx, r);
        this.drawDecorations(g, tx, r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void drawDecorations(Graphics g, IlvTransformer tx, Rectangle r) {
        Shape oldClip = g.getClip();
        try {
            Rectangle clip = oldClip != null ? oldClip.getBounds().intersection(r) : r;
            if (clip.width == 0 || clip.height == 0) {
                return;
            }
            g.setClip(clip);
            Iterator<GridDecoration> i = this._decorations.iterator();
            while (i.hasNext()) {
                try {
                    i.next().draw(this, g, tx, r);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            g.setClip(oldClip);
        }
    }
}

