/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.swimlanes.graphic;

import ilog.views.IlvRect;
import ilog.views.graphic.composite.layout.IlvAttachmentConstraint;
import ilog.views.graphic.composite.layout.IlvAttachmentLocation;
import java.awt.Font;
import oracle.diagram.framework.graphic.SingleLineText;
import oracle.diagram.framework.graphic.layout.Anchor;
import oracle.diagram.framework.swimlanes.graphic.AbstractHeaderGraphic;

public class HorizontalHeaderGraphic
extends AbstractHeaderGraphic {
    private boolean _finishedInit = false;

    public HorizontalHeaderGraphic(String headerText, Anchor headerAnchor) {
        super(headerText, headerAnchor);
    }

    @Override
    public void doLayout() {
        super.doLayout();
        this._finishedInit = true;
    }

    @Override
    protected void addTextShape(SingleLineText textShape, Anchor headerAnchor) {
        IlvAttachmentConstraint constraint = new IlvAttachmentConstraint(IlvAttachmentLocation.TopCenter, IlvAttachmentLocation.LeftCenter);
        constraint.setRotationAngle(-90.0);
        IlvRect bbox = textShape.boundingBox(null);
        float fontHeight = bbox.height;
        float thickness = Math.max(1.0f, this.getShapeLineThickness().floatValue());
        constraint.setOffsetX(fontHeight / 2.0f + thickness);
        constraint.setOffsetY(-1.0f * (fontHeight / 2.0f) - thickness);
        this.addContent(textShape, constraint);
    }

    @Override
    public void setShapeFont(Font font) {
        super.setShapeFont(font);
        float thickness = Math.max(1.0f, this.getShapeLineThickness().floatValue());
        IlvRect bbox = this.getTextShape().boundingBox(null);
        float fontHeight = this._finishedInit ? bbox.width : bbox.height;
        IlvAttachmentConstraint constraint = (IlvAttachmentConstraint)this.getConstraints(1);
        constraint.setOffsetX(fontHeight / 2.0f + thickness);
        constraint.setOffsetY(-1.0f * (fontHeight / 2.0f) - thickness);
        this.invalidate();
    }

    @Override
    protected void setLineThicknessImpl(float thickness) {
        float oldThickness = Math.max(1.0f, this.getShapeLineThickness().floatValue());
        IlvAttachmentConstraint constraint = (IlvAttachmentConstraint)this.getConstraints(1);
        float offsetX = constraint.getOffsetX() - oldThickness;
        float offsetY = constraint.getOffsetY() + oldThickness;
        super.setLineThicknessImpl(thickness);
        float newThickness = Math.max(1.0f, this.getShapeLineThickness().floatValue());
        constraint.setOffsetX(offsetX + newThickness);
        constraint.setOffsetY(offsetY - newThickness);
        this.invalidate();
    }
}

