/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.swimlanes.features;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvRect;
import java.awt.Frame;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.framework.graphic.features.AlignPanel;
import oracle.diagram.framework.graphic.features.BatchGraphic;
import oracle.diagram.framework.graphic.features.DefaultAlignPlugin;
import oracle.diagram.framework.interaction.ReshapeSelectionHelper;
import oracle.diagram.framework.interaction.ReshapeSelectionPlugin;
import oracle.diagram.framework.swimlanes.SwimlanesPlugin;
import oracle.diagram.framework.swimlanes.graphic.SwimlaneGraphic;
import oracle.ide.Ide;

public class SwimlanesAlignPlugin
extends DefaultAlignPlugin {
    public SwimlanesAlignPlugin(DiagramContext context) {
        super(context);
    }

    @Override
    public boolean configureAlign() {
        AlignPanel aPanel;
        boolean disableHorizontal = false;
        boolean disableVertical = false;
        SwimlanesPlugin plugin = this.getDiagramContext().getPlugin(SwimlanesPlugin.class);
        IlvManager mgr = this.getDiagramContext().getManagerView().getManager();
        if (plugin != null && plugin.getTopSwimlane(mgr) != null) {
            SwimlaneGraphic sg = null;
            IlvGraphicEnumeration selection = mgr.getSelectedObjects(true);
            if (selection.hasMoreElements()) {
                sg = plugin.getSwimlaneForGraphic(selection.nextElement());
                while (selection.hasMoreElements()) {
                    IlvGraphic element = selection.nextElement();
                    if (element instanceof IlvLinkImage || sg == plugin.getSwimlaneForGraphic(element)) continue;
                    SwimlaneGraphic topSwimlane = plugin.getTopSwimlane(mgr);
                    int flow = topSwimlane.getFlowDirection();
                    if (flow == 8 || flow == 4) {
                        disableVertical = true;
                        break;
                    }
                    if (flow != 1 && flow != 2) break;
                    disableHorizontal = true;
                    break;
                }
            }
        }
        if ((aPanel = new AlignPanel(disableHorizontal, disableVertical)).showDialog((Frame)Ide.getMainWindow())) {
            this.setAlignFormat(aPanel.getAlignFormat());
        }
        return true;
    }

    @Override
    protected void applyChanges(Collection<BatchGraphic> batch) {
        if (!this.getAlignFormat().isAdjustWidth() && !this.getAlignFormat().isAdjustHeight()) {
            super.applyChanges(batch);
            return;
        }
        List<Object> helpers = Collections.emptyList();
        ReshapeSelectionPlugin plugin = this.getDiagramContext().getPlugin(ReshapeSelectionPlugin.class);
        if (plugin != null) {
            helpers = plugin.getReshapeSelectionHelpers();
        }
        if (helpers.isEmpty()) {
            super.applyChanges(batch);
            return;
        }
        for (BatchGraphic elt : batch) {
            IlvGraphic g = elt.getGraphic();
            for (ReshapeSelectionHelper reshapeSelectionHelper : helpers) {
                reshapeSelectionHelper.reshapeInitiated(g);
            }
            IlvRect originalRect = new IlvRect(g.boundingBox(null));
            IlvRect ilvRect = elt.rect;
            for (ReshapeSelectionHelper reshapeSelectionHelper : helpers) {
                reshapeSelectionHelper.constrainReshapeRect(g, 7, false, originalRect, ilvRect);
            }
            for (ReshapeSelectionHelper reshapeSelectionHelper : helpers) {
                reshapeSelectionHelper.preReshapeObject(g, 7, false, originalRect, ilvRect);
            }
            elt.applyChanges();
            for (ReshapeSelectionHelper reshapeSelectionHelper : helpers) {
                reshapeSelectionHelper.postReshapeObject(g, 7, false, originalRect, ilvRect);
            }
            for (ReshapeSelectionHelper reshapeSelectionHelper : helpers) {
                reshapeSelectionHelper.reshapeComplete(g);
            }
        }
    }
}

