/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.preference;

import java.util.HashMap;
import java.util.Map;
import oracle.diagram.framework.preference.AbstractPreferenceStore;
import oracle.diagram.framework.preference.PreferenceDefinition;
import oracle.ide.util.ModelUtil;
import oracle.javatools.util.Copyable;

public class MapPreferenceStore
extends AbstractPreferenceStore
implements Copyable {
    private Map<String, Object> _storage = null;

    public MapPreferenceStore() {
        this(new HashMap<String, Object>());
    }

    public MapPreferenceStore(Map<String, Object> storage) {
        this._storage = storage;
    }

    @Override
    public boolean hasPreferenceValue(PreferenceDefinition preference) {
        return this._storage.containsKey(preference.getStorageKey());
    }

    @Override
    protected Object getPreferenceValueImpl(PreferenceDefinition preference) {
        return this._storage.get(preference.getStorageKey());
    }

    @Override
    protected Object setPreferenceValueImpl(PreferenceDefinition preference, Object value) {
        return this._storage.put(preference.getStorageKey(), value);
    }

    public Map<String, Object> getStorage() {
        return this._storage;
    }

    public void setStorage(Map<String, Object> storage) {
        this._storage = storage;
    }

    public Object copyTo(Object target) {
        MapPreferenceStore to = target != null ? (MapPreferenceStore)target : new MapPreferenceStore();
        this.copyToImpl(to);
        return to;
    }

    protected void copyToImpl(MapPreferenceStore target) {
        ModelUtil.deepCopy(this._storage, target._storage);
    }
}

