/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.palette;

import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.framework.palette.PalettePlugin;
import oracle.ide.palette2.PaletteEvent;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PaletteListener;
import oracle.ide.palette2.PaletteManager;
import oracle.ide.palette2.PalettePage;

public abstract class AbstractPaletteEventDispatch
implements PaletteListener {
    private final DiagramContext _context;

    public AbstractPaletteEventDispatch(DiagramContext context) {
        if (context == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        this._context = context;
    }

    public void attachToPalette() {
        PaletteManager.getPaletteManager().getPaletteWindow().addPaletteListener((PaletteListener)this);
    }

    public void detachFromPalette() {
        PaletteManager.getPaletteManager().getPaletteWindow().removePaletteListener((PaletteListener)this);
    }

    public void itemSelected(PaletteEvent event) {
        if (!this.isActive()) {
            return;
        }
        PalettePlugin pp = this.getPalettePlugin();
        if (pp == null) {
            return;
        }
        PaletteItem item = (PaletteItem)event.getSource();
        if ("PALETTE2_ITEM_DEFAULTCREATE".equals(event.getAction())) {
            pp.defaultCreate(item);
        } else {
            pp.paletteItemSelected(item);
        }
    }

    public void itemUnselected(PaletteEvent event) {
        PalettePlugin pp = this.getPalettePlugin();
        if (pp == null) {
            return;
        }
        pp.paletteItemUnselected((PaletteItem)event.getSource());
    }

    public void paletteOpened(PaletteEvent event) {
        if (!this.isActive()) {
            return;
        }
        PalettePlugin pp = this.getPalettePlugin();
        if (pp == null) {
            return;
        }
        pp.paletteOpened((PaletteManager)event.getSource());
    }

    public void paletteClosed(PaletteEvent event) {
        if (!this.isActive()) {
            return;
        }
        PalettePlugin pp = this.getPalettePlugin();
        if (pp == null) {
            return;
        }
        pp.paletteClosed((PaletteManager)event.getSource());
    }

    public void selectionChanged(PaletteEvent event) {
        if (!this.isActive()) {
            return;
        }
        PalettePlugin pp = this.getPalettePlugin();
        if (pp == null) {
            return;
        }
        pp.selectionChanged((PalettePage)event.getSource());
    }

    public void stickyModeActivated(PaletteEvent event) {
        if (!this.isActive()) {
            return;
        }
        PalettePlugin pp = this.getPalettePlugin();
        if (pp == null) {
            return;
        }
        pp.stickyModeActivated((PaletteItem)event.getSource());
    }

    public void stickyModeDeactivated(PaletteEvent event) {
        PalettePlugin pp = this.getPalettePlugin();
        if (pp == null) {
            return;
        }
        pp.stickyModeDeactivated((PaletteItem)event.getSource());
    }

    protected abstract boolean isActive();

    private PalettePlugin getPalettePlugin() {
        return this.getDiagramContext().getPlugin(PalettePlugin.class);
    }

    protected final DiagramContext getDiagramContext() {
        return this._context;
    }
}

