/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.link.policy;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvLinkConnector;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.linkpolicy.IlvAbstractLinkShapePolicy;
import ilog.views.linkconnector.IlvGrapherPin;
import ilog.views.linkconnector.IlvPinLinkConnector;
import java.util.Enumeration;
import oracle.diagram.core.util.CoreGraphicUtils;
import oracle.diagram.framework.graphic.GraphicPin;
import oracle.diagram.framework.graphic.IMultipresentationView;
import oracle.diagram.framework.graphic.SubNodeGraphicPin;
import oracle.diagram.framework.link.LinkUtil;
import oracle.diagram.framework.link.policy.InvokablePolicy;
import oracle.diagram.framework.manager.ManagerUtil;
import oracle.diagram.framework.transformer.TransformerUtil;

public class SubShapePinLinkPolicy
extends IlvAbstractLinkShapePolicy
implements InvokablePolicy {
    public void onInstall(IlvLinkImage link) {
        this.adjustLink(link, false);
        super.onInstall(link);
    }

    public void afterAdd(IlvLinkImage link) {
        if (link.getGraphicBag() != null) {
            link.getGraphicBag().applyToObject((IlvGraphic)link, new IlvApplyObject(){

                public void apply(IlvGraphic graphic, Object obj) {
                    SubShapePinLinkPolicy.this.adjustLink((IlvLinkImage)graphic, false);
                }
            }, null, true);
        } else {
            this.adjustLink(link, false);
        }
        super.afterAdd(link);
    }

    public void afterInsertPoint(IlvLinkImage link, int i, IlvTransformer tx) {
        this.adjustLink(link, false);
        super.afterInsertPoint(link, i, tx);
    }

    public void afterMovePoint(IlvLinkImage link, int i, IlvTransformer tx) {
        this.adjustLink(link, false);
        super.afterMovePoint(link, i, tx);
    }

    public void afterRemovePoint(IlvLinkImage link, int i, IlvTransformer tx) {
        this.adjustLink(link, false);
        super.afterRemovePoint(link, i, tx);
    }

    public void afterToNodeMoved(IlvLinkImage link) {
        this.adjustLink(link, false);
        super.afterToNodeMoved(link);
    }

    public void afterSetIntermediateLinkPoints(IlvLinkImage link) {
        this.adjustLink(link, false);
        super.afterSetIntermediateLinkPoints(link);
    }

    public void afterApplyTransform(IlvLinkImage link, IlvTransformer tx) {
        this.adjustLink(link, false);
        super.afterApplyTransform(link, tx);
    }

    public void afterFromNodeMoved(IlvLinkImage link) {
        this.adjustLink(link, false);
        super.afterFromNodeMoved(link);
    }

    protected void adjustLink(IlvLinkImage link, boolean invoked) {
        GraphicPin fromPin = GraphicPin.findPin(link, true);
        GraphicPin toPin = GraphicPin.findPin(link, false);
        if (!(fromPin instanceof SubNodeGraphicPin) && !(toPin instanceof SubNodeGraphicPin) || fromPin == null || toPin == null) {
            return;
        }
        IlvPoint[] points = LinkUtil.getLinkPointsUnclipped(link, TransformerUtil.IDENTITY_TRANSFORMER);
        if (points.length < 2) {
            return;
        }
        if (fromPin instanceof SubNodeGraphicPin) {
            this.adjustEnd(link, points, true);
        }
        if (toPin instanceof SubNodeGraphicPin) {
            this.adjustEnd(link, points, false);
        }
    }

    @Override
    public void invoke(IlvLinkImage link) {
        this.adjustLink(link, true);
    }

    private IlvPoint getCenterPoint(IlvGraphic g) {
        IlvRect r = g.boundingBox();
        IlvPoint center = new IlvPoint((float)r.getCenterX(), (float)r.getCenterY());
        return center;
    }

    private void adjustEnd(IlvLinkImage link, IlvPoint[] points, boolean origin) {
        GraphicPin pinA = GraphicPin.findPin(link, origin);
        if (!(pinA instanceof SubNodeGraphicPin)) {
            return;
        }
        IlvManager linkMgr = ManagerUtil.getManager((IlvGraphic)link);
        IlvManager graphicBMgr = null;
        IlvPoint pointB = null;
        if (points.length == 2) {
            GraphicPin pinB = GraphicPin.findPin(link, !origin);
            if (pinB == null) {
                return;
            }
            IlvGraphic graphicB = pinB.getGraphic();
            IlvGraphic graphicBParent = CoreGraphicUtils.getManagedParentNode(graphicB);
            graphicBMgr = ManagerUtil.getManager(graphicBParent);
            pointB = this.getCenterPoint(graphicB);
        } else {
            pointB = points[origin ? 1 : points.length - 2];
        }
        IlvPinLinkConnector plc = (IlvPinLinkConnector)IlvLinkConnector.GetAttached((IlvLinkImage)link, (boolean)origin);
        if (plc == null) {
            return;
        }
        IlvGrapherPin currentPin = plc.getPin(link, origin);
        IlvGraphic graphicA = currentPin.getNode();
        IlvGraphic graphicAParent = CoreGraphicUtils.getManagedParentNode(graphicA);
        IlvManager graphicAMgr = ManagerUtil.getManager(graphicAParent);
        IlvTransformer graphicATrans = null;
        if (graphicAMgr != null && graphicBMgr != null && graphicAMgr != graphicBMgr) {
            if (linkMgr == null) {
                IlvManager bMgr = graphicBMgr instanceof IMultipresentationView ? ManagerUtil.getManager(CoreGraphicUtils.getManagedParentNode((IlvGraphic)graphicBMgr)) : graphicBMgr;
                IlvManager aMgr = graphicAMgr instanceof IMultipresentationView ? ManagerUtil.getManager(CoreGraphicUtils.getManagedParentNode((IlvGraphic)graphicAMgr)) : graphicAMgr;
                linkMgr = aMgr == bMgr ? aMgr : IlvGrapher.getLowestCommonGrapher((IlvGraphic)aMgr, (IlvGraphic)bMgr);
            }
            graphicATrans = ManagerUtil.getConversionTransformer(linkMgr, graphicAMgr);
            ManagerUtil.getConversionTransformer(linkMgr, graphicBMgr).apply(pointB);
        }
        float sqDistance = -1.0f;
        IlvGrapherPin nearestPin = null;
        Enumeration e = plc.getPins();
        while (e.hasMoreElements()) {
            IlvGrapherPin pin = (IlvGrapherPin)e.nextElement();
            IlvPoint pos = pin.getPosition(graphicATrans);
            float dx = pos.x - pointB.x;
            float dy = pos.y - pointB.y;
            float tmp = dx * dx + dy * dy;
            if (!(sqDistance < 0.0f) && !(tmp < sqDistance)) continue;
            sqDistance = tmp;
            nearestPin = pin;
        }
        if (nearestPin != null && nearestPin != currentPin) {
            plc.connectLink(link, nearestPin, origin);
        }
    }
}

