/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.interaction;

import ilog.views.IlvGraphic;
import ilog.views.IlvManager;
import java.util.HashMap;

public class InPlaceEditContext {
    private static final Object MANAGER_KEY = IlvManager.class;
    private static final Object MAIN_OBJECT_KEY = "__mainObject";
    private static final Object SUB_OBJECT_KEY = "__subObject";
    private static final Object UNDO_TRANS_KEY = "__undoTrans";
    private final HashMap<Object, Object> _properties;

    public InPlaceEditContext(IlvManager manager, IlvGraphic mainObject) {
        this(manager, mainObject, null);
    }

    public InPlaceEditContext(IlvManager manager, IlvGraphic mainObject, IlvGraphic subObject) {
        this._properties = new HashMap();
        this.setManager(manager);
        this.setMainObject(mainObject);
        this.setSubObject(subObject);
        this.setLocalUndoTransactions(true);
    }

    public InPlaceEditContext(InPlaceEditContext source) {
        this._properties = (HashMap)source._properties.clone();
    }

    public final void setProperty(Object property, Object value) {
        this._properties.put(property, value);
    }

    public final Object getProperty(Object property) {
        return this._properties.get(property);
    }

    public final boolean hasProperty(Object property) {
        return this._properties.containsKey(property);
    }

    public final void setManager(IlvManager manager) {
        this.setProperty(MANAGER_KEY, manager);
    }

    public final IlvManager getManager() {
        return (IlvManager)this.getProperty(MANAGER_KEY);
    }

    public final void setMainObject(IlvGraphic mainObject) {
        this.setProperty(MAIN_OBJECT_KEY, mainObject);
    }

    public final IlvGraphic getMainObject() {
        return (IlvGraphic)this.getProperty(MAIN_OBJECT_KEY);
    }

    public final void setSubObject(IlvGraphic subObject) {
        this.setProperty(SUB_OBJECT_KEY, subObject);
    }

    public final IlvGraphic getSubObject() {
        return (IlvGraphic)this.getProperty(SUB_OBJECT_KEY);
    }

    public final void setLocalUndoTransactions(boolean enabled) {
        this.setProperty(UNDO_TRANS_KEY, enabled);
    }

    public final boolean hasLocalUndoTransactions() {
        Boolean value = (Boolean)this.getProperty(UNDO_TRANS_KEY);
        return value;
    }
}

