/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.graphic.layout.column;

import ilog.views.IlvGraphic;
import ilog.views.IlvRect;
import oracle.diagram.framework.graphic.ExtendedGraphic;
import oracle.diagram.framework.graphic.layout.column.ColumnContainer;
import oracle.diagram.framework.graphic.undo.AbstractApplyObjectUndoableStep;
import oracle.diagram.framework.manager.ManagerUtil;

public class ResizeColumnUndoableStep
extends AbstractApplyObjectUndoableStep {
    private ColumnContainer m_container;
    private int m_columnIndex;
    private float m_undoWidth;
    private float m_redoWidth;

    public ResizeColumnUndoableStep(ColumnContainer container, int columnIndex) {
        super(ManagerUtil.getManagedAncestor((IlvGraphic)container));
        this.m_container = container;
        this.m_columnIndex = columnIndex;
    }

    @Override
    protected void undoImpl() {
        this.m_container.resizeColumn(this.m_columnIndex, this.m_undoWidth);
    }

    @Override
    protected void redoImpl() {
        this.m_container.resizeColumn(this.m_columnIndex, this.m_redoWidth);
    }

    @Override
    public void storeUndoState() {
        this.m_undoWidth = this.getColumnWidth();
    }

    @Override
    public void storeRedoState() {
        this.m_redoWidth = this.getColumnWidth();
    }

    private float getColumnWidth() {
        ExtendedGraphic column = this.m_container.getColumnGraphic(this.m_columnIndex);
        IlvRect bbox = ((IlvGraphic)column).boundingBox(null);
        return bbox.width;
    }
}

