/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.graphic.layout;

import ilog.views.IlvGraphic;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.graphic.IlvLine;
import ilog.views.graphic.composite.IlvCompositeGraphic;
import ilog.views.graphic.composite.layout.IlvAttachable;
import ilog.views.graphic.composite.layout.IlvAttachableGraphic;
import java.util.LinkedList;
import oracle.diagram.framework.geom.DimensionFloat;
import oracle.diagram.framework.graphic.ExtendedGraphic;
import oracle.diagram.framework.graphic.layout.AbstractLayout;
import oracle.diagram.framework.graphic.layout.Anchor;
import oracle.diagram.framework.graphic.layout.ExtendedLayoutManager;
import oracle.diagram.framework.graphic.layout.Fill;
import oracle.diagram.framework.graphic.layout.ListConstraint;
import oracle.diagram.framework.graphic.layout.UndoableLayout;
import oracle.diagram.framework.manager.ManagerUtil;
import oracle.diagram.framework.undo.AbstractUndoableStep;
import oracle.diagram.framework.undo.UndoableStep;

public class ListLayout
extends AbstractLayout
implements ExtendedLayoutManager,
UndoableLayout {
    private static final ListConstraint DEFAULT_CONSTRAINT = ListConstraint.create(Anchor.LEFT, Fill.NONE);
    private static final int PREFERRED_NUM_ROWS = 15;
    private static final int MINIMUM_NUM_ROWS = 4;
    private boolean _reweight;
    private float _lineSpacing;
    private int _firstVisibleIndex = 0;
    private int _visibleExtent = 1;
    private int m_preferredSizeMaxNumRows = 15;
    private int m_minimumSizeMaxNumRows = 4;

    public ListLayout() {
    }

    public ListLayout(float leftMargin, float topMargin) {
        this();
        this.setLeftTopMargins(leftMargin, topMargin);
    }

    public ListLayout(float leftMargin, float rightMargin, float topMargin, float bottomMargin) {
        this();
        this.setMargins(leftMargin, rightMargin, topMargin, bottomMargin);
    }

    @Override
    public void setConstraints(IlvAttachable element, Object constraints) {
        if (!(constraints instanceof ListConstraint)) {
            throw new IllegalStateException("List layout must have list constraints");
        }
        super.setConstraints(element, constraints);
    }

    public final int getVisibleExtent() {
        return this._visibleExtent;
    }

    public final int getFirstVisibleIndex() {
        return this._firstVisibleIndex;
    }

    public final void setFirstVisibleIndex(int index) {
        this._firstVisibleIndex = index;
    }

    public void setLineSpacing(float lineSpacing) {
        assert (lineSpacing >= 0.0f);
        this._lineSpacing = lineSpacing;
    }

    @Override
    public Object clone() {
        return this;
    }

    @Override
    public DimensionFloat getMinimumSize(DimensionFloat minimum, IlvAttachable[] children) {
        return this.calcNaturalSize(minimum, children, false, this.m_minimumSizeMaxNumRows);
    }

    @Override
    public DimensionFloat getPreferedSize(DimensionFloat prefered, IlvAttachable[] children) {
        return this.calcNaturalSize(prefered, children, true, this.m_preferredSizeMaxNumRows);
    }

    private DimensionFloat calcNaturalSize(DimensionFloat dimensions, IlvAttachable[] children, boolean prefered, int rows) {
        DimensionFloat temp = new DimensionFloat();
        dimensions.setSize(this._leftMargin + this._rightMargin, this._topMargin + this._bottomMargin);
        int skip = 0;
        for (IlvAttachable attachable : children) {
            IlvAttachableGraphic attachableGraphic;
            IlvGraphic child;
            if (skip == 0) {
                ++skip;
                continue;
            }
            if (skip > rows) break;
            ++skip;
            if (attachable == null || (child = (attachableGraphic = (IlvAttachableGraphic)attachable).getGraphic()) == null || !child.isVisible()) continue;
            if (child instanceof ExtendedGraphic) {
                if (prefered) {
                    ((ExtendedGraphic)child).getPreferedSize(temp);
                } else {
                    ((ExtendedGraphic)child).getMinimumSize(temp);
                }
            } else {
                temp.setSize(100.0f, 16.0f);
            }
            dimensions.setSize(Math.max(dimensions.getWidth(), temp.getWidth() + (double)this._leftMargin + (double)this._rightMargin), dimensions.getHeight() + (double)this._lineSpacing + temp.getHeight());
        }
        return dimensions;
    }

    public void layoutGroup(IlvAttachable parent) {
        IlvAttachable[] attached;
        if (this._reweight) {
            this.reweightConstraints((IlvCompositeGraphic)((IlvAttachableGraphic)parent).getGraphic());
            this._reweight = false;
        }
        if ((attached = parent.getAttachables()).length > 0) {
            IlvAttachableGraphic[] attachableGraphics = new IlvAttachableGraphic[attached.length - 1];
            for (int i = 1; i < attached.length; ++i) {
                attachableGraphics[i - 1] = (IlvAttachableGraphic)attached[i];
            }
            float fixedHeight = 0.0f;
            float totalWeight = 0.0f;
            DimensionFloat dim = new DimensionFloat();
            for (IlvAttachableGraphic ag : attachableGraphics) {
                IlvGraphic g = ag.getGraphic();
                ExtendedGraphic eg = (ExtendedGraphic)g;
                if (!g.isVisible()) continue;
                IlvAttachableGraphic[] c = (IlvAttachableGraphic[])this.getConstraint((IlvAttachable)ag);
                if (c == null) {
                    c = DEFAULT_CONSTRAINT;
                }
                if (c.getFill().isVertical()) {
                    totalWeight += c.getWeight();
                } else {
                    eg.getPreferedSize(dim);
                    fixedHeight += dim.height;
                }
                fixedHeight += this._lineSpacing;
            }
            IlvRect bounds = ((IlvAttachableGraphic)parent).getGraphic().boundingBox();
            float x = bounds.x + this._leftMargin;
            float y = bounds.y + this._topMargin;
            float availableWidth = bounds.width - this._leftMargin - this._rightMargin;
            float variableTotal = bounds.height - this._topMargin - this._bottomMargin - fixedHeight;
            float factor = variableTotal * (totalWeight == 0.0f ? 0.0f : 1.0f / totalWeight);
            for (IlvAttachableGraphic ag : attachableGraphics) {
                IlvGraphic g = ag.getGraphic();
                if (!g.isVisible()) continue;
                if (g instanceof IlvLine) {
                    IlvLine line = (IlvLine)g;
                    line.setFrom(new IlvPoint(bounds.x + this._leftMargin / 2.0f, y));
                    line.setTo(new IlvPoint(bounds.x + bounds.width - this._rightMargin / 2.0f, y));
                    y += line.getLineWidth();
                } else {
                    ExtendedGraphic eg = (ExtendedGraphic)g;
                    ListConstraint c = (ListConstraint)this.getConstraint((IlvAttachable)ag);
                    if (c == null) {
                        c = DEFAULT_CONSTRAINT;
                    }
                    eg.getPreferedSize(dim);
                    float offset = 0.0f;
                    float width = dim.width;
                    if (c.getFill().isHorizontal()) {
                        width = availableWidth;
                    } else {
                        switch (c.getAnchor()) {
                            case CENTER: {
                                if (!(width < availableWidth)) break;
                                offset = (availableWidth - width) / 2.0f;
                                break;
                            }
                            case RIGHT: {
                                offset = availableWidth - width;
                            }
                        }
                    }
                    float height = c.getFill().isVertical() ? c.getWeight() * factor : dim.height;
                    g.moveResize(new IlvRect(x + offset, y, width, height));
                    y += height;
                }
                y += this._lineSpacing;
            }
            float top = bounds.y + this._topMargin;
            float totalHeight = bounds.height - this._topMargin - this._bottomMargin;
            if (this._firstVisibleIndex > 0 && attachableGraphics.length > this._firstVisibleIndex) {
                IlvGraphic firstVisibleGraphic = attachableGraphics[this._firstVisibleIndex].getGraphic();
                IlvRect firstVisibleBBox = firstVisibleGraphic.boundingBox();
                float offset = (firstVisibleBBox.y - (bounds.y + this._topMargin)) * -1.0f;
                if (y + offset < top + totalHeight) {
                    float newOffset = top + totalHeight - y;
                    float delta = newOffset - offset;
                    do {
                        int index = this._firstVisibleIndex - 1;
                        IlvGraphic g = attachableGraphics[index].getGraphic();
                        IlvRect gbbox = g.boundingBox();
                        float gheight = gbbox.height + this._lineSpacing;
                        if (!((delta -= gheight) >= 0.0f)) continue;
                        this._firstVisibleIndex = index;
                    } while (!(delta < 0.0f) && this._firstVisibleIndex != 0);
                    if (this._firstVisibleIndex == 0) {
                        newOffset = (attachableGraphics[this._firstVisibleIndex].getGraphic().boundingBox().y - (bounds.y + this._topMargin)) * -1.0f;
                    }
                    offset = newOffset;
                }
                for (IlvAttachableGraphic ag : attachableGraphics) {
                    IlvGraphic g = ag.getGraphic();
                    if (!g.isVisible()) continue;
                    g.translate(0.0f, offset);
                }
            }
            this._visibleExtent = 0;
            for (int i = this._firstVisibleIndex; i < attachableGraphics.length; ++i) {
                IlvGraphic g = attachableGraphics[i].getGraphic();
                IlvRect gbbox = g.boundingBox();
                float gheight = gbbox.height + this._lineSpacing;
                if ((totalHeight -= gheight) < 0.0f) break;
                ++this._visibleExtent;
            }
            this._visibleExtent = Math.max(this._visibleExtent, 1);
            this.fireLayoutPerformed(((IlvAttachableGraphic)parent).getGraphic());
        }
    }

    public int getResizable(IlvGraphic divider, boolean after) {
        IlvCompositeGraphic parent = (IlvCompositeGraphic)divider.getGraphicBag();
        int position = parent.getIndex(divider);
        int inc = after ? 1 : -1;
        int end = after ? parent.getCardinal() : 0;
        for (int i = position + inc; after && i < end || !after && i > end; i += inc) {
            IlvGraphic child;
            ListConstraint c = (ListConstraint)parent.getConstraints(i);
            if (c == null || !c.getFill().isVertical() || !(child = parent.getChildren(i)).isVisible()) continue;
            return i;
        }
        return -1;
    }

    public void resizeDivider(IlvGraphic divider, float offset, boolean preserveHeight) {
        if (offset == 0.0f) {
            return;
        }
        IlvCompositeGraphic parent = (IlvCompositeGraphic)divider.getGraphicBag();
        int before = this.getResizable(divider, false);
        int after = this.getResizable(divider, true);
        if (before == -1 || after == -1) {
            return;
        }
        float beforeHeight = parent.getChildren((int)before).boundingBox().height;
        float afterHeight = parent.getChildren((int)after).boundingBox().height;
        float totalHeight = beforeHeight + afterHeight;
        if (offset < 0.0f) {
            if (beforeHeight < -offset) {
                offset = -beforeHeight;
            }
        } else if (afterHeight < offset) {
            offset = afterHeight;
        }
        ListConstraint bc = (ListConstraint)parent.getConstraints(before);
        ListConstraint ac = (ListConstraint)parent.getConstraints(after);
        float totalWeight = bc.getWeight() + ac.getWeight();
        if (!preserveHeight) {
            totalHeight += Math.abs(offset);
        }
        float newBeforeWeight = (beforeHeight + offset) * totalWeight / totalHeight;
        newBeforeWeight = Math.min(totalWeight, Math.max(0.0f, newBeforeWeight));
        parent.setConstraints(before, (Object)bc.derive(newBeforeWeight));
        parent.setConstraints(after, (Object)ac.derive(totalWeight - newBeforeWeight));
        parent.invalidate();
        parent.doLayout();
    }

    public void reweight() {
        this._reweight = true;
    }

    private void reweightConstraints(IlvCompositeGraphic parent) {
        ListConstraint c;
        int i;
        float totalWeight = 0.0f;
        float totalHeight = 0.0f;
        DimensionFloat dim = new DimensionFloat();
        for (i = parent.getCardinal() - 1; i > 0; --i) {
            c = (ListConstraint)parent.getConstraints(i);
            if (c == null || !c.getFill().isVertical()) continue;
            totalWeight += c.getWeight();
            ExtendedGraphic child = (ExtendedGraphic)parent.getChildren(i);
            child.getPreferedSize(dim);
            totalHeight += dim.height;
        }
        for (i = parent.getCardinal() - 1; i > 0; --i) {
            c = (ListConstraint)parent.getConstraints(i);
            if (c == null || !c.getFill().isVertical()) continue;
            ((ExtendedGraphic)parent.getChildren(i)).getPreferedSize(dim);
            float weight = totalHeight == 0.0f ? 1.0f : dim.height * totalWeight / totalHeight;
            parent.setConstraints(i, (Object)c.derive(weight));
        }
    }

    public void setPreferredSizeMaxNumRows(int numRows) {
        this.m_preferredSizeMaxNumRows = numRows;
    }

    public int getPreferredSizeMaxNumRows() {
        return this.m_preferredSizeMaxNumRows;
    }

    public void setMinimumSizeMaxNumRows(int numRows) {
        this.m_minimumSizeMaxNumRows = numRows;
    }

    public int getMinimumSizeMaxNumRows() {
        return this.m_minimumSizeMaxNumRows;
    }

    @Override
    public UndoableStep createUndoableStep(IlvCompositeGraphic owner) {
        return new ListLayoutUndoableStep(owner);
    }

    protected static class ListLayoutUndoableStep
    extends AbstractUndoableStep {
        private final IlvCompositeGraphic _owner;
        private Object[] _oldConstraints;
        private Object[] _newConstraints;
        private int _oldFirstVisibleIndex;
        private int _newFirstVisibleIndex;
        private LinkedList<UndoableStep> _childrenUndoableSteps;

        public ListLayoutUndoableStep(IlvCompositeGraphic owner) {
            this._owner = owner;
            this._oldFirstVisibleIndex = 0;
            this._newFirstVisibleIndex = 0;
        }

        @Override
        public void storeUndoState() {
            this._oldConstraints = this.getConstraints();
            this._oldFirstVisibleIndex = this.getFirstVisibleIndex();
            if (this._childrenUndoableSteps == null) {
                this._childrenUndoableSteps = this.getChildrenUndoableSteps();
            }
            for (UndoableStep step : this._childrenUndoableSteps) {
                step.storeUndoState();
            }
        }

        @Override
        public void storeRedoState() {
            this._newConstraints = this.getConstraints();
            this._newFirstVisibleIndex = this.getFirstVisibleIndex();
            for (UndoableStep step : this._childrenUndoableSteps) {
                step.storeRedoState();
            }
        }

        @Override
        public void undo() {
            this.setConstraints(this._oldConstraints);
            this.setFirstVisibleIndex(this._oldFirstVisibleIndex);
            for (UndoableStep step : this._childrenUndoableSteps) {
                try {
                    step.undo();
                }
                catch (Throwable t) {
                    System.out.println(t);
                }
            }
        }

        @Override
        public void redo() {
            this.setConstraints(this._newConstraints);
            this.setFirstVisibleIndex(this._newFirstVisibleIndex);
            for (UndoableStep step : this._childrenUndoableSteps) {
                try {
                    step.redo();
                }
                catch (Throwable t) {
                    System.out.println(t);
                }
            }
        }

        private LinkedList<UndoableStep> getChildrenUndoableSteps() {
            IlvGraphic[] children;
            LinkedList<UndoableStep> steps = new LinkedList<UndoableStep>();
            for (IlvGraphic child : children = this.getGraphic().getChildren()) {
                if (!(child instanceof IlvCompositeGraphic) || !(((IlvCompositeGraphic)child).getLayout() instanceof UndoableLayout)) continue;
                UndoableLayout layout = (UndoableLayout)((IlvCompositeGraphic)child).getLayout();
                steps.add(layout.createUndoableStep((IlvCompositeGraphic)child));
            }
            return steps;
        }

        private int getFirstVisibleIndex() {
            ListLayout layout = (ListLayout)this.getGraphic().getLayout();
            return layout.getFirstVisibleIndex();
        }

        private void setFirstVisibleIndex(int index) {
            ListLayout layout = (ListLayout)this.getGraphic().getLayout();
            if (layout.getFirstVisibleIndex() != index) {
                layout.setFirstVisibleIndex(index);
            }
        }

        private Object[] getConstraints() {
            Object[] constraints = this._owner.getConstraints();
            return constraints == null ? null : (Object[])constraints.clone();
        }

        private void setConstraints(Object[] constraints) {
            this._owner.setConstraints(constraints == null ? null : (Object[])constraints.clone());
            this.layout();
        }

        protected final IlvCompositeGraphic getGraphic() {
            return this._owner;
        }

        protected void layout() {
            this.getGraphic().invalidate();
            this.getGraphic().doLayout();
            ManagerUtil.invalidateRegion((IlvGraphic)this.getGraphic());
        }
    }
}

