/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.graphic.layout;

import ilog.views.IlvGraphic;
import ilog.views.graphic.composite.layout.IlvAttachable;
import ilog.views.graphic.composite.layout.IlvLayoutManager;
import ilog.views.io.IlvOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.diagram.framework.graphic.layout.LayoutListener;

public abstract class AbstractLayout
implements IlvLayoutManager {
    protected float _leftMargin = 2.0f;
    protected float _rightMargin = 2.0f;
    protected float _topMargin = 2.0f;
    protected float _bottomMargin = 2.0f;
    private Map<IlvAttachable, Object> m_attachableToConstraints = new HashMap<IlvAttachable, Object>();
    private Map<Object, IlvAttachable> m_constraintsToAttachable = new HashMap<Object, IlvAttachable>();
    private List<LayoutListener> _listeners;

    public final void write(IlvOutputStream stream) {
    }

    public Object clone() {
        throw new UnsupportedOperationException();
    }

    public void setLeftTopMargins(float leftMargin, float topMargin) {
        assert (leftMargin >= 0.0f);
        assert (topMargin >= 0.0f);
        this._leftMargin = leftMargin;
        this._topMargin = topMargin;
    }

    public void setLeftRightMargins(float leftMargin, float rightMargin) {
        assert (leftMargin >= 0.0f);
        assert (rightMargin >= 0.0f);
        this._leftMargin = leftMargin;
        this._rightMargin = rightMargin;
    }

    public void setMargins(float leftMargin, float rightMargin, float topMargin, float bottomMargin) {
        assert (leftMargin >= 0.0f);
        assert (topMargin >= 0.0f);
        assert (rightMargin >= 0.0f);
        assert (bottomMargin >= 0.0f);
        this._leftMargin = leftMargin;
        this._topMargin = topMargin;
        this._bottomMargin = bottomMargin;
        this._rightMargin = rightMargin;
    }

    public final float getLeftMargin() {
        return this._leftMargin;
    }

    public final float getRightMargin() {
        return this._rightMargin;
    }

    public final float getTopMargin() {
        return this._topMargin;
    }

    public final float getBottomMargin() {
        return this._bottomMargin;
    }

    public void setConstraints(IlvAttachable element, Object constraints) {
        this.m_attachableToConstraints.put(element, constraints);
        if (constraints != null) {
            this.m_constraintsToAttachable.put(constraints, element);
        }
    }

    public Object getConstraint(IlvAttachable element) {
        return this.m_attachableToConstraints.get(element);
    }

    public IlvAttachable getAttachable(Object constraint) {
        return this.m_constraintsToAttachable.get(constraint);
    }

    public boolean resizeFirstChildOnly() {
        return true;
    }

    public void attach(IlvAttachable parent) {
        IlvAttachable[] attachable = parent.getAttachables();
        Object[] obj = parent.getConstraints();
        if (obj != null) {
            for (int j = 1; j < attachable.length && j < obj.length; ++j) {
                if (obj[j] == null || attachable[j] == null) continue;
                this.setConstraints(attachable[j], obj[j]);
            }
        }
    }

    public void reset() {
        this.m_attachableToConstraints.clear();
        this.m_constraintsToAttachable.clear();
    }

    public void removeConstraints(IlvAttachable element) {
        Object constraint = this.getConstraint(element);
        this.m_attachableToConstraints.remove(element);
        if (constraint != null) {
            this.m_constraintsToAttachable.remove(constraint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addLayoutListener(LayoutListener listener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList<LayoutListener>(5);
        }
        List<LayoutListener> list = this._listeners;
        synchronized (list) {
            if (!this._listeners.contains(listener)) {
                this._listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeLayoutListener(LayoutListener listener) {
        if (this._listeners != null) {
            List<LayoutListener> list = this._listeners;
            synchronized (list) {
                this._listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireLayoutPerformed(IlvGraphic container) {
        if (this._listeners != null) {
            List<LayoutListener> list = this._listeners;
            synchronized (list) {
                for (LayoutListener l : this._listeners) {
                    l.layoutPerformed(container);
                }
            }
        }
    }
}

