/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.graphic.features;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collection;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.plugin.Plugin;
import oracle.diagram.core.plugin.PluginManager;
import oracle.diagram.framework.graphic.features.AlignFormat;
import oracle.diagram.framework.graphic.features.AlignPanel;
import oracle.diagram.framework.graphic.features.AlignPlugin;
import oracle.diagram.framework.graphic.features.BatchGraphic;
import oracle.ide.Ide;

public class DefaultAlignPlugin
implements AlignPlugin {
    private AlignFormat _aFormat = new AlignFormat(AlignFormat.VerticalMode.NONE, AlignFormat.HorizontalMode.NONE, false, false);
    private final DiagramContext _context;

    public DefaultAlignPlugin(DiagramContext context) {
        this._context = context;
    }

    @Override
    public void setAlignFormat(AlignFormat aFormat) {
        this._aFormat = aFormat;
    }

    @Override
    public AlignFormat getAlignFormat() {
        return this._aFormat;
    }

    @Override
    public boolean configureAlign() {
        AlignPanel aPanel = new AlignPanel();
        if (aPanel.showDialog((Frame)Ide.getMainWindow())) {
            this._aFormat = aPanel.getAlignFormat();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void align() {
        float minAlignX = 0.0f;
        float maxAlignX = 0.0f;
        float minAlignY = 0.0f;
        float maxAlignY = 0.0f;
        IlvManager manager = this.getDiagramContext().getManagerView().getManager();
        IlvGraphicEnumeration selection = manager.getSelectedObjects(true);
        ArrayList<BatchGraphic> col = new ArrayList<BatchGraphic>();
        float sumWidth = 0.0f;
        float sumHeight = 0.0f;
        boolean first = true;
        while (selection.hasMoreElements()) {
            IlvGraphic element = selection.nextElement();
            if (element instanceof IlvLinkImage) continue;
            BatchGraphic bGraph = new BatchGraphic(element);
            col.add(bGraph);
            if (first) {
                minAlignY = bGraph.rect.y;
                maxAlignY = bGraph.rect.y + bGraph.rect.height;
                minAlignX = bGraph.rect.x;
                maxAlignX = bGraph.rect.x + bGraph.rect.width;
                first = false;
            } else {
                minAlignY = Math.min(minAlignY, bGraph.rect.y);
                maxAlignY = Math.max(maxAlignY, bGraph.rect.y + bGraph.rect.height);
                minAlignX = Math.min(minAlignX, bGraph.rect.x);
                maxAlignX = Math.max(maxAlignX, bGraph.rect.x + bGraph.rect.width);
            }
            sumWidth += bGraph.rect.width;
            sumHeight += bGraph.rect.height;
        }
        float averageWidth = sumWidth / (float)col.size();
        float averageHeight = sumHeight / (float)col.size();
        for (BatchGraphic bElt : col) {
            if (this._aFormat.isAdjustWidth()) {
                bElt.rect.width = averageWidth;
            }
            if (this._aFormat.isAdjustHeight()) {
                bElt.rect.height = averageHeight;
            }
            switch (this._aFormat.getHorizontalMode()) {
                case TOP: {
                    bElt.rect.y = minAlignY;
                    break;
                }
                case CENTER: {
                    bElt.rect.y = (maxAlignY + minAlignY) / 2.0f - bElt.rect.height / 2.0f;
                    break;
                }
                case BOTTOM: {
                    bElt.rect.y = maxAlignY - bElt.rect.height;
                }
            }
            switch (this._aFormat.getVerticalMode()) {
                case LEFT: {
                    bElt.rect.x = minAlignX;
                    break;
                }
                case CENTER: {
                    bElt.rect.x = (maxAlignX + minAlignX) / 2.0f - bElt.rect.width / 2.0f;
                    break;
                }
                case RIGHT: {
                    bElt.rect.x = maxAlignX - bElt.rect.width;
                }
            }
        }
        try {
            manager.initReDraws();
            manager.setContentsAdjusting(true);
            this.applyChanges(col);
        }
        finally {
            manager.setContentsAdjusting(false);
            manager.reDrawViews();
        }
    }

    protected void applyChanges(Collection<BatchGraphic> batch) {
        for (BatchGraphic elt : batch) {
            elt.applyChanges();
        }
    }

    @Override
    public void attach(PluginManager pluginManager, Class<? extends Plugin> pluginType) {
    }

    @Override
    public void detach(PluginManager pluginManager, Class<? extends Plugin> pluginType) {
    }

    protected final DiagramContext getDiagramContext() {
        return this._context;
    }
}

