/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.geom;

public class Vector2DUtil {
    public static void diff(float ux, float uy, float vx, float vy, float[] w) {
        w[0] = ux - vx;
        w[1] = uy - vy;
    }

    public static float cross(float[] u, float[] v) {
        return u[0] * v[1] - u[1] * v[0];
    }

    public static float mod(float ux, float uy) {
        return (float)Math.sqrt(ux * ux + uy * uy);
    }

    public static float dot(float[] u, float[] v) {
        return u[0] * v[0] + u[1] * v[1];
    }

    public static float dot(float ux, float uy, float vx, float vy) {
        return ux * vx + uy * vy;
    }

    public static void unit(float ux, float uy, float[] unit) {
        float modulus = Vector2DUtil.mod(ux, uy);
        unit[0] = ux / modulus;
        unit[1] = uy / modulus;
    }

    public static void rot(float cx, float cy, float vx, float vy, double rad, float[] w) {
        double px = vx - cx;
        double py = vy - cy;
        double cosine = Math.cos(rad);
        double sine = Math.sin(rad);
        w[0] = (float)(px * cosine - py * sine);
        w[1] = (float)(px * sine + py * cosine);
    }

    public static void rot(float cx, float cy, float vx, float vy, double cosAlpha, double sinAlpha, float[] w) {
        double px = vx - cx;
        double py = vy - cy;
        w[0] = (float)(px * cosAlpha - py * sinAlpha);
        w[1] = (float)(px * sinAlpha + py * cosAlpha);
    }

    public static void normal(float[] u, float[] n) {
        Vector2DUtil.rot(0.0f, 0.0f, u[0], u[1], 0.0, 1.0, n);
    }

    public static boolean isNull(float[] v) {
        return (double)v[0] == 0.0 && (double)v[1] == 0.0;
    }

    public static boolean isNormal(float[] u, float[] v) {
        return Vector2DUtil.dot(u, v) == 0.0f;
    }
}

