/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.geom;

import ilog.views.IlvPoint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public final class GeomUtil {
    private GeomUtil() {
    }

    public static IlvPoint getIntersectionPoint(Point2D.Float p1, Point2D.Float p2, Point2D.Float p3, Point2D.Float p4) {
        double x3_x4;
        double x1 = p1.getX();
        double y1 = p1.getY();
        double x2 = p2.getX();
        double y2 = p2.getY();
        double x1_x2 = x1 - x2;
        double y1_y2 = y1 - y2;
        double x3 = p3.getX();
        double y3 = p3.getY();
        double x4 = p4.getX();
        double y4 = p4.getY();
        double y3_y4 = y3 - y4;
        double detdiv = x1_x2 * y3_y4 - y1_y2 * (x3_x4 = x3 - x4);
        if (detdiv == 0.0) {
            return null;
        }
        double det12 = x1 * y2 - y1 * x2;
        double det34 = x3 * y4 - y3 * x4;
        double x = (det12 * x3_x4 - x1_x2 * det34) / detdiv;
        double y = (det12 * y3_y4 - y1_y2 * det34) / detdiv;
        return new IlvPoint((float)x, (float)y);
    }

    public static Intersection getRectangularIntersection(Rectangle2D.Float r, Point2D.Float pointA, Point2D.Float pointB) {
        return GeomUtil.getRectangularIntersection(r, pointA, pointB, null);
    }

    public static Intersection getRectangularIntersection(Rectangle2D.Float r, Point2D.Float pointA, Point2D.Float pointB, Point2D.Float result) {
        float x = r.x;
        float y = r.y;
        float x1 = r.x + r.width;
        float y1 = r.y + r.height;
        Point2D.Float p1 = new Point2D.Float(x, y);
        Point2D.Float p2 = new Point2D.Float(x1, y);
        Point2D.Float p3 = new Point2D.Float(x, y1);
        Point2D.Float p4 = new Point2D.Float(x1, y1);
        IlvPoint pT = GeomUtil.getIntersectionPoint(pointA, pointB, p1, p2);
        IlvPoint pB = GeomUtil.getIntersectionPoint(pointA, pointB, p3, p4);
        IlvPoint pL = GeomUtil.getIntersectionPoint(pointA, pointB, p1, p3);
        IlvPoint pR = GeomUtil.getIntersectionPoint(pointA, pointB, p2, p4);
        float[] dists = new float[4];
        for (int i = 0; i < dists.length; ++i) {
            dists[i] = Float.MAX_VALUE;
        }
        if (pT != null && GeomUtil.isWithinRange(pT.x, p1.x, p2.x)) {
            dists[0] = GeomUtil.squareDistance((Point2D.Float)pT, pointA);
        }
        if (pB != null && GeomUtil.isWithinRange(pB.x, p3.x, p4.x)) {
            dists[1] = GeomUtil.squareDistance((Point2D.Float)pB, pointA);
        }
        if (pL != null && GeomUtil.isWithinRange(pL.y, p1.y, p3.y)) {
            dists[2] = GeomUtil.squareDistance((Point2D.Float)pL, pointA);
        }
        if (pR != null && GeomUtil.isWithinRange(pR.y, p2.y, p4.y)) {
            dists[3] = GeomUtil.squareDistance((Point2D.Float)pR, pointA);
        }
        int chosen = -1;
        float min = Float.MAX_VALUE;
        for (int i = 0; i < dists.length; ++i) {
            float v = dists[i];
            if (!(v < min)) continue;
            chosen = i;
            min = v;
        }
        switch (chosen) {
            case 0: {
                if (result != null) {
                    result.setLocation(pT.x, pT.y);
                }
                return Intersection.TOP;
            }
            case 1: {
                if (result != null) {
                    result.setLocation(pB.x, pB.y);
                }
                return Intersection.BOTTOM;
            }
            case 2: {
                if (result != null) {
                    result.setLocation(pL.x, pL.y);
                }
                return Intersection.LEFT;
            }
            case 3: {
                if (result != null) {
                    result.setLocation(pR.x, pR.y);
                }
                return Intersection.RIGHT;
            }
        }
        if (result != null) {
            result.setLocation(0.0f, 0.0f);
        }
        return Intersection.NONE;
    }

    private static final boolean isWithinRange(float f1, float f2, float f3) {
        return f1 >= Math.min(f2, f3) && f1 <= Math.max(f2, f3);
    }

    private static final float squareDistance(Point2D.Float a, Point2D.Float b) {
        return (b.x - a.x) * (b.x - a.x) + (b.y - a.y) * (b.y - a.y);
    }

    public static float[] getRangeIntersection(float low1, float high1, float low2, float high2) {
        float[] intersection = null;
        if (low1 <= low2) {
            if (high1 >= low2) {
                intersection = new float[2];
                intersection[0] = low2;
                intersection[1] = high1 >= high2 ? high2 : high1;
            }
        } else if (low1 <= high2) {
            intersection = new float[]{low1, high1 >= high2 ? high2 : high1};
        }
        return intersection;
    }

    public static enum Intersection {
        NONE,
        TOP,
        BOTTOM,
        LEFT,
        RIGHT;

    }
}

