/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.editor;

import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewDecoration;
import ilog.views.event.ManagerChangedEvent;
import ilog.views.event.ManagerChangedListener;
import ilog.views.event.ManagerSelectionChangedEvent;
import ilog.views.event.ManagerSelectionListener;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.swing.IlvToolTipManager;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.dnd.DropTargetListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.editor.Diagram;
import oracle.diagram.core.interaction.SelectionChangeNotificationPlugin;
import oracle.diagram.core.plugin.PluginUtil;
import oracle.diagram.framework.accessibility.AccessibleManagerView;
import oracle.diagram.framework.action.handler.AlignHandler;
import oracle.diagram.framework.action.handler.BringToFrontHandler;
import oracle.diagram.framework.action.handler.ClearPrintAreaHandler;
import oracle.diagram.framework.action.handler.CopyHandler;
import oracle.diagram.framework.action.handler.CutHandler;
import oracle.diagram.framework.action.handler.DistributeHandler;
import oracle.diagram.framework.action.handler.InPlaceEditHandler;
import oracle.diagram.framework.action.handler.PasteHandler;
import oracle.diagram.framework.action.handler.PrintHandler;
import oracle.diagram.framework.action.handler.PrintPreviewHandler;
import oracle.diagram.framework.action.handler.PrintSetupHandler;
import oracle.diagram.framework.action.handler.PublishHandler;
import oracle.diagram.framework.action.handler.SaveAsHandler;
import oracle.diagram.framework.action.handler.SaveHandler;
import oracle.diagram.framework.action.handler.SelectInNavigatorHandler;
import oracle.diagram.framework.action.handler.SendToBackHandler;
import oracle.diagram.framework.action.handler.SetPrintAreaHandler;
import oracle.diagram.framework.action.handler.StraightenLinkHandler;
import oracle.diagram.framework.action.handler.ZoomFitToWindowHandler;
import oracle.diagram.framework.action.handler.ZoomInHandler;
import oracle.diagram.framework.action.handler.ZoomOutHandler;
import oracle.diagram.framework.action.handler.ZoomPercentageHandler;
import oracle.diagram.framework.action.handler.ZoomSelectedHandler;
import oracle.diagram.framework.controller.ControllerChain;
import oracle.diagram.framework.controller.DiagramController;
import oracle.diagram.framework.dragdrop.DropTargetHelper;
import oracle.diagram.framework.dragdrop.ManagerViewDragAndDropController;
import oracle.diagram.framework.editor.AbstractDiagramDTSettingsPlugin;
import oracle.diagram.framework.editor.DiagramDTSettingsPlugin;
import oracle.diagram.framework.graphic.features.AlignPlugin;
import oracle.diagram.framework.graphic.features.DefaultAlignPlugin;
import oracle.diagram.framework.graphic.features.DefaultDistributePlugin;
import oracle.diagram.framework.graphic.features.DefaultZOrderPlugin;
import oracle.diagram.framework.graphic.features.DistributePlugin;
import oracle.diagram.framework.graphic.features.ZOrderPlugin;
import oracle.diagram.framework.interaction.AlignmentRulersPlugin;
import oracle.diagram.framework.interaction.DefaultAlignmentRulersPlugin;
import oracle.diagram.framework.interaction.DefaultInPlaceEditPlugin;
import oracle.diagram.framework.interaction.InPlaceEditPlugin;
import oracle.diagram.framework.link.features.DefaultStraightenLinkPlugin;
import oracle.diagram.framework.link.features.StraightenLinkPlugin;
import oracle.diagram.framework.notification.NotificationCenter;
import oracle.diagram.framework.palette.PalettePlugin;
import oracle.diagram.framework.print.DefaultPrintPlugin;
import oracle.diagram.framework.print.PrintPlugin;
import oracle.diagram.framework.publish.AbstractPublishPlugin;
import oracle.diagram.framework.publish.PublishPlugin;
import oracle.diagram.framework.selection.SubSelectionChangedEvent;
import oracle.diagram.framework.selection.SubSelectionListener;
import oracle.diagram.framework.selection.SubSelectionManager;
import oracle.diagram.framework.testability.ComponentNameLookupPlugin;
import oracle.diagram.framework.testability.ComponentPositioningServicePlugin;
import oracle.diagram.framework.testability.DefaultComponentNameLookupPlugin;
import oracle.diagram.framework.testability.DefaultComponentPositioningServicePlugin;
import oracle.diagram.framework.view.HintTextViewDecoration;
import oracle.diagram.res.DiagramResources;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.editor.OpenAbortedException;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public abstract class CommonDiagram
extends Diagram {
    protected static final ControllerChain COMMON_FALLBACK_CONTROLLER = new ControllerChain(new ZoomInHandler(), new ZoomOutHandler(), new ZoomPercentageHandler(), new ZoomSelectedHandler(), new ZoomFitToWindowHandler(), new InPlaceEditHandler(), new CopyHandler(), new CutHandler(), new PasteHandler(), new PrintHandler(), new PublishHandler(), new PrintSetupHandler(), new PrintPreviewHandler(), new SetPrintAreaHandler(), new ClearPrintAreaHandler(), new DistributeHandler(), new AlignHandler(), new BringToFrontHandler(), new SendToBackHandler(), new StraightenLinkHandler(), new SelectInNavigatorHandler(), new SaveHandler(), new SaveAsHandler());
    private final Controller _controller;
    private Object _graphSystemObject;
    private IlvManagerView _view;
    private IlvSDMEngine _engine;
    private ManagerViewDragAndDropController _dndController = null;
    private final SelectionListener _selListener = new SelectionListener();
    private final ManagerChangedListener _mgrListener = new ManagerChangedListener(){

        public void managerChanged(ManagerChangedEvent mce) {
            if (mce.getOldValue() != null) {
                mce.getOldValue().removeManagerTreeSelectionListener((ManagerSelectionListener)CommonDiagram.this._selListener);
                SubSelectionManager.getInstance().removeSubSelectionListener(mce.getOldValue(), CommonDiagram.this._selListener);
            }
            if (mce.getNewValue() != null) {
                mce.getNewValue().addManagerTreeSelectionListener((ManagerSelectionListener)CommonDiagram.this._selListener);
                SubSelectionManager.getInstance().addSubSelectionListener(mce.getNewValue(), CommonDiagram.this._selListener);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CommonDiagram.this.updateHostSelection();
                    }
                });
            }
        }
    };
    private boolean _layoutRestored = false;
    private HintTextViewDecoration _hintTextDecoration = null;
    private boolean _initialActivation = true;

    public CommonDiagram() {
        DiagramContext dc = this.getDiagramContext();
        this._controller = new DiagramController(COMMON_FALLBACK_CONTROLLER);
        AbstractDiagramDTSettingsPlugin dtsp = new AbstractDiagramDTSettingsPlugin(dc){

            @Override
            protected URL getDocumentURL() {
                return CommonDiagram.this.getContext().getNode().getURL();
            }
        };
        dc.addPlugin(DiagramDTSettingsPlugin.class, dtsp);
        NotificationCenter notificationCenter = new NotificationCenter();
        dc.addPlugin(NotificationCenter.class, notificationCenter);
    }

    @Override
    public void open() {
        this._layoutRestored = false;
        Context ctxt = this.getContext();
        DiagramContext dc = this.getDiagramContext();
        try {
            Object graph = null;
            try {
                if (this._graphSystemObject != null) {
                    graph = this._graphSystemObject;
                    this._graphSystemObject = null;
                } else {
                    graph = this.findOrCreateGraphSystemFromContext(ctxt);
                }
            }
            catch (OpenAbortedException oae) {
                ResourceBundle rb = DiagramResources.getBundle();
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)oae.getMessage(), (String)rb.getString("DiagramOpenDialog.title"), null);
                throw oae;
            }
            catch (Exception ex) {
                ResourceBundle rb = DiagramResources.getBundle();
                String message = ex.getMessage();
                message = message == null || "".equals(message) ? rb.getString("DiagramOpenDialogNonSpecific.text") : MessageFormat.format(rb.getString("DiagramOpenDialog.text"), ex.getLocalizedMessage());
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)ex, (String)rb.getString("DiagramOpenDialog.title"), (String)message, (String)"f1_dgmderroropeningdiagram_html");
                throw ex;
            }
            if (graph == null) {
                throw new OpenAbortedException();
            }
            IlvManager manager = null;
            if (graph instanceof IlvSDMEngine) {
                this._engine = (IlvSDMEngine)graph;
                manager = this._engine.getGrapher();
            } else if (graph instanceof IlvManager) {
                manager = (IlvManager)graph;
                this._engine = null;
            } else {
                throw new IllegalStateException("Expected an IlvManager or an IlvSDMEngine");
            }
            manager.addManagerTreeSelectionListener((ManagerSelectionListener)this._selListener);
            SubSelectionManager.getInstance().addSubSelectionListener(manager, this._selListener);
            this._view = this.createManagerView(manager);
            this._view.addManagerChangedListener(this._mgrListener);
            this.getDiagramContext().setManagerView(this._view);
            this._view.setFocusable(true);
            this._view.setWheelZoomingEnabled(true);
            this._view.setWheelZoomingInverted(true);
            IlvToolTipManager.registerView((IlvManagerView)this._view);
            this._view.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    if ((e.getChangeFlags() & 1L) != 0L && CommonDiagram.this._dndController == null) {
                        CommonDiagram.this._dndController = CommonDiagram.this.createDragAndDropController();
                        CommonDiagram.this._view.removeHierarchyListener((HierarchyListener)this);
                    }
                }
            });
            dc.addPlugin(PrintPlugin.class, new DefaultPrintPlugin(dc));
            AbstractPublishPlugin pp = new AbstractPublishPlugin(dc){

                @Override
                protected IlvManagerView createPublishingView(IlvManager mgr) {
                    return CommonDiagram.this.createManagerView(mgr);
                }
            };
            dc.addPlugin(PublishPlugin.class, pp);
            dc.addPlugin(InPlaceEditPlugin.class, new DefaultInPlaceEditPlugin(dc));
            dc.addPlugin(ZOrderPlugin.class, new DefaultZOrderPlugin(dc));
            dc.addPlugin(DistributePlugin.class, new DefaultDistributePlugin(dc));
            dc.addPlugin(AlignPlugin.class, new DefaultAlignPlugin(dc));
            dc.addPlugin(StraightenLinkPlugin.class, new DefaultStraightenLinkPlugin(dc));
            dc.addPlugin(AlignmentRulersPlugin.class, new DefaultAlignmentRulersPlugin(dc));
            DefaultComponentNameLookupPlugin nameLookup = new DefaultComponentNameLookupPlugin(dc);
            dc.addPlugin(ComponentNameLookupPlugin.class, nameLookup);
            dc.addPlugin(ComponentPositioningServicePlugin.class, new DefaultComponentPositioningServicePlugin(dc, nameLookup));
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (CommonDiagram.this._view != null) {
                        String hintString;
                        DiagramDTSettingsPlugin dtsp;
                        if (!CommonDiagram.this._layoutRestored && (dtsp = CommonDiagram.this.getDiagramContext().getPlugin(DiagramDTSettingsPlugin.class)) != null) {
                            CommonDiagram.this.loadSettings(dtsp.getPropertyAccess());
                        }
                        if ((hintString = CommonDiagram.this.getHintText()) != null && hintString.length() > 0) {
                            CommonDiagram.this._hintTextDecoration = CommonDiagram.this.createHintTextViewDecoration(CommonDiagram.this._view, hintString);
                            if (CommonDiagram.this._hintTextDecoration != null) {
                                CommonDiagram.this._view.addViewDecoration((IlvManagerViewDecoration)CommonDiagram.this._hintTextDecoration);
                            }
                        }
                    }
                }
            });
        }
        catch (Throwable th) {
            this.getDiagramContext().removePlugin(DiagramDTSettingsPlugin.class);
            CommonDiagram.rethrowOpenException(th);
        }
    }

    @Override
    public final void saveSettings(StructuredPropertyAccess element) {
        DiagramDTSettingsPlugin dtsp = this.getDiagramContext().getPlugin(DiagramDTSettingsPlugin.class);
        if (dtsp != null) {
            dtsp.saveSettings(element);
        }
    }

    @Override
    public final void loadSettings(StructuredPropertyAccess element) {
        this._layoutRestored = true;
        DiagramDTSettingsPlugin dtsp = this.getDiagramContext().getPlugin(DiagramDTSettingsPlugin.class);
        if (dtsp != null) {
            dtsp.restoreSettings(element);
        }
    }

    @Override
    public void close() {
        IlvManager manager;
        DiagramDTSettingsPlugin dtsp;
        this._layoutRestored = false;
        if (this._view != null) {
            this.cleanInteractorStack();
        }
        if ((dtsp = PluginUtil.getPlugin(this.getDiagramContext(), DiagramDTSettingsPlugin.class)) != null) {
            this.saveSettings(dtsp.getPropertyAccess());
        }
        IlvManager ilvManager = manager = this._view != null ? this._view.getManager() : null;
        if (manager != null) {
            manager.removeManagerTreeSelectionListener((ManagerSelectionListener)this._selListener);
            SubSelectionManager.getInstance().removeSubSelectionListener(manager, this._selListener);
        }
        if (this._view != null) {
            if (this._hintTextDecoration != null) {
                this._view.removeViewDecoration((IlvManagerViewDecoration)this._hintTextDecoration);
                this._hintTextDecoration.clean();
                this._hintTextDecoration = null;
            }
            IlvToolTipManager.unregisterView((IlvManagerView)this._view);
            this._view.removeManagerChangedListener(this._mgrListener);
        }
        if (this._engine != null) {
            this._engine.setReferenceView(null);
        }
        super.close();
        this._view = null;
        this._engine = null;
        this._dndController = null;
    }

    private final void cleanInteractorStack() {
        while (this._view.popInteractor() != null) {
        }
    }

    protected abstract ManagerViewDragAndDropController createDragAndDropController();

    protected abstract Object findOrCreateGraphSystemFromContext(Context var1) throws Exception;

    @Override
    public void initContext(Context srcContext, Context diagramContext) {
        try {
            this._graphSystemObject = this.findOrCreateGraphSystemFromContext(diagramContext);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, "Error while opening diagram: " + ex.getMessage());
        }
    }

    protected IlvManagerView createManagerView(IlvManager manager) {
        return new AccessibleManagerView(manager);
    }

    @Override
    public Controller getController() {
        return this._controller;
    }

    @Override
    public void activate() {
        final PalettePlugin pp = this.getDiagramContext().getPlugin(PalettePlugin.class);
        if (this._initialActivation) {
            this._initialActivation = false;
            if (pp != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        pp.reset();
                    }
                });
            }
        }
    }

    @Override
    public void deactivate() {
    }

    protected void updateHostSelection() {
        SelectionChangeNotificationPlugin scp = this.getDiagramContext().getPlugin(SelectionChangeNotificationPlugin.class);
        if (scp != null && scp.isEnabled()) {
            scp.selectionChanged(this.getDiagramContext());
        }
    }

    protected String getHintText() {
        return null;
    }

    protected HintTextViewDecoration createHintTextViewDecoration(IlvManagerView view, String hintText) {
        return null;
    }

    protected DropTargetListener createDropTargetListener() {
        return new DropTargetHelper(this.getDiagramContext());
    }

    private class SelectionListener
    implements ManagerSelectionListener,
    SubSelectionListener {
        private SelectionListener() {
        }

        public void selectionChanged(ManagerSelectionChangedEvent event) {
            this.updateEditorSelection(event.isAdjusting(), event.isAdjustmentEnd());
        }

        @Override
        public void selectionChanged(SubSelectionChangedEvent event) {
            this.updateEditorSelection(event.isAdjusting(), event.isAdjustmentEnd());
        }

        protected final void updateEditorSelection(boolean isAdjusting, boolean isAdjustmentEnd) {
            boolean update = false;
            if (isAdjusting) {
                if (isAdjustmentEnd) {
                    update = true;
                }
            } else {
                update = true;
            }
            if (update) {
                CommonDiagram.this.updateHostSelection();
            }
        }
    }
}

