/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PrioritizedHandlers<H> {
    private Map<DataFlavor, H> _handlers = new HashMap<DataFlavor, H>();
    private Map<DataFlavor, Float> _priorities = new HashMap<DataFlavor, Float>();
    public static final float NO_PRIORITY = -1.0f;

    public void addHandler(DataFlavor flavor, H handler, float priority) {
        this._handlers.put(flavor, handler);
        this._priorities.put(flavor, Float.valueOf(priority));
    }

    public void removeHandler(DataFlavor flavor) {
        this._handlers.remove(flavor);
        this._priorities.remove(flavor);
    }

    public H getPriorityHandler(List<DataFlavor> flavors) {
        H currentHandler = null;
        DataFlavor currentFlavor2 = null;
        float currentPriority = -1.0f;
        for (DataFlavor currentFlavor2 : flavors) {
            if (currentHandler == null) {
                currentHandler = this.getHandlerForFlavor(currentFlavor2);
                currentPriority = this.getPriorityForFlavor(currentFlavor2);
                continue;
            }
            float p = this.getPriorityForFlavor(currentFlavor2);
            if (p == -1.0f || !(p < currentPriority) && currentPriority != -1.0f) continue;
            currentHandler = this.getHandlerForFlavor(currentFlavor2);
            currentPriority = p;
        }
        return currentHandler;
    }

    public H getHandlerForFlavor(DataFlavor flavor) {
        return this._handlers.get(flavor);
    }

    private float getPriorityForFlavor(DataFlavor flavor) {
        if (flavor == null) {
            return -1.0f;
        }
        Float p = this._priorities.get(flavor);
        if (p == null) {
            return -1.0f;
        }
        return p.floatValue();
    }
}

