/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.action.handler;

import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvManager;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.framework.action.ActionAvailability;
import oracle.diagram.framework.action.Actions;
import oracle.diagram.framework.action.handler.AbstractHandler;
import oracle.diagram.framework.publish.PublishPlugin;
import oracle.diagram.framework.selection.SubSelectionManager;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;

public class PublishHandler
extends AbstractHandler
implements ActionAvailability {
    protected PublishPlugin getPublishPlugin(Context context) {
        return this.getPlugin(context, PublishPlugin.class);
    }

    public boolean handleEvent(IdeAction action, Context context) {
        PublishPlugin pp;
        if (action.getCommandId() == Actions.CMD_PUBLISH_DIAGRAM && (pp = this.getPublishPlugin(context)) != null) {
            pp.publish();
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        if (action.getCommandId() == Actions.CMD_PUBLISH_DIAGRAM) {
            PublishPlugin pp = this.getPublishPlugin(context);
            if (pp != null) {
                action.setEnabled(true);
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isAvailable(IdeAction action, Context context) {
        DiagramContext dc = this.getDiagramContext(context);
        IlvManager mgr = dc.getManagerView().getManager();
        if (mgr.getSelectedObjectsCount(true) != 0) {
            return false;
        }
        IlvGraphicEnumeration e = SubSelectionManager.getInstance().getSelectedSubObjects(mgr);
        return !e.hasMoreElements();
    }
}

