/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.accessibility;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.SystemColor;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import oracle.diagram.framework.graphic.DiagramRenderingHints;
import oracle.ide.natives.accessibility.HighContrast;

public class HCGraphics2D
extends Graphics2D {
    private Graphics2D m_graphics;
    private int m_lastAlpha;
    private Color m_foreground;
    private Color m_textHiFore;
    private Color m_opaqueBack;
    private Color m_transparentBack;
    private Color m_opaqueTextBack;
    private Color m_transparentTextBack;

    public static Graphics get(Graphics g) {
        boolean hc_enabled = HighContrast.isHighContrastModeEnabled();
        if (hc_enabled) {
            HCGraphics2D hcg = new HCGraphics2D();
            hcg.setGraphics(g);
            return hcg;
        }
        return g;
    }

    HCGraphics2D() {
        SystemColor c = SystemColor.window;
        int backgroundRgb = (c.getRed() & 0xFF) << 16 | (c.getGreen() & 0xFF) << 8 | c.getBlue() & 0xFF;
        this.m_opaqueBack = new Color(backgroundRgb);
        this.m_transparentBack = new Color(backgroundRgb & 0xFFFFFF, true);
        c = SystemColor.windowText;
        this.m_foreground = new Color((c.getRed() & 0xFF) << 16 | (c.getGreen() & 0xFF) << 8 | c.getBlue() & 0xFF);
        c = SystemColor.textHighlightText;
        this.m_textHiFore = new Color((c.getRed() & 0xFF) << 16 | (c.getGreen() & 0xFF) << 8 | c.getBlue() & 0xFF);
        c = SystemColor.textHighlight;
        int textHiBackRgb = (c.getRed() & 0xFF) << 16 | (c.getGreen() & 0xFF) << 8 | c.getBlue() & 0xFF;
        this.m_opaqueTextBack = new Color(textHiBackRgb);
        this.m_transparentTextBack = new Color(textHiBackRgb & 0xFFFFFF, true);
    }

    private Color getBackgroundColor() {
        boolean opaque = this.m_lastAlpha == 255;
        Object value = this.m_graphics.getRenderingHint(DiagramRenderingHints.KEY_HC_TEXT_HIGHLIGHT);
        if (DiagramRenderingHints.VALUE_HC_TEXT_HIGHLIGHT_ON == value) {
            return opaque ? this.m_opaqueTextBack : this.m_transparentTextBack;
        }
        return opaque ? this.m_opaqueBack : this.m_transparentBack;
    }

    private Color getForegroundColor() {
        Object value = this.m_graphics.getRenderingHint(DiagramRenderingHints.KEY_HC_TEXT_HIGHLIGHT);
        if (DiagramRenderingHints.VALUE_HC_TEXT_HIGHLIGHT_ON == value) {
            return this.m_textHiFore;
        }
        return this.m_foreground;
    }

    private void setInternalColor(Color color) {
        this.m_graphics.setColor(color);
    }

    private void setFillColor() {
        Object value = this.m_graphics.getRenderingHint(DiagramRenderingHints.KEY_HC_FILL_COLOR);
        Color fillColor = value != null && value == DiagramRenderingHints.VALUE_HC_FILL_COLOR_FORE ? this.getForegroundColor() : this.getBackgroundColor();
        this.setInternalColor(fillColor);
    }

    private void setDrawColor() {
        this.setInternalColor(this.getForegroundColor());
    }

    public void setGraphics(Graphics g) {
        this.m_graphics = (Graphics2D)g;
        this.m_graphics.setRenderingHint(DiagramRenderingHints.KEY_SHAPE_SHADOW, DiagramRenderingHints.VALUE_SHAPE_SHADOW_OFF);
        this.m_graphics.setRenderingHint(DiagramRenderingHints.KEY_HC_TEXT_HIGHLIGHT, DiagramRenderingHints.VALUE_HC_TEXT_HIGHLIGHT_OFF);
        this.m_graphics.setRenderingHint(DiagramRenderingHints.KEY_HC_FILL_COLOR, DiagramRenderingHints.VALUE_HC_FILL_COLOR_BACK);
    }

    @Override
    public void draw(Shape s) {
        this.setDrawColor();
        this.m_graphics.draw(s);
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        return this.m_graphics.drawImage(img, xform, obs);
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        this.m_graphics.drawImage(img, op, x, y);
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        this.m_graphics.drawRenderedImage(img, xform);
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        this.m_graphics.drawRenderableImage(img, xform);
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.setDrawColor();
        this.m_graphics.drawString(str, x, y);
    }

    @Override
    public void drawString(String s, float x, float y) {
        this.setDrawColor();
        this.m_graphics.drawString(s, x, y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.m_graphics.drawString(iterator, x, y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        this.setDrawColor();
        this.m_graphics.drawString(iterator, x, y);
    }

    @Override
    public void drawChars(char[] data, int offset, int lenght, int x, int y) {
        this.setDrawColor();
        this.m_graphics.drawChars(data, offset, lenght, x, y);
    }

    @Override
    public void drawBytes(byte[] data, int offset, int lenght, int x, int y) {
        this.setDrawColor();
        this.m_graphics.drawBytes(data, offset, lenght, x, y);
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        this.setDrawColor();
        this.m_graphics.drawGlyphVector(g, x, y);
    }

    @Override
    public void fill(Shape s) {
        this.setFillColor();
        this.m_graphics.fill(s);
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return this.m_graphics.hit(rect, s, onStroke);
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.m_graphics.getDeviceConfiguration();
    }

    @Override
    public void setComposite(Composite comp) {
        this.m_graphics.setComposite(comp);
    }

    @Override
    public void setPaint(Paint paint) {
        this.m_lastAlpha = paint instanceof Color ? ((Color)paint).getAlpha() : 255;
    }

    @Override
    public void setStroke(Stroke s) {
        this.m_graphics.setStroke(s);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.m_graphics.setRenderingHint(hintKey, hintValue);
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.m_graphics.getRenderingHint(hintKey);
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        this.m_graphics.setRenderingHints(hints);
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
        this.m_graphics.addRenderingHints(hints);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.m_graphics.getRenderingHints();
    }

    @Override
    public void translate(int x, int y) {
        this.m_graphics.translate(x, y);
    }

    @Override
    public void translate(double tx, double ty) {
        this.m_graphics.translate(tx, ty);
    }

    @Override
    public void rotate(double theta) {
        this.m_graphics.rotate(theta);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.m_graphics.rotate(theta, x, y);
    }

    @Override
    public void scale(double sx, double sy) {
        this.m_graphics.scale(sx, sy);
    }

    @Override
    public void shear(double shx, double shy) {
        this.m_graphics.shear(shx, shy);
    }

    @Override
    public void transform(AffineTransform Tx) {
        this.m_graphics.transform(Tx);
    }

    @Override
    public void setTransform(AffineTransform Tx) {
        this.m_graphics.setTransform(Tx);
    }

    @Override
    public AffineTransform getTransform() {
        return this.m_graphics.getTransform();
    }

    @Override
    public Paint getPaint() {
        return this.m_graphics.getPaint();
    }

    @Override
    public Composite getComposite() {
        return this.m_graphics.getComposite();
    }

    @Override
    public void setBackground(Color color) {
        this.m_graphics.setBackground(this.getBackgroundColor());
    }

    @Override
    public Color getBackground() {
        return this.m_graphics.getBackground();
    }

    @Override
    public Stroke getStroke() {
        return this.m_graphics.getStroke();
    }

    @Override
    public void clip(Shape s) {
        this.m_graphics.clip(s);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.m_graphics.getFontRenderContext();
    }

    @Override
    public Graphics create() {
        Graphics g = this.m_graphics.create();
        Graphics hcg = HCGraphics2D.get(g);
        ((Graphics2D)hcg).setRenderingHints(this.m_graphics.getRenderingHints());
        return hcg;
    }

    @Override
    public Color getColor() {
        return this.m_graphics.getColor();
    }

    @Override
    public void setColor(Color c) {
        this.m_lastAlpha = c.getAlpha();
    }

    @Override
    public void setPaintMode() {
        this.m_graphics.setPaintMode();
    }

    @Override
    public void setXORMode(Color c1) {
        this.m_graphics.setXORMode(c1);
    }

    @Override
    public Font getFont() {
        return this.m_graphics.getFont();
    }

    @Override
    public void setFont(Font font) {
        this.m_graphics.setFont(font);
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return this.m_graphics.getFontMetrics(f);
    }

    @Override
    public Rectangle getClipBounds() {
        return this.m_graphics.getClipBounds();
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.m_graphics.clipRect(x, y, width, height);
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.m_graphics.setClip(x, y, width, height);
    }

    @Override
    public void setClip(Shape clip) {
        this.m_graphics.setClip(clip);
    }

    @Override
    public Shape getClip() {
        return this.m_graphics.getClip();
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.m_graphics.copyArea(x, y, width, height, dx, dy);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.setDrawColor();
        this.m_graphics.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.setFillColor();
        this.m_graphics.fillRect(x, y, width, height);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        this.setFillColor();
        this.m_graphics.clearRect(x, y, width, height);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.setDrawColor();
        this.m_graphics.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.setFillColor();
        this.m_graphics.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.setDrawColor();
        this.m_graphics.drawOval(x, y, width, height);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.setFillColor();
        this.m_graphics.fillOval(x, y, width, height);
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.setDrawColor();
        this.m_graphics.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.setFillColor();
        this.m_graphics.fillArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.setDrawColor();
        this.m_graphics.drawPolyline(xPoints, yPoints, nPoints);
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.setDrawColor();
        this.m_graphics.drawPolygon(xPoints, yPoints, nPoints);
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.setFillColor();
        this.m_graphics.fillPolygon(xPoints, yPoints, nPoints);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.m_graphics.drawImage(img, x, y, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.m_graphics.drawImage(img, x, y, width, height, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return this.m_graphics.drawImage(img, x, y, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        return this.m_graphics.drawImage(img, x, y, width, height, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.m_graphics.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        return this.m_graphics.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
    }

    @Override
    public void dispose() {
        this.m_graphics.dispose();
        this.m_graphics = null;
    }
}

