/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.accessibility;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.plugin.Plugin;
import oracle.diagram.core.plugin.PluginUtil;
import oracle.diagram.framework.accessibility.AbstractKeyboardNavigationPlugin;
import oracle.diagram.framework.accessibility.KeyboardNavigationPlugin;
import oracle.diagram.framework.selection.SubSelectionManager;

public class DefaultKeyboardNavigationPlugin
extends AbstractKeyboardNavigationPlugin {
    private final DiagramContext _context;

    public DefaultKeyboardNavigationPlugin(DiagramContext context) {
        this._context = context;
    }

    @Override
    public IlvGraphic navigate(KeyboardNavigationPlugin.Direction direction) {
        IlvManagerView view = this.getManagerView();
        return this.navigateNext(view, this.getSingleSelection(), direction);
    }

    @Override
    public <T extends Plugin> T getPlugin(IlvGraphic g, Class<T> key) {
        return PluginUtil.getPlugin(this.getDiagramContext(), g, key);
    }

    protected final DiagramContext getDiagramContext() {
        return this._context;
    }

    protected final IlvManagerView getManagerView() {
        return this.getDiagramContext().getManagerView();
    }

    protected IlvGraphic getSingleSelection() {
        IlvGraphicEnumeration subs;
        IlvManagerView view = this.getManagerView();
        IlvManager mgr = view.getManager();
        IlvGraphic sel = null;
        IlvGraphicEnumeration e = mgr.getSelectedObjects(true);
        if (e.hasMoreElements()) {
            sel = e.nextElement();
            if (e.hasMoreElements()) {
                return null;
            }
        }
        if (sel == null && (subs = SubSelectionManager.getInstance().getSelectedSubObjects(mgr)).hasMoreElements()) {
            sel = subs.nextElement();
            if (subs.hasMoreElements()) {
                return null;
            }
        }
        return sel;
    }
}

