/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.accessibility;

import ilog.views.IlvGraphic;
import ilog.views.IlvManager;
import ilog.views.util.collections.IlvSelectiveIterator;
import ilog.views.util.collections.IlvUnaryPredicate;
import java.util.Iterator;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleRole;
import oracle.diagram.core.util.AccessibilityPredicate;
import oracle.diagram.framework.accessibility.AccessibleGraphic;
import oracle.diagram.framework.accessibility.AccessibleManagerView;
import oracle.diagram.framework.manager.VisibleObjectsIterator;

public class AccessibleManagedGraphic
extends AccessibleGraphic {
    public AccessibleManagedGraphic(AccessibleManagerView view, IlvGraphic graphic) {
        super(view, graphic);
    }

    @Override
    public int getAccessibleIndexInParent() {
        IlvGraphic g = this.getGraphic();
        int i = 0;
        IlvManager mgr = (IlvManager)g.getGraphicBag();
        if (mgr == null) {
            return -1;
        }
        IlvSelectiveIterator iterator = new IlvSelectiveIterator((Iterator)new VisibleObjectsIterator(mgr), (IlvUnaryPredicate)new AccessibilityPredicate());
        while (iterator.hasNext()) {
            IlvGraphic child = (IlvGraphic)iterator.next();
            if (child == g) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public Accessible getAccessibleParent() {
        IlvManager mgr = (IlvManager)this.getGraphic().getGraphicBag();
        if (mgr == null || this.getView().getManager() == mgr) {
            return this.getView();
        }
        return this.getView().getAccessibleGraphic((IlvGraphic)mgr);
    }

    @Override
    public AccessibleRole getAccessibleRole() {
        return AccessibleRole.LABEL;
    }

    @Override
    protected boolean isSelected() {
        IlvGraphic g = this.getGraphic();
        IlvManager mgr = (IlvManager)g.getGraphicBag();
        return mgr != null && mgr.isVisible(g) && mgr.isSelected(g);
    }

    @Override
    protected boolean isSelectable() {
        IlvGraphic g = this.getGraphic();
        IlvManager mgr = (IlvManager)g.getGraphicBag();
        return mgr != null && mgr.isVisible(g) && mgr.isSelectable(g);
    }
}

