/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.dif;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.diagram.dif.DiagramElement;
import oracle.diagram.dif.GraphConnector;
import oracle.diagram.dif.GraphicBridge;
import oracle.diagram.dif.Point;
import oracle.diagram.dif.SemanticModelBridge;
import oracle.mof.xmi.XMIBean;
import oracle.mof.xmi.XMIPropertyType;

public abstract class GraphElement
extends DiagramElement {
    protected Point m_position;
    private ArrayList<DiagramElement> m_contained = new ArrayList();
    private SemanticModelBridge m_semanticModel;
    private ArrayList<GraphConnector> m_anchorages = new ArrayList();

    @XMIBean(type=XMIPropertyType.COMPOSITE)
    public Point getPosition() {
        return this.m_position;
    }

    @XMIBean(type=XMIPropertyType.COMPOSITE)
    public void setPosition(Point position) {
        this.m_position = position;
    }

    @XMIBean(type=XMIPropertyType.COMPOSITE, multivalued=true)
    public Iterator<DiagramElement> getContained() {
        return this.m_contained.iterator();
    }

    @XMIBean(type=XMIPropertyType.COMPOSITE, multivalued=true)
    public void addContained(DiagramElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Missing element");
        }
        this.m_contained.add(element);
        element.setContainer(this);
    }

    public void removeContained(DiagramElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Missing element");
        }
        if (!this.m_contained.contains((Object)element)) {
            throw new IllegalStateException("Element is not contained");
        }
        this.m_contained.remove((Object)element);
        element.setContainer(null);
    }

    public void clearContained() {
        for (DiagramElement child : this.m_contained) {
            child.setContainer(null);
        }
        this.m_contained.clear();
    }

    @XMIBean(type=XMIPropertyType.COMPOSITE)
    public SemanticModelBridge getSemanticModel() {
        return this.m_semanticModel;
    }

    @XMIBean(type=XMIPropertyType.COMPOSITE)
    public void setSemanticModel(SemanticModelBridge semanticModel) {
        if (semanticModel == null) {
            throw new IllegalArgumentException("Missing semantic model");
        }
        this.m_semanticModel = semanticModel;
        this.m_semanticModel.setGraphElement(this);
    }

    @XMIBean(type=XMIPropertyType.COMPOSITE, tag="anchorage", multivalued=true)
    public Iterator<GraphConnector> anchorages() {
        return this.m_anchorages.iterator();
    }

    @XMIBean(type=XMIPropertyType.COMPOSITE, multivalued=true)
    public void addAnchorage(GraphConnector anchorage) {
        if (anchorage == null) {
            throw new IllegalArgumentException("Missing anchorage");
        }
        this.m_anchorages.add(anchorage);
        anchorage.setGraphElement(this);
    }

    public <P> void createContainedGraphics(GraphicBridge<P> bridge, P parentGraphic) {
        for (DiagramElement contained : this.m_contained) {
            contained.createGraphic(bridge, parentGraphic);
        }
    }

    @Override
    public <P> void connect(GraphicBridge<P> bridge) {
        for (DiagramElement de : this.m_contained) {
            de.connect(bridge);
        }
    }

    protected <P> void updateAnchors(GraphicBridge<P> bridge) {
        if (this.m_anchorages.isEmpty()) {
            this.addAnchorage(new GraphConnector());
        }
        GraphConnector gc = this.m_anchorages.get(0);
        gc.updateEdges(bridge);
        if (!gc.getGraphEdges().hasNext()) {
            this.m_anchorages.clear();
        }
    }

    public void clearId() {
        super.clearId();
        for (DiagramElement de : this.m_contained) {
            de.clearId();
        }
        for (GraphConnector connector : this.m_anchorages) {
            connector.clearId();
        }
    }
}

