/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.dif;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.logging.Level;
import oracle.bm.util.LoggerUtils;
import oracle.diagram.dif.Diagram;
import oracle.diagram.dif.DiagramLoader;
import oracle.diagram.dif.SimpleSemanticModelBridge;
import oracle.diagram.res.DiagramResources;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.vcs.VCSManager;
import oracle.mof.xmi.DefaultXMIMetaModelProvider;
import oracle.mof.xmi.XMIDocument;
import oracle.mof.xmi.XMIDocumentBuilder;
import oracle.mof.xmi.XMIErrorHandler;
import oracle.mof.xmi.XMIErrorMessage;
import oracle.mof.xmi.XMIExportBuilder;
import oracle.mof.xmi.XMIExporter;
import oracle.mof.xmi.XMIMetaModel;
import oracle.mof.xmi.XMIMetaModelProvider;
import oracle.mof.xmi.XMIModelBuilder;
import oracle.mof.xmi.XMIReader;
import oracle.mof.xmi.XMIWriter;
import oracle.mof.xmi.XMIWriterFactory;
import oracle.mof.xmi.XMLWriter;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class DiagramIdeNode
extends Node {
    private String m_xmiVersion;
    private Diagram m_diagram;
    private XMIErrorHandler m_errorHandler;

    public static XMIExporter getXMIExporter(Diagram diagram, URL diagramURL, String xmiVersion) throws IOException {
        XMLWriter xmlWriter = new XMLWriter();
        xmlWriter.setOutputURL(diagramURL);
        xmlWriter.setNewLines(XMLWriter.NewLines.ELEMENTS);
        XMIWriter writer = XMIWriterFactory.createWriter((String)xmiVersion);
        writer.setXMLWriter(xmlWriter);
        DefaultXMIMetaModelProvider provider = new DefaultXMIMetaModelProvider();
        provider.addMetaModel((XMIMetaModel)new DiagramLoader());
        writer.setMetaModels(provider.getMetaModels());
        XMIExporter exporter = new XMIExporter((XMIExportBuilder)writer, (XMIMetaModelProvider)provider, new Object[]{diagram});
        return exporter;
    }

    public DiagramIdeNode() {
    }

    public DiagramIdeNode(URL url) {
        super(url);
    }

    protected void openImpl() {
        block5: {
            this.m_errorHandler = new XMIErrorHandler(this.getURL(), true);
            if (this.isNew()) {
                this.m_diagram = this.createDiagram();
            } else {
                try {
                    XMIReader reader = new XMIReader();
                    reader.setLogUnsupported(true);
                    DefaultXMIMetaModelProvider provider = new DefaultXMIMetaModelProvider();
                    provider.addMetaModel((XMIMetaModel)new DiagramLoader());
                    reader.setMetaModelProvider((XMIMetaModelProvider)provider);
                    reader.setErrorHandler((ErrorHandler)this.m_errorHandler);
                    URL url = this.getURL();
                    VCSManager.getVCSManager().validateStatus(url);
                    XMIDocument doc = (XMIDocument)reader.read((XMIModelBuilder)new XMIDocumentBuilder(), new InputSource(VCSManager.getVCSManager().containsConflicts(url) ? VCSManager.getVCSManager().openConflictsStreamAsContributor(url) : URLFileSystem.openInputStream((URL)url)));
                    doc.resolveReferences();
                    Object[] diagrams = doc.getRootInstances();
                    if (this.m_errorHandler.hasErrors()) break block5;
                    if (diagrams.length > 0) {
                        this.m_xmiVersion = doc.getXMIVersion();
                        this.m_diagram = (Diagram)((Object)doc.getRootInstances()[0]);
                        break block5;
                    }
                    throw new Exception(DiagramResources.get("NoDiagramData.text"));
                }
                catch (Exception e) {
                    this.m_errorHandler.exception(e);
                }
            }
        }
    }

    protected void saveImpl() throws IOException {
        XMIExporter exporter = DiagramIdeNode.getXMIExporter(this.m_diagram, this.getURL(), this.m_xmiVersion);
        try {
            exporter.export();
            this.m_errorHandler = new XMIErrorHandler(this.getURL(), true);
        }
        catch (Exception e) {
            LoggerUtils.getLoggerForClass(DiagramIdeNode.class).log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    protected void closeImpl() {
        this.m_xmiVersion = null;
        this.m_diagram = null;
        this.m_errorHandler = null;
    }

    public Diagram getDiagram() throws IOException {
        this.open();
        if (this.m_diagram == null) {
            throw new IOException();
        }
        return this.m_diagram;
    }

    public boolean hasErrors() throws IOException {
        this.open();
        return this.m_errorHandler.hasErrors();
    }

    public Collection<XMIErrorMessage> getErrorMessages() throws IOException {
        this.open();
        return this.m_errorHandler.getMessages();
    }

    protected Diagram createDiagram() {
        Diagram diagram = new Diagram();
        String suffix = URLFileSystem.getSuffix((URL)this.getURL());
        if (suffix.length() > 1) {
            SimpleSemanticModelBridge csmb = new SimpleSemanticModelBridge();
            csmb.setTypeInfo(suffix.substring(1));
            diagram.setSemanticModel(csmb);
        }
        return diagram;
    }

    protected void revertImpl() throws IOException {
        this.openImpl();
    }
}

