/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.dif;

import oracle.diagram.dif.DIFUtils;
import oracle.diagram.dif.GraphNode;
import oracle.diagram.dif.GraphicBridge;
import oracle.diagram.dif.Point;
import oracle.mof.xmi.XMIBean;
import oracle.mof.xmi.XMIPropertyType;

public class Diagram
extends GraphNode {
    private String m_name;
    private double m_zoom;
    private Point m_viewport;

    @XMIBean
    public String getName() {
        return this.m_name;
    }

    @XMIBean
    public void setName(String name) {
        this.m_name = name;
    }

    @XMIBean
    public double getZoom() {
        return this.m_zoom;
    }

    @XMIBean
    public void setZoom(double zoom) {
        DIFUtils.checkValidDouble(zoom);
        this.m_zoom = zoom;
    }

    @XMIBean(type=XMIPropertyType.COMPOSITE)
    public Point getViewport() {
        return this.m_viewport;
    }

    @XMIBean(type=XMIPropertyType.COMPOSITE)
    public void setViewport(Point viewport) {
        this.m_viewport = viewport;
    }

    public <P> void createGraphic(GraphicBridge<P> bridge) {
        this.createGraphic(bridge, null);
        this.connect(bridge);
    }

    @Override
    public <P> void createGraphic(GraphicBridge<P> bridge, P parentGraphic) {
        if (bridge == null) {
            throw new IllegalArgumentException("Missing bridge");
        }
        bridge.createDiagramGraphic(this, parentGraphic);
    }

    @Override
    public <P> void update(GraphicBridge<P> bridge) {
        if (bridge == null) {
            throw new IllegalArgumentException("Missing bridge");
        }
        this.updateAnchors(bridge);
        bridge.updateDiagram(this);
    }
}

