/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.core.util;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.controls.FocusHierarchyDispatcher;
import oracle.ide.controls.FocusHierarchyEvent;
import oracle.ide.controls.FocusHierarchyListener;

public class ComponentFocusHierarchyDispatcher {
    private Map<Component, FocusListener> _listenersByComponent = new HashMap<Component, FocusListener>();
    private FocusHierarchyListener _listener = new Listener();

    public void install() {
        FocusHierarchyDispatcher.getInstance().addFocusHierarchyListener(this._listener);
    }

    public void uninstall() {
        FocusHierarchyDispatcher.getInstance().removeFocusHierarchyListener(this._listener);
        this._listenersByComponent.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFocusComponent(Component c, FocusListener listener) {
        Map<Component, FocusListener> map = this._listenersByComponent;
        synchronized (map) {
            this._listenersByComponent.put(c, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFocusComponent(Component c) {
        Map<Component, FocusListener> map = this._listenersByComponent;
        synchronized (map) {
            this._listenersByComponent.remove(c);
        }
    }

    private class Listener
    implements FocusHierarchyListener {
        private Listener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void focusGained(FocusHierarchyEvent event) {
            Map map = ComponentFocusHierarchyDispatcher.this._listenersByComponent;
            synchronized (map) {
                for (Object o : event.getHierarchy()) {
                    FocusListener l = (FocusListener)ComponentFocusHierarchyDispatcher.this._listenersByComponent.get((Component)o);
                    if (l == null) continue;
                    try {
                        l.focusGained(new FocusEvent((Component)o, 1004, event.isTemporary()));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }

        public void focusLost(FocusHierarchyEvent event) {
            for (Object o : event.getHierarchy()) {
                FocusListener l = (FocusListener)ComponentFocusHierarchyDispatcher.this._listenersByComponent.get((Component)o);
                if (l == null) continue;
                try {
                    l.focusLost(new FocusEvent((Component)o, 1005, event.isTemporary()));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

