/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.ABSTRACT_DATUM})
public abstract class Datum
implements Serializable {
    private byte[] data;
    static final long serialVersionUID = 4645732484621936751L;

    public Datum() {
    }

    public Datum(byte[] byArray) {
        this.data = byArray;
    }

    @DisableTrace
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof Datum)) {
            return false;
        }
        if (this.getClass() == object.getClass()) {
            Datum datum = (Datum)object;
            if (this.data == null && datum.data == null) {
                return true;
            }
            if (this.data == null && datum.data != null || this.data != null && datum.data == null) {
                return false;
            }
            if (this.data.length != datum.data.length) {
                return false;
            }
            for (int i2 = 0; i2 < this.data.length; ++i2) {
                if (this.data[i2] == datum.data[i2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @DisableTrace
    public int bytesHashCode() {
        int n2 = 1;
        if (this.data != null && this.data.length > 0) {
            for (int i2 = 0; i2 < this.data.length; ++i2) {
                n2 = 31 * n2 + this.data[i2];
            }
        }
        return n2;
    }

    @DisableTrace
    public byte[] shareBytes() {
        return this.data;
    }

    @DisableTrace
    public long getLength() {
        if (null == this.data) {
            return 0L;
        }
        return this.data.length;
    }

    public void setBytes(byte[] byArray) {
        int n2 = byArray.length;
        this.data = new byte[n2];
        System.arraycopy(byArray, 0, this.data, 0, n2);
    }

    public void setShareBytes(byte[] byArray) {
        this.data = byArray;
    }

    public byte[] getBytes() {
        if (this.data == null) {
            return new byte[0];
        }
        byte[] byArray = new byte[this.data.length];
        System.arraycopy(this.data, 0, byArray, 0, this.data.length);
        return byArray;
    }

    public boolean isNull() {
        return this.data == null || this.data.length == 0;
    }

    public InputStream getStream() {
        return new ByteArrayInputStream(this.data);
    }

    public String stringValue() throws SQLException {
        throw new SQLException("Conversion to String failed");
    }

    public String stringValue(Connection connection) throws SQLException {
        return this.stringValue();
    }

    public boolean booleanValue() throws SQLException {
        throw new SQLException("Conversion to boolean failed");
    }

    public int intValue() throws SQLException {
        throw new SQLException("Conversion to integer failed");
    }

    public long longValue() throws SQLException {
        throw new SQLException("Conversion to long failed");
    }

    public float floatValue() throws SQLException {
        throw new SQLException("Conversion to float failed");
    }

    public double doubleValue() throws SQLException {
        throw new SQLException("Conversion to double failed");
    }

    public byte byteValue() throws SQLException {
        throw new SQLException("Conversion to byte failed");
    }

    public BigDecimal bigDecimalValue() throws SQLException {
        throw new SQLException("Conversion to BigDecimal failed");
    }

    public Date dateValue() throws SQLException {
        throw new SQLException("Conversion to Date failed");
    }

    public Time timeValue() throws SQLException {
        throw new SQLException("Conversion to Time failed");
    }

    public Time timeValue(Calendar calendar) throws SQLException {
        throw new SQLException("Conversion to Time failed");
    }

    public Timestamp timestampValue() throws SQLException {
        throw new SQLException("Conversion to Timestamp failed");
    }

    public Timestamp timestampValue(Calendar calendar) throws SQLException {
        throw new SQLException("Conversion to Timestamp failed");
    }

    public Reader characterStreamValue() throws SQLException {
        throw new SQLException("Conversion to character stream failed");
    }

    public InputStream asciiStreamValue() throws SQLException {
        throw new SQLException("Conversion to ascii stream failed");
    }

    public InputStream binaryStreamValue() throws SQLException {
        throw new SQLException("Conversion to binary stream failed");
    }

    public abstract boolean isConvertibleTo(Class var1);

    public <T> T toClass(Class<T> clazz) throws SQLException {
        Object object = null;
        if (clazz == this.getClass()) {
            object = this;
        } else if (clazz == String.class) {
            object = this.stringValue();
        } else if (clazz == Boolean.class) {
            object = this.booleanValue();
        } else if (clazz == Byte.class) {
            object = this.byteValue();
        } else if (clazz == Integer.class) {
            object = this.intValue();
        } else if (clazz == Long.class) {
            object = this.longValue();
        } else if (clazz == Float.class) {
            object = Float.valueOf(this.floatValue());
        } else if (clazz == Double.class) {
            object = this.doubleValue();
        } else if (clazz == BigDecimal.class) {
            object = this.bigDecimalValue();
        } else if (clazz == Date.class) {
            object = this.dateValue();
        } else if (clazz == Time.class) {
            object = this.timeValue();
        } else if (clazz == Timestamp.class) {
            object = this.timestampValue();
        } else if (clazz == Reader.class) {
            object = this.characterStreamValue();
        } else if (clazz == InputStream.class) {
            object = this.binaryStreamValue();
        } else {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, clazz.getName()).fillInStackTrace();
        }
        return (T)object;
    }

    public abstract Object toJdbc() throws SQLException;

    public abstract Object makeJdbcArray(int var1);

    public static int compareBytes(byte[] byArray, byte[] byArray2) {
        int n2 = byArray.length;
        int n3 = byArray2.length;
        int n4 = Math.min(n2, n3);
        int n5 = 0;
        int n6 = 0;
        for (int i2 = 0; i2 < n4; ++i2) {
            n5 = byArray[i2] & 0xFF;
            n6 = byArray2[i2] & 0xFF;
            if (n5 == n6) continue;
            if (n5 < n6) {
                return -1;
            }
            return 1;
        }
        if (n2 == n3) {
            return 0;
        }
        if (n2 > n3) {
            return 1;
        }
        return -1;
    }

    protected boolean bytesEqual(Datum datum) {
        byte[] byArray;
        boolean bl;
        boolean bl2;
        boolean bl3 = bl2 = this == datum;
        if (!bl2 && (bl = this.data == null) == ((byArray = datum.shareBytes()) == null) && (bl || this.data.length == byArray.length)) {
            bl2 = true;
            if (!bl) {
                for (int i2 = 0; i2 < this.data.length; ++i2) {
                    if (this.data[i2] == byArray[i2]) continue;
                    bl2 = false;
                    break;
                }
            }
        }
        return bl2;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

