/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import oracle.jdbc.logging.annotations.DisableTrace;

public class SSLSocketChannel
extends SocketChannel {
    private final SocketChannel socketChannel;
    private final SSLEngine sslEngine;
    private final SSLSession sslSession;
    private final int minCacheSize;
    private final ByteBuffer[] inputCache;
    private final int minBufferSize;
    private final ByteBuffer[] inputBuffer;
    private final ByteBuffer[] outputBuffer;
    private final ByteBuffer emptyBuffer;
    private SSLEngineResult.HandshakeStatus handshake;
    private int initialized = -1;
    private boolean shutdown;
    private int remainingFromPreviousRead = 0;

    public SSLSocketChannel(SocketChannel socketChannel, SSLEngine sSLEngine) {
        super(socketChannel.provider());
        this.socketChannel = socketChannel;
        this.sslEngine = sSLEngine;
        this.sslSession = sSLEngine.getSession();
        this.minCacheSize = this.sslSession.getApplicationBufferSize();
        this.inputCache = new ByteBuffer[]{ByteBuffer.allocate(this.minCacheSize)};
        this.minBufferSize = this.sslSession.getPacketBufferSize();
        this.inputBuffer = new ByteBuffer[]{ByteBuffer.allocate(this.minBufferSize)};
        this.outputBuffer = new ByteBuffer[]{ByteBuffer.allocate(this.minBufferSize)};
        this.emptyBuffer = ByteBuffer.allocate(0);
        this.inputCache[0].limit(0);
        this.outputBuffer[0].limit(0);
    }

    public SocketChannel getUnderlyingChannel() {
        return this.socketChannel;
    }

    @Override
    public Socket socket() {
        return this.socketChannel.socket();
    }

    @Override
    public boolean isConnected() {
        return this.socketChannel.isConnected();
    }

    @Override
    public boolean isConnectionPending() {
        return this.socketChannel.isConnectionPending();
    }

    @Override
    public boolean connect(SocketAddress socketAddress) throws IOException {
        return this.socketChannel.connect(socketAddress);
    }

    @Override
    public boolean finishConnect() throws IOException {
        return this.socketChannel.finishConnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        if (this.inputCache[0].remaining() > 0) {
            int n2 = this.inputCache[0].remaining();
            if (n2 > 0) {
                if (n2 > byteBuffer.remaining()) {
                    this.remainingFromPreviousRead = n2 - byteBuffer.remaining();
                    n2 = byteBuffer.remaining();
                }
                for (int i2 = 0; i2 < n2; ++i2) {
                    byteBuffer.put(this.inputCache[0].get());
                }
            }
            return n2;
        }
        if (this.socketChannel.socket().isInputShutdown()) {
            throw new ClosedChannelException();
        }
        if (this.initialized != 0) {
            this.handshake(1);
            return 0;
        }
        if (this.shutdown) {
            this.shutdown();
            return 0;
        }
        if (this.sslEngine.isInboundDone()) {
            return -1;
        }
        if (this.fill(this.inputBuffer[0]) < 0L && this.inputBuffer[0].position() == 0) {
            return -1;
        }
        while (this.prepare(this.inputCache, this.minCacheSize)) {
            SSLEngineResult sSLEngineResult;
            this.inputBuffer[0].flip();
            try {
                sSLEngineResult = this.sslEngine.unwrap(this.inputBuffer[0], this.inputCache[0]);
            }
            finally {
                this.inputBuffer[0].compact();
                this.inputCache[0].flip();
            }
            SSLEngineResult.Status status = sSLEngineResult.getStatus();
            if (status == SSLEngineResult.Status.OK || status == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                if (sSLEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    this.runTasks();
                }
            } else {
                if (status == SSLEngineResult.Status.CLOSED) {
                    this.shutdown();
                }
                throw new IOException("Read error '" + (Object)((Object)sSLEngineResult.getStatus()) + '\'');
            }
            if (this.inputBuffer[0].position() != 0 && status != SSLEngineResult.Status.BUFFER_UNDERFLOW) continue;
        }
        int n3 = this.inputCache[0].remaining();
        if (n3 > 0) {
            if (n3 > byteBuffer.remaining()) {
                this.remainingFromPreviousRead = n3 - byteBuffer.remaining();
                n3 = byteBuffer.remaining();
            }
            for (int i3 = 0; i3 < n3; ++i3) {
                byteBuffer.put(this.inputCache[0].get());
            }
        }
        return n3;
    }

    @Override
    public long read(ByteBuffer[] byteBufferArray, int n2, int n3) throws IOException {
        long l2 = 0L;
        for (int i2 = n2; i2 < n3; ++i2) {
            if (!byteBufferArray[i2].hasRemaining()) continue;
            int n4 = this.read(byteBufferArray[i2]);
            if (n4 > 0) {
                l2 += (long)n4;
                if (byteBufferArray[i2].hasRemaining()) continue;
                break;
            }
            if (n4 >= 0 || l2 != 0L) break;
            l2 = -1L;
            break;
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        if (this.socketChannel.socket().isOutputShutdown()) {
            throw new ClosedChannelException();
        }
        if (this.initialized != 0) {
            this.handshake(4);
            return 0;
        }
        if (this.shutdown) {
            this.shutdown();
            return 0;
        }
        int n2 = byteBuffer.remaining();
        int n3 = 0;
        while (this.prepare(this.outputBuffer, this.minBufferSize)) {
            SSLEngineResult sSLEngineResult;
            try {
                sSLEngineResult = this.sslEngine.wrap(byteBuffer, this.outputBuffer[0]);
            }
            finally {
                this.outputBuffer[0].flip();
            }
            n3 += sSLEngineResult.bytesConsumed();
            SSLEngineResult.Status status = sSLEngineResult.getStatus();
            if (status == SSLEngineResult.Status.OK) {
                if (sSLEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    this.runTasks();
                }
            } else {
                if (status == SSLEngineResult.Status.CLOSED) {
                    this.shutdown();
                }
                throw new IOException("Write error '" + (Object)((Object)sSLEngineResult.getStatus()) + '\'');
            }
            if (n3 < n2) continue;
        }
        this.flush();
        return n3;
    }

    @Override
    public long write(ByteBuffer[] byteBufferArray, int n2, int n3) throws IOException {
        long l2 = 0L;
        for (int i2 = n2; i2 < n3; ++i2) {
            if (!byteBufferArray[i2].hasRemaining()) continue;
            int n4 = this.write(byteBufferArray[i2]);
            if (n4 <= 0) break;
            l2 += (long)n4;
            if (!byteBufferArray[i2].hasRemaining()) break;
        }
        return l2;
    }

    public Channel getAdapteeChannel() {
        return this.socketChannel;
    }

    public boolean finished() {
        return this.initialized == 0;
    }

    public int encrypted() {
        return this.outputBuffer[0].remaining();
    }

    public int decrypted() {
        return this.inputCache[0].remaining();
    }

    public synchronized int handshake(int n2) throws IOException {
        if (this.initialized != 0) {
            if (this.handshake == null) {
                this.sslEngine.beginHandshake();
                this.handshake = this.sslEngine.getHandshakeStatus();
            }
            if (this.outputBuffer[0].hasRemaining()) {
                if ((n2 & 4) != 0) {
                    this.flush(this.outputBuffer[0]);
                    this.initialized = this.outputBuffer[0].hasRemaining() ? 4 : 1;
                    n2 = 0;
                } else {
                    this.initialized = 4;
                }
            } else {
                this.initialized = 1;
            }
            while (this.initialized != 0) {
                if (this.handshake == SSLEngineResult.HandshakeStatus.FINISHED) {
                    this.initialized = 0;
                    continue;
                }
                if (this.handshake == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    this.handshake = this.runTasks();
                    continue;
                }
                if (this.handshake == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    if ((n2 = this.unwrap(n2)) == 0) continue;
                    this.initialized = n2;
                    return this.initialized;
                }
                if (this.handshake == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                    if ((n2 = this.wrap(n2)) == 0) continue;
                    this.initialized = n2;
                    return this.initialized;
                }
                throw new IllegalStateException("Unexpected handshake status '" + (Object)((Object)this.handshake) + '\'');
            }
        }
        return this.initialized;
    }

    public synchronized boolean shutdown() throws IOException {
        SSLEngineResult sSLEngineResult;
        this.shutdown = true;
        if (!this.sslEngine.isOutboundDone()) {
            this.sslEngine.closeOutbound();
        }
        if (this.prepare(this.outputBuffer, this.minBufferSize)) {
            sSLEngineResult = this.sslEngine.wrap(this.emptyBuffer, this.outputBuffer[0]);
            if (sSLEngineResult.getStatus() != SSLEngineResult.Status.CLOSED) {
                throw new SSLException("Unexpected shutdown status '" + (Object)((Object)sSLEngineResult.getStatus()) + '\'');
            }
            this.outputBuffer[0].flip();
        } else {
            sSLEngineResult = null;
        }
        this.flush(this.outputBuffer[0]);
        return !this.outputBuffer[0].hasRemaining() && sSLEngineResult != null && sSLEngineResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_WRAP;
    }

    public synchronized void flush() throws IOException {
        this.flush(this.outputBuffer[0]);
    }

    @DisableTrace
    public String toString() {
        return "SSLSocketChannel[" + this.socket().toString() + "]";
    }

    public SSLSession getSession() {
        return this.sslSession;
    }

    @Override
    protected synchronized void implCloseSelectableChannel() throws IOException {
        try {
            this.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socketChannel.close();
        this.notifyAll();
    }

    @Override
    protected void implConfigureBlocking(boolean bl) throws IOException {
        this.socketChannel.configureBlocking(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int unwrap(int n2) throws IOException {
        try {
            this.fill(this.inputBuffer[0]);
            do {
                SSLEngineResult sSLEngineResult;
                this.prepare(this.inputCache, this.minCacheSize);
                this.inputBuffer[0].flip();
                try {
                    sSLEngineResult = this.sslEngine.unwrap(this.inputBuffer[0], this.inputCache[0]);
                }
                finally {
                    this.inputBuffer[0].compact();
                    this.inputCache[0].flip();
                }
                this.handshake = sSLEngineResult.getHandshakeStatus();
                SSLEngineResult.Status status = sSLEngineResult.getStatus();
                if (status == SSLEngineResult.Status.OK) {
                    if (this.handshake != SSLEngineResult.HandshakeStatus.NEED_TASK) continue;
                    this.handshake = this.runTasks();
                    continue;
                }
                if (status == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                    return 1;
                }
                throw new IOException("Handshake failed '" + (Object)((Object)status) + '\'');
            } while (this.handshake == SSLEngineResult.HandshakeStatus.NEED_UNWRAP);
            return 0;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw (IOException)new IOException("IO Error " + exception.getMessage()).initCause(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int wrap(int n2) throws IOException {
        try {
            if (this.prepare(this.outputBuffer, this.minBufferSize)) {
                SSLEngineResult sSLEngineResult;
                try {
                    sSLEngineResult = this.sslEngine.wrap(this.emptyBuffer, this.outputBuffer[0]);
                }
                finally {
                    this.outputBuffer[0].flip();
                }
                this.handshake = sSLEngineResult.getHandshakeStatus();
                SSLEngineResult.Status status = sSLEngineResult.getStatus();
                if (status == SSLEngineResult.Status.OK) {
                    if (this.handshake == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                        this.handshake = this.runTasks();
                    }
                } else {
                    throw new IOException("Handshake failed '" + (Object)((Object)status) + '\'');
                }
            }
            if (this.outputBuffer[0].hasRemaining()) {
                this.flush(this.outputBuffer[0]);
            }
            return this.outputBuffer[0].hasRemaining() ? 4 : 0;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw (IOException)new IOException("IO Error " + exception.getMessage()).initCause(exception);
        }
    }

    private long fill(ByteBuffer byteBuffer) throws IOException {
        try {
            long l2 = this.socketChannel.read(byteBuffer);
            if (l2 < 0L) {
                this.sslEngine.closeInbound();
            }
            return l2;
        }
        catch (IOException iOException) {
            try {
                if (!this.sslEngine.isInboundDone()) {
                    this.sslEngine.closeInbound();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw iOException;
        }
    }

    private long fill(ByteBuffer byteBuffer, int n2) throws IOException {
        try {
            long l2 = this.socketChannel.read(byteBuffer);
            if (l2 < 0L) {
                this.sslEngine.closeInbound();
            }
            return l2;
        }
        catch (IOException iOException) {
            try {
                if (!this.sslEngine.isInboundDone()) {
                    this.sslEngine.closeInbound();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw iOException;
        }
    }

    private long flush(ByteBuffer byteBuffer) throws IOException {
        try {
            return byteBuffer.hasRemaining() ? (long)this.socketChannel.write(byteBuffer) : 0L;
        }
        catch (IOException iOException) {
            try {
                if (!this.sslEngine.isOutboundDone()) {
                    this.sslEngine.closeOutbound();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.shutdown = true;
            throw iOException;
        }
    }

    private SSLEngineResult.HandshakeStatus runTasks() throws IOException {
        try {
            Runnable runnable;
            while ((runnable = this.sslEngine.getDelegatedTask()) != null) {
                runnable.run();
            }
            return this.sslEngine.getHandshakeStatus();
        }
        catch (Exception exception) {
            throw (IOException)new IOException("IO Error " + exception.getMessage()).initCause(exception);
        }
    }

    private boolean prepare(ByteBuffer[] byteBufferArray, int n2) {
        ByteBuffer byteBuffer = byteBufferArray[0];
        if (byteBuffer.compact().remaining() < n2) {
            int n3 = byteBuffer.position();
            int n4 = n3 + n2;
            if (n4 <= 2 * n2) {
                byteBuffer = ByteBuffer.allocate(n4);
                if (n3 > 0) {
                    byteBufferArray[0].flip();
                    byteBuffer.put(byteBufferArray[0]);
                    byteBufferArray[0] = byteBuffer;
                }
            } else {
                byteBuffer.flip();
                byteBuffer = null;
            }
        }
        return byteBuffer != null;
    }

    @Override
    public SocketAddress getRemoteAddress() throws IOException {
        return null;
    }

    @Override
    public SocketChannel shutdownOutput() throws IOException {
        return null;
    }

    @Override
    public SocketChannel shutdownInput() throws IOException {
        return null;
    }

    @Override
    public <T> SocketChannel setOption(SocketOption<T> socketOption, T t2) throws IOException {
        return null;
    }

    @Override
    public SocketChannel bind(SocketAddress socketAddress) throws IOException {
        return null;
    }

    @Override
    public Set<SocketOption<?>> supportedOptions() {
        return null;
    }

    @Override
    public <T> T getOption(SocketOption<T> socketOption) throws IOException {
        return null;
    }

    @Override
    public SocketAddress getLocalAddress() throws IOException {
        return null;
    }
}

