/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.patch;

import java.awt.Component;
import java.awt.EventQueue;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controls.WaitCursor;
import oracle.ide.exception.ChangeVetoException;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.net.URLFilter;
import oracle.ide.vcs.VCSManager;
import oracle.ideimpl.patch.res.Bundle;
import oracle.ideimpl.vcscore.VersioningCoreUtil;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.patch.PatchException;
import oracle.jdeveloper.patch.PatchExceptionHandler;

public abstract class BasePatchCommand
extends Command {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    public static final int ERROR = -1;
    public static final int NOOP = 9;
    private PatchExceptionHandler _exceptionHandler;

    protected BasePatchCommand(int cmdId) {
        super(cmdId, 1);
    }

    protected BasePatchCommand(int cmdId, int type) {
        super(cmdId, type);
    }

    protected BasePatchCommand(int cmdId, int type, String name) {
        super(cmdId, type, name);
    }

    public int doit() throws Exception {
        int result;
        Context context = this.getContext();
        int n = result = context != null && context.getBoolean("BasePatchController.THREAD_AUTHORIZED") && this.isThreaded() ? this.doit2() : this.doit3();
        if (context != null) {
            context.setInt("BasePatchController.COMMAND_RESULT", result);
        }
        return result;
    }

    public boolean isAvailable() {
        try {
            return this.isAvailableImpl();
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    public void noOp() {
        try {
            this.noOpImpl();
        }
        catch (PatchException ce) {
            this.getExceptionHandler().handleException(ce);
        }
    }

    protected boolean isAvailableImpl() throws Exception {
        return this.isAvailableImpl(this.getContextLocatables());
    }

    protected boolean isAvailableImpl(Locatable[] locatables) throws Exception {
        if (!this.verifyStyle(locatables) || !this.verifyType(locatables)) {
            return false;
        }
        for (int i = 0; i < Math.min(locatables.length, 3); ++i) {
            if (!this.isAvailableImpl(locatables[i])) continue;
            return true;
        }
        return false;
    }

    protected boolean isAvailableImpl(Locatable locatable) throws Exception {
        URL url = locatable.getURL();
        if (url == null || this.getURLFilter() != null && !this.getURLFilter().accept(url)) {
            return false;
        }
        return this.isAvailableImpl(url);
    }

    protected boolean isAvailableImpl(URL url) throws Exception {
        return true;
    }

    private boolean verifyStyle(Locatable[] locatables) {
        return true;
    }

    private boolean verifyType(Locatable[] locatables) {
        return true;
    }

    protected void noOpImpl() throws PatchException {
    }

    protected abstract int doitImpl() throws Exception;

    protected PatchExceptionHandler getExceptionHandler() {
        if (this._exceptionHandler == null) {
            this._exceptionHandler = new PatchExceptionHandler();
        }
        return this._exceptionHandler;
    }

    protected URLFilter getURLFilter() {
        return null;
    }

    protected boolean isThreaded() {
        return false;
    }

    protected final Locatable[] getContextLocatables() {
        Locatable[] locatables = VCSManager.getVCSManager().getContextLocatables(this.getContext());
        URLFilter filter = this.getURLFilter();
        if (filter == null) {
            return locatables;
        }
        ArrayList<Locatable> filtered = new ArrayList<Locatable>(Arrays.asList(locatables));
        Iterator itr = filtered.iterator();
        while (itr.hasNext()) {
            if (filter.accept(((Locatable)itr.next()).getURL())) continue;
            itr.remove();
        }
        return filtered.toArray(new Locatable[filtered.size()]);
    }

    protected final Context buildContextForEditor() {
        Context context = new Context(this.getContext());
        Locatable[] locatables = this.getContextLocatables();
        if (locatables.length > 0 && locatables[0] instanceof Node) {
            context.setNode((Node)locatables[0]);
        }
        return context;
    }

    protected final void updateReadOnlyStates(Node[] nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i].isReadOnly();
        }
    }

    protected final Collection getFilteredSelection() throws Exception {
        return this.getFilteredSelection(this.getContextLocatables());
    }

    protected final Collection getFilteredSelection(Locatable[] locatables) throws Exception {
        return new ArrayList<Locatable>(Arrays.asList(locatables));
    }

    private int doit2() {
        final WaitCursor wc = Ide.getWaitCursor();
        wc.show();
        Thread worker = new Thread("BasePatchCommand"){

            @Override
            public void run() {
                try {
                    BasePatchCommand.this.doit3();
                }
                catch (Exception e) {
                    try {
                        ExceptionDialog.showExceptionDialog((Component)VersioningCoreUtil.getCurrentWindow(), (Throwable)e, (String)Bundle.get("ERROR_TITLE"), (String)e.getMessage(), null);
                    }
                    catch (Throwable throwable) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                wc.hide();
                            }
                        });
                        throw throwable;
                    }
                    EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        };
        worker.start();
        return 0;
    }

    private int doit3() throws Exception {
        try {
            return this.doitImpl();
        }
        catch (Exception e) {
            if (e instanceof ChangeVetoException) {
                return 1;
            }
            if (!(e instanceof PatchException)) {
                throw e;
            }
            this.getExceptionHandler().handleException(e);
            return -1;
        }
    }
}

