/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.runner;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.datatypes.BindingMode;
import oracle.dbtools.raptor.datatypes.BindingStrategy;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.LockableDataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.unit_test.UtAddinArb;
import oracle.dbtools.unit_test.editor.UiArb;
import oracle.dbtools.unit_test.editor.UtEditor;
import oracle.dbtools.unit_test.process_validation.ValidationRegistry;
import oracle.dbtools.unit_test.runner.CoverageManager;
import oracle.dbtools.unit_test.runner.ResultsWriter;
import oracle.dbtools.unit_test.runner.StatusObject;
import oracle.dbtools.unit_test.runner.UtRunnerArb;
import oracle.dbtools.unit_test.runner.UtRunnerImplArgs;
import oracle.dbtools.unit_test.runner.UtRunnerImplIterator;
import oracle.dbtools.unit_test.runner.UtRunnerObject;
import oracle.dbtools.unit_test.startup.IStartup;
import oracle.dbtools.unit_test.startup.NullStartup;
import oracle.dbtools.unit_test.teardown.ITeardown;
import oracle.dbtools.unit_test.teardown.NullTeardown;
import oracle.dbtools.unit_test.testObjects.UtStartup;
import oracle.dbtools.unit_test.testObjects.UtSuite;
import oracle.dbtools.unit_test.testObjects.UtTeardown;
import oracle.dbtools.unit_test.testObjects.UtTest;
import oracle.dbtools.unit_test.testObjects.UtTestImpl;
import oracle.dbtools.unit_test.testObjects.UtValidation;
import oracle.dbtools.unit_test.utils.UtUtils;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;

public class Runner {
    private Connection _conn = null;
    private String _runnerDBQual = null;
    private StatusObject _connStatus = null;
    public static final String DATE_FORMAT_NOW = "dd-MM-yyyy HH:mm:ss";

    public Runner(String string) throws ConnectionCanceledException {
        this.openConn(string);
    }

    public Runner(Connection connection) throws ConnectionCanceledException {
        if (connection == null) {
            throw new ConnectionCanceledException();
        }
        this._conn = connection;
    }

    Connection getConn() {
        return this._conn;
    }

    String getRunnerDBQual() {
        return this._runnerDBQual;
    }

    private void openConn(String string) throws ConnectionCanceledException {
        if (this._conn == null) {
            try {
                StatusObject statusObject = new StatusObject("UT_RUNNING", null, false);
                this._runnerDBQual = UtUtils.getRunnerConnection(string);
                if (this._runnerDBQual == null) {
                    throw new ConnectionCanceledException();
                }
                this._conn = UtUtils.openRunnerConnection(this._runnerDBQual);
                statusObject.setMessage(null);
                statusObject.setStatus("UT_SUCCESS");
            }
            catch (Exception exception) {
                if (exception.getCause() != exception && exception.getCause() instanceof ConnectionCanceledException) {
                    ConnectionCanceledException connectionCanceledException = (ConnectionCanceledException)exception.getCause();
                    throw connectionCanceledException;
                }
                this._connStatus = new StatusObject("UT_ERROR", null, false);
                this._connStatus.setMessage(exception.getLocalizedMessage());
            }
        }
    }

    void closeConn() {
        try {
            if (null != this._runnerDBQual) {
                UtUtils.closeRunnerConnection(this._conn);
            }
        }
        finally {
            this._connStatus = null;
            this._conn = null;
            this._runnerDBQual = null;
        }
    }

    StatusObject getConnectionStatus() {
        if (this._connStatus != null) {
            return this._connStatus.clone();
        }
        if (this._conn != null) {
            return new StatusObject("UT_RUNNING", null, false);
        }
        return new StatusObject("UT_ERROR", UtRunnerArb.getString("RUNNER_NO_CONN"), false);
    }

    public void executeSuite(final UtSuite utSuite, final String string, final boolean bl, final boolean bl2) {
        RaptorTask<StatusObject> raptorTask = new RaptorTask<StatusObject>(UtRunnerArb.format("UT_TASK_NAME", utSuite.getSuiteName()), true, IRaptorTaskRunMode.MODAL_OPTIONAL){

            protected StatusObject doWork() throws TaskException {
                return Runner.this.executeSuiteCMD(utSuite, string, bl, bl2);
            }
        };
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new UtRunnerTaskListener(utSuite.getSid()));
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    public void executeTest(final UtTest utTest, final String string, final boolean bl, final boolean bl2) {
        RaptorTask<StatusObject> raptorTask = new RaptorTask<StatusObject>(UtRunnerArb.format("UT_TASK_NAME", utTest.getTestName()), true, IRaptorTaskRunMode.MODAL_OPTIONAL){

            protected StatusObject doWork() throws TaskException {
                return Runner.this.executeTestCMD(utTest, string, bl, bl2);
            }
        };
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new UtRunnerTaskListener(utTest.getId()));
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    public StatusObject executeSuiteCMD(UtSuite utSuite, String string, boolean bl, boolean bl2) {
        return this.executeSuiteCMD(utSuite, string, false, bl, bl2);
    }

    public StatusObject executeSuiteCMD(UtSuite utSuite, String string, boolean bl, boolean bl2, boolean bl3) {
        StatusObject statusObject;
        block22: {
            List<UtStartup> list;
            bl = bl || utSuite != null && utSuite.getCoverage();
            statusObject = this.getConnectionStatus();
            StatusObject statusObject2 = null;
            StatusObject statusObject3 = null;
            statusObject.setCoverage(bl);
            statusObject.setReturn(string);
            try {
                Object object;
                Object object2;
                string = ResultsWriter.mergeSuiteResult(utSuite, string, statusObject, statusObject2, statusObject3);
                statusObject.setReturn(string);
                if (!"UT_RUNNING".equals(statusObject.getStatus())) break block22;
                IStartup iStartup = null;
                if (bl2) {
                    list = null;
                    list = utSuite.getStartups();
                    int n = list.size();
                    if (n > 0) {
                        statusObject2 = new StatusObject("UT_SUCCESS", null, bl);
                        int n2 = 0;
                        for (UtStartup utStartup : list) {
                            ++n2;
                            iStartup = utStartup.getStartupCodeHook();
                            if (iStartup instanceof NullStartup) continue;
                            statusObject2.beginTimer();
                            try {
                                iStartup.performWork(this._conn);
                                statusObject2.endTimer();
                            }
                            catch (Exception exception) {
                                statusObject2.endTimer();
                                String string2 = iStartup.getDisplayName();
                                String string3 = UtRunnerArb.format("UT_HOOK_IDENT", UtRunnerArb.format("UT_STARTUP_NAME", string2), n2, n);
                                String string4 = UtRunnerArb.format("UT_TASK_FAIL", string3, exception.getLocalizedMessage());
                                statusObject.setStatus("UT_ERROR");
                                statusObject.setMessage(string4);
                                statusObject2 = new StatusObject("UT_ERROR", string4, bl);
                                string = ResultsWriter.mergeSuiteResult(utSuite, string, statusObject, statusObject2, statusObject3);
                                statusObject.setReturn(string);
                                StatusObject statusObject4 = statusObject;
                                if ("UT_RUNNING".equals(statusObject.getStatus())) {
                                    statusObject.setStatus("UT_SUCCESS");
                                }
                                string = ResultsWriter.mergeSuiteResult(utSuite, string, statusObject, statusObject2, statusObject3);
                                statusObject.setReturn(string);
                                return statusObject4;
                            }
                        }
                    }
                }
                int n = 0;
                List<UtSuite.SuiteItem> list2 = utSuite.getItems();
                for (UtSuite.SuiteItem suiteItem : list2) {
                    String string5;
                    Object object3;
                    String string6 = suiteItem.getUtId();
                    if (string6 != null) {
                        object3 = new UtTest(string6);
                        string5 = UUID.randomUUID().toString();
                        object2 = this.executeTestCMD((UtTest)object3, string5, bl, suiteItem.runStartup(), suiteItem.runTeardown());
                        if ("UT_ERROR".equals(((StatusObject)object2).getStatus())) {
                            statusObject.setStatus("UT_ERROR");
                            object = null;
                            object = statusObject.getMessage() != null ? statusObject.getMessage() + System.getenv("line_terminator") + UtRunnerArb.format("UT_TASK_FAIL", utSuite.getSuiteName(), ((StatusObject)object2).getMessage()) : UtRunnerArb.format("UT_TASK_FAIL", utSuite.getSuiteName(), ((StatusObject)object2).getMessage());
                            statusObject.setMessage((String)object);
                        }
                        ResultsWriter.addTestToSuite(string, string5, n++);
                        continue;
                    }
                    string5 = suiteItem.getUtNsid();
                    object2 = new UtSuite(string5);
                    object = this.executeSuiteCMD((UtSuite)object2, (String)(object3 = UUID.randomUUID().toString()), bl, suiteItem.runStartup(), suiteItem.runTeardown());
                    if ("UT_ERROR".equals(((StatusObject)object).getStatus())) {
                        statusObject.setStatus("UT_ERROR");
                        String string7 = null;
                        string7 = statusObject.getMessage() != null ? statusObject.getMessage() + System.getenv("line_terminator") + UtRunnerArb.format("UT_TASK_FAIL", utSuite.getSuiteName(), ((StatusObject)object).getMessage()) : UtRunnerArb.format("UT_TASK_FAIL", utSuite.getSuiteName(), ((StatusObject)object).getMessage());
                        statusObject.setMessage(string7);
                    }
                    ResultsWriter.addNestedSuiteToSuite(string, (String)object3, n++);
                }
                if (bl3) {
                    List<UtTeardown> list3 = utSuite.getTeardowns();
                    Object var13_20 = null;
                    int n2 = list3.size();
                    if (n2 > 0) {
                        statusObject3 = new StatusObject("UT_SUCCESS", null, bl);
                        int n3 = 0;
                        boolean bl4 = false;
                        object2 = list3.iterator();
                        while (object2.hasNext()) {
                            object = (UtTeardown)object2.next();
                            ++n3;
                            ITeardown iTeardown = ((UtTeardown)object).getTeardownCodeHook();
                            if (iTeardown instanceof NullTeardown) continue;
                            statusObject3.beginTimer();
                            try {
                                iTeardown.performWork(this._conn, iStartup);
                                statusObject3.endTimer();
                            }
                            catch (Exception exception) {
                                statusObject3.endTimer();
                                if (bl4) continue;
                                bl4 = true;
                                String string8 = iTeardown.getDisplayName();
                                String string9 = UtRunnerArb.format("UT_HOOK_IDENT", UtRunnerArb.format("UT_TEARDOWN_NAME", string8), n3, n2);
                                String string10 = UtRunnerArb.format("UT_TASK_FAIL", string9, exception.getLocalizedMessage());
                                statusObject.setStatus("UT_ERROR");
                                statusObject.setMessage(string10);
                                statusObject3.setStatus("UT_ERROR");
                                statusObject3.setMessage(string10);
                                string = ResultsWriter.mergeSuiteResult(utSuite, string, statusObject, statusObject2, statusObject3);
                                statusObject.setReturn(string);
                            }
                        }
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                list = UtRunnerArb.format("UT_TASK_FAIL", utSuite.getSuiteName(), runtimeException.getStackTrace()[0].toString());
                statusObject.setStatus("UT_ERROR");
                statusObject.setMessage((String)((Object)list));
                throw runtimeException;
            }
            finally {
                if ("UT_RUNNING".equals(statusObject.getStatus())) {
                    statusObject.setStatus("UT_SUCCESS");
                }
                string = ResultsWriter.mergeSuiteResult(utSuite, string, statusObject, statusObject2, statusObject3);
                statusObject.setReturn(string);
            }
        }
        return statusObject;
    }

    public StatusObject executeTestCMD(UtTest utTest, String string, boolean bl, boolean bl2) {
        return this.executeTestCMD(utTest, string, false, bl, bl2);
    }

    public StatusObject executeTestCMD(UtTest utTest, String string, boolean bl, boolean bl2, boolean bl3) {
        bl = bl || utTest != null && utTest.getCoverage();
        StatusObject statusObject = this.getConnectionStatus();
        String string2 = null;
        String string3 = null;
        statusObject.setCoverage(bl);
        statusObject.setReturn(string);
        try {
            if (this._conn != null) {
                String string4 = UtUtils.getDbQualName(this._conn);
                if (string4 != null) {
                    string2 = Connections.getDisplayName((String)string4);
                }
                string3 = UtUtils.getUserName(this._conn);
            }
            string = ResultsWriter.mergeTestResult(utTest, string, string3, string2, statusObject);
            statusObject.setReturn(string);
            if ("UT_RUNNING".equals(statusObject.getStatus())) {
                for (UtTestImpl utTestImpl : utTest.getImpls()) {
                    String string5;
                    StatusObject statusObject2 = this.executeImpl(utTestImpl, string, false, bl, bl2, bl3);
                    if (statusObject2 != null) {
                        if (!"UT_ERROR".equals(statusObject2.getStatus())) continue;
                        statusObject.setStatus("UT_ERROR");
                        string5 = UtRunnerArb.format("UT_TASK_FAIL", utTest.getTestName(), statusObject2.getMessage());
                        statusObject.setMessage(string5);
                        continue;
                    }
                    statusObject.setStatus("UT_ERROR");
                    string5 = UtRunnerArb.getString("DQV_NO_VALUES");
                    statusObject.setMessage(string5);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            String string6 = UtRunnerArb.format("UT_TASK_FAIL", utTest.getTestName(), runtimeException.getStackTrace()[0].toString());
            statusObject.setStatus("UT_ERROR");
            statusObject.setMessage(string6);
            throw runtimeException;
        }
        finally {
            if ("UT_RUNNING".equals(statusObject.getStatus())) {
                statusObject.setStatus("UT_SUCCESS");
            }
            string = ResultsWriter.mergeTestResult(utTest, string, string3, string2, statusObject);
            statusObject.setReturn(string);
        }
        return statusObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StatusObject executeImpl(UtTestImpl utTestImpl, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        StatusObject statusObject = this.getConnectionStatus();
        statusObject.setCoverage(bl2);
        if ("UT_RUNNING".equals(statusObject.getStatus())) {
            if (utTestImpl != null) {
                LockableDataTypeConnectionProvider lockableDataTypeConnectionProvider = new LockableDataTypeConnectionProvider(this._conn);
                UtRunnerImplIterator utRunnerImplIterator = utTestImpl.getRunnerIterator((DataTypeConnectionProvider)lockableDataTypeConnectionProvider);
                if (bl2) {
                    CoverageManager coverageManager = new CoverageManager(this._conn);
                    if (coverageManager.profilerInstalled()) {
                        utRunnerImplIterator.setCoverageManager(new CoverageManager(this._conn));
                    } else {
                        statusObject.setStatus("UT_ERROR");
                        statusObject.setMessage(UtRunnerArb.getString("PROFILER_NOT_INSTALLED"));
                    }
                }
                if ("UT_RUNNING".equals(statusObject.getStatus())) {
                    try {
                        utRunnerImplIterator.open();
                        for (int i = 0; (i < 1 || !bl) && utRunnerImplIterator.hasNext(); ++i) {
                            UtRunnerObject utRunnerObject = utRunnerImplIterator.next();
                            statusObject = this.executeRunnerObject(utTestImpl, string, utRunnerObject, bl, bl2, bl3, bl4);
                            if (!"UT_ERROR".equals(statusObject.getStatus())) continue;
                        }
                    }
                    catch (SQLException sQLException) {
                        String string2 = UtRunnerArb.format("DQV_ERROR", sQLException.getLocalizedMessage());
                        statusObject.setStatus("UT_ERROR");
                        statusObject.setMessage(UtRunnerArb.getString(string2));
                    }
                    finally {
                        utRunnerImplIterator.close();
                    }
                }
            } else {
                statusObject.setStatus("UT_ERROR");
                statusObject.setMessage(UtRunnerArb.getString("DEBUG_NO_IMPL"));
            }
        }
        return statusObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    protected StatusObject executeRunnerObject(UtTestImpl utTestImpl, String string, UtRunnerObject utRunnerObject, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        StatusObject statusObject;
        StatusObject statusObject2;
        StatusObject statusObject3;
        String string2;
        StatusObject statusObject4;
        block83: {
            block81: {
                int n;
                Object object;
                String string3;
                String string4;
                String string5;
                Object object2;
                Object object3;
                Object object4;
                Object object52;
                Iterator iterator2;
                int n2;
                statusObject4 = this.getConnectionStatus();
                string2 = null;
                statusObject3 = null;
                statusObject2 = null;
                statusObject = null;
                statusObject4.setCoverage(bl2);
                if (!bl) {
                    string2 = ResultsWriter.mergeTestImplResult(utTestImpl, string, null, statusObject4, statusObject3, statusObject2, statusObject);
                }
                if (!"UT_RUNNING".equals(statusObject4.getStatus())) break block83;
                statusObject4.beginTimer();
                List<UtStartup> list = null;
                IStartup iStartup = null;
                if (bl3 && (n2 = (list = utTestImpl.getTest().getStartups()).size()) > 0) {
                    statusObject3 = new StatusObject("UT_SUCCESS", null, bl2);
                    int n3 = 0;
                    for (Object object6 : list) {
                        ++n3;
                        iStartup = ((UtStartup)object6).getStartupCodeHook();
                        if (iStartup == null || iStartup instanceof NullStartup) continue;
                        statusObject3.beginTimer();
                        try {
                            iStartup.performWork(this._conn);
                            statusObject3.endTimer();
                        }
                        catch (Exception exception) {
                            statusObject3.endTimer();
                            String string6 = iStartup != null ? iStartup.getDisplayName() : "<null>";
                            String string7 = UtRunnerArb.format("UT_HOOK_IDENT", UtRunnerArb.format("UT_STARTUP_NAME", string6), n3, n2);
                            String string8 = UtRunnerArb.format("UT_TASK_FAIL", string7, exception.getLocalizedMessage());
                            statusObject3.setStatus("UT_ERROR");
                            statusObject3.setMessage(string8);
                            statusObject4.setStatus("UT_ERROR");
                            statusObject4.setMessage(string8);
                            statusObject4.endTimer();
                            if (!bl) {
                                string2 = ResultsWriter.mergeTestImplResult(utTestImpl, string, string2, statusObject4, statusObject3, statusObject2, statusObject);
                            }
                            return new StatusObject("UT_ERROR", string8, bl2);
                        }
                    }
                    if (!bl) {
                        string2 = ResultsWriter.mergeTestImplResult(utTestImpl, string, string2, statusObject4, statusObject3, statusObject2, statusObject);
                    }
                }
                Statement statement = null;
                Iterable<Throwable> iterable = null;
                Object object7 = new HashMap();
                statusObject2 = new StatusObject("UT_SUCCESS", null, bl2);
                try {
                    statement = this._conn.prepareCall(utRunnerObject.getSql());
                    for (Iterator iterator2 : utRunnerObject.getBinds()) {
                        object52 = (UtRunnerImplArgs)iterator2.getParameter();
                        object52.bind((CallableStatement)statement, (BindingStrategy)iterator2);
                        object4 = object52.getMode();
                        if (BindingMode.OUT == object4.getEffectiveMode()) continue;
                        object3 = object52.getInputDataValue();
                        object2 = object52.getName();
                        ((HashMap)object7).put(object2, object3);
                        if (bl) continue;
                        string5 = object52.getArgId();
                        string4 = object52.getName();
                        string3 = UtRunnerArb.format("UT_VALUE_DETAIL", object3.getStringValue());
                        object = new StatusObject(UtRunnerArb.getString("NONE"), string3, bl2);
                        ResultsWriter.mergeTestImplArgResult(null, string2, utTestImpl.getUtiId(), string5, string4, (StatusObject)object);
                    }
                    if (utRunnerObject.getCoverageManager() != null) {
                        utRunnerObject.getCoverageManager().startCoverage();
                    }
                    statusObject2.beginTimer();
                    try {
                        statement.execute();
                    }
                    catch (SQLException sQLException) {
                        iterable = sQLException;
                    }
                    statusObject2.endTimer();
                }
                finally {
                    if (utRunnerObject.getCoverageManager() != null) {
                        utRunnerObject.getCoverageManager().stopCoverage();
                    }
                }
                if (iterable == null) {
                    if (UiArb.get("EXCEPTION").equals(utTestImpl.getExpectedStatus())) {
                        statusObject2.setStatus("UT_ERROR");
                        statusObject2.setMessage(UtRunnerArb.getString("DEBUG_NO_ERROR"));
                        statusObject4.setStatus("UT_ERROR");
                        statusObject4.setMessage(UtRunnerArb.getString("DEBUG_NO_ERROR"));
                        statusObject4.addDebug(statusObject4.getMessage());
                    }
                } else {
                    Object object6;
                    object6 = utTestImpl.getExpectedErrorCode();
                    String string9 = String.valueOf(((SQLException)iterable).getErrorCode());
                    String string10 = string9 + ": " + ((Throwable)((Object)iterable)).getLocalizedMessage();
                    if (UiArb.get("EXCEPTION").equals(utTestImpl.getExpectedStatus()) && "ANY".equals(object6)) {
                        iterator2 = UtRunnerArb.format("UT_ASSERT_EXCEPTION_DETAIL", object6, string10);
                        statusObject2.setMessage((String)((Object)iterator2));
                        statusObject2.setStatus("UT_SUCCESS");
                        statusObject4.setMessage((String)((Object)iterator2));
                        statusObject4.setStatus("UT_SUCCESS");
                    } else if (UiArb.get("EXCEPTION").equals(utTestImpl.getExpectedStatus()) && string9.equals(object6)) {
                        iterator2 = UtRunnerArb.format("UT_ASSERT_EXCEPTION_DETAIL", object6, string10);
                        statusObject2.setMessage((String)((Object)iterator2));
                        statusObject2.setStatus("UT_SUCCESS");
                        statusObject4.setMessage((String)((Object)iterator2));
                        statusObject4.setStatus("UT_SUCCESS");
                    } else if (!UiArb.get("EXCEPTION").equals(utTestImpl.getExpectedStatus())) {
                        iterator2 = UtRunnerArb.format("UT_ASSERT_EXCEPTION_DETAIL", UtRunnerArb.getString("NONE"), string10);
                        statusObject2.setStatus("UT_ERROR");
                        statusObject2.setMessage((String)((Object)iterator2));
                        statusObject4.setStatus("UT_ERROR");
                        statusObject4.setMessage((String)((Object)iterator2));
                    } else {
                        iterator2 = UtRunnerArb.format("UT_ASSERT_EXCEPTION_DETAIL", object6, string10);
                        statusObject2.setStatus("UT_ERROR");
                        statusObject2.setMessage((String)((Object)iterator2));
                        statusObject4.setStatus("UT_ERROR");
                        statusObject4.setMessage((String)((Object)iterator2));
                    }
                    statusObject4.addDebug(statusObject4.getMessage());
                }
                for (Iterator iterator2 : utRunnerObject.getBinds()) {
                    object52 = (UtRunnerImplArgs)iterator2.getParameter();
                    object4 = object52.getMode();
                    object3 = object52.getName();
                    object2 = new StatusObject(UtRunnerArb.getString("UT_RUNNING"), null, bl2);
                    if (object4 == BindingMode.IN) continue;
                    string5 = object52.getArgId();
                    string4 = null;
                    if (!bl) {
                        string4 = ResultsWriter.mergeTestImplArgResult(string4, string2, utTestImpl.getUtiId(), string5, (String)object3, (StatusObject)object2);
                    }
                    string3 = object52.getOutput((BindingStrategy)iterator2);
                    object = null;
                    object = object4 == BindingMode.RETURN ? "RETURNS$" : object52.getName() + "$";
                    ((HashMap)object7).put(object, string3);
                    DataValue dataValue = object52.getResultDataValue();
                    StringValue stringValue = null;
                    stringValue = object52.getTestOutVal() ? dataValue.getStringValue() : new StringValue((CharSequence)UtRunnerArb.getString("OUT_VALUE_IGNORED"));
                    String string11 = UtRunnerArb.format("UT_ASSERT_DETAIL", stringValue, string3.getStringValue());
                    if (object52.getTestOutVal() && !dataValue.equals(string3)) {
                        ((StatusObject)object2).setStatus("UT_ERROR");
                        if (!statusObject2.getStatus().equals("UT_ERROR")) {
                            statusObject2.setStatus("UT_ERROR");
                            statusObject2.setMessage(UtRunnerArb.format("UT_TASK_FAIL", utTestImpl.getName(), string11));
                        }
                        if (!statusObject4.getStatus().equals("UT_ERROR")) {
                            statusObject4.setStatus("UT_ERROR");
                            statusObject4.setMessage(UtRunnerArb.format("UT_TASK_FAIL", utTestImpl.getName(), string11));
                        }
                    } else if (object52.getTestOutVal()) {
                        ((StatusObject)object2).setStatus("UT_SUCCESS");
                    } else {
                        ((StatusObject)object2).setStatus("UT_WARNING");
                    }
                    ((StatusObject)object2).setMessage(string11);
                    if (bl) {
                        String string12 = object52.getName();
                        if (string12 != null && !string12.equals("")) {
                            statusObject4.addDebug(object52.getName() + " : " + ((StatusObject)object2).getMessage());
                            continue;
                        }
                        statusObject4.addDebug(UtAddinArb.getString("RETURNS_ARG_NAME") + " : " + ((StatusObject)object2).getMessage());
                        continue;
                    }
                    string4 = ResultsWriter.mergeTestImplArgResult(string4, string2, utTestImpl.getUtiId(), string5, (String)object3, (StatusObject)object2);
                }
                for (n = 0; n < utTestImpl.getValidationCount(); ++n) {
                    String string13 = null;
                    UtValidation utValidation = utTestImpl.getValidation(n);
                    if (utValidation.getApplyValidation()) {
                        iterator2 = new StatusObject("UT_RUNNING", null, bl2);
                        object52 = utValidation.getValidationCodeHook();
                        object4 = ValidationRegistry.getKeyFor(object52.getClass().getName());
                        if (!bl) {
                            string13 = ResultsWriter.mergeTestImplValResult(string13, string2, utTestImpl.getUtiId(), utValidation.getValidationId(), (String)object4, iterator2);
                        }
                        try {
                            ((StatusObject)((Object)iterator2)).beginTimer();
                            object52.runValidation(utRunnerObject.getProvider(), (Map<String, Object>)object7);
                            ((StatusObject)((Object)iterator2)).endTimer();
                            ((StatusObject)((Object)iterator2)).setStatus("UT_SUCCESS");
                            continue;
                        }
                        catch (Exception exception) {
                            ((StatusObject)((Object)iterator2)).endTimer();
                            object2 = object52.getDisplayName();
                            string5 = UtRunnerArb.format("UT_TASK_FAIL", UtRunnerArb.format("UT_VALIDATION_NAME", object2), exception.getLocalizedMessage());
                            ((StatusObject)((Object)iterator2)).setStatus("UT_ERROR");
                            ((StatusObject)((Object)iterator2)).setMessage(string5);
                            if (!statusObject4.getStatus().equals("UT_ERROR")) {
                                statusObject4.setStatus("UT_ERROR");
                                statusObject4.setMessage(UtRunnerArb.format("UT_TASK_FAIL", utTestImpl.getName(), string5));
                            }
                            if (!bl) break;
                            statusObject4.addDebug(((StatusObject)((Object)iterator2)).getMessage());
                            break;
                        }
                        finally {
                            if (!bl) {
                                string13 = ResultsWriter.mergeTestImplValResult(string13, string2, utTestImpl.getUtiId(), utValidation.getValidationId(), (String)object4, iterator2);
                            }
                        }
                    }
                    iterator2 = new StatusObject("UT_WARNING", UtRunnerArb.getString("VALIDATION_IGNORED"), bl2);
                    object52 = utValidation.getValidationCodeHook();
                    object4 = ValidationRegistry.getKeyFor(object52.getClass().getName());
                    string13 = ResultsWriter.mergeTestImplValResult(string13, string2, utTestImpl.getUtiId(), utValidation.getValidationId(), (String)object4, iterator2);
                }
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (bl4) {
                        iterable = utTestImpl.getTest().getTeardowns();
                        object7 = null;
                        n = iterable.size();
                        if (n > 0) {
                            statusObject = new StatusObject("UT_SUCCESS", null, bl2);
                            int n4 = 0;
                            boolean bl5 = false;
                            for (Object object52 : iterable) {
                                ++n4;
                                object7 = ((UtTeardown)object52).getTeardownCodeHook();
                                if (object7 == null || object7 instanceof NullTeardown) continue;
                                statusObject.beginTimer();
                                try {
                                    object7.performWork(this._conn, iStartup);
                                    statusObject.endTimer();
                                }
                                catch (Exception exception) {
                                    statusObject.endTimer();
                                    if (bl5) continue;
                                    bl5 = true;
                                    object3 = object7 != null ? object7.getDisplayName() : "<null>";
                                    object2 = UtRunnerArb.format("UT_HOOK_IDENT", UtRunnerArb.format("UT_TEARDOWN_NAME", object3), n4, n);
                                    string5 = UtRunnerArb.format("UT_TASK_FAIL", object2, exception.getLocalizedMessage());
                                    statusObject.setStatus("UT_ERROR");
                                    statusObject.setMessage(string5);
                                    if (statusObject4.getStatus().equals("UT_ERROR")) continue;
                                    statusObject4.setStatus("UT_ERROR");
                                    statusObject4.setMessage(string5);
                                }
                            }
                            if (!bl) {
                                string2 = ResultsWriter.mergeTestImplResult(utTestImpl, string, string2, statusObject4, statusObject3, statusObject2, statusObject);
                            }
                        }
                    }
                    break block81;
                }
                catch (Exception exception) {
                    statusObject4.setStatus("UT_ERROR");
                    statusObject4.setMessage(exception.getStackTrace()[0].toString());
                }
                break block81;
                catch (Exception exception) {
                    block82: {
                        object7 = UtUtils.asString(exception);
                        if (1024 < ((String)object7).length()) {
                            object7 = ((String)object7).substring(0, 1020) + " ...";
                        }
                        if (!statusObject2.getStatus().equals("UT_ERROR")) {
                            statusObject2.setStatus("UT_ERROR");
                            statusObject2.setMessage((String)object7);
                        }
                        if (statusObject4.getStatus().equals("UT_ERROR")) break block82;
                        statusObject4.setStatus("UT_ERROR");
                        statusObject4.setMessage((String)object7);
                    }
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                        if (bl4) {
                            List<UtTeardown> list2 = utTestImpl.getTest().getTeardowns();
                            object7 = null;
                            int n5 = list2.size();
                            if (n5 > 0) {
                                statusObject = new StatusObject("UT_SUCCESS", null, bl2);
                                int n6 = 0;
                                boolean bl6 = false;
                                for (UtTeardown utTeardown : list2) {
                                    ++n6;
                                    object7 = utTeardown.getTeardownCodeHook();
                                    if (object7 == null || object7 instanceof NullTeardown) continue;
                                    statusObject.beginTimer();
                                    try {
                                        object7.performWork(this._conn, iStartup);
                                        statusObject.endTimer();
                                    }
                                    catch (Exception exception2) {
                                        statusObject.endTimer();
                                        if (bl6) continue;
                                        bl6 = true;
                                        String string14 = object7 != null ? object7.getDisplayName() : "<null>";
                                        String string15 = UtRunnerArb.format("UT_HOOK_IDENT", UtRunnerArb.format("UT_TEARDOWN_NAME", string14), n6, n5);
                                        String string16 = UtRunnerArb.format("UT_TASK_FAIL", string15, exception2.getLocalizedMessage());
                                        statusObject.setStatus("UT_ERROR");
                                        statusObject.setMessage(string16);
                                        if (statusObject4.getStatus().equals("UT_ERROR")) continue;
                                        statusObject4.setStatus("UT_ERROR");
                                        statusObject4.setMessage(string16);
                                    }
                                }
                                if (!bl) {
                                    string2 = ResultsWriter.mergeTestImplResult(utTestImpl, string, string2, statusObject4, statusObject3, statusObject2, statusObject);
                                }
                            }
                        }
                    }
                    catch (Exception exception3) {
                        statusObject4.setStatus("UT_ERROR");
                        statusObject4.setMessage(exception3.getStackTrace()[0].toString());
                    }
                    catch (Throwable throwable) {
                        try {
                            if (statement != null) {
                                statement.close();
                            }
                            if (bl4) {
                                List<UtTeardown> list3 = utTestImpl.getTest().getTeardowns();
                                ITeardown iTeardown = null;
                                int n7 = list3.size();
                                if (n7 > 0) {
                                    statusObject = new StatusObject("UT_SUCCESS", null, bl2);
                                    int n8 = 0;
                                    boolean bl7 = false;
                                    for (UtTeardown utTeardown : list3) {
                                        ++n8;
                                        iTeardown = utTeardown.getTeardownCodeHook();
                                        if (iTeardown == null || iTeardown instanceof NullTeardown) continue;
                                        statusObject.beginTimer();
                                        try {
                                            iTeardown.performWork(this._conn, iStartup);
                                            statusObject.endTimer();
                                        }
                                        catch (Exception exception4) {
                                            statusObject.endTimer();
                                            if (bl7) continue;
                                            bl7 = true;
                                            String string17 = iTeardown != null ? iTeardown.getDisplayName() : "<null>";
                                            String string18 = UtRunnerArb.format("UT_HOOK_IDENT", UtRunnerArb.format("UT_TEARDOWN_NAME", string17), n8, n7);
                                            String string19 = UtRunnerArb.format("UT_TASK_FAIL", string18, exception4.getLocalizedMessage());
                                            statusObject.setStatus("UT_ERROR");
                                            statusObject.setMessage(string19);
                                            if (statusObject4.getStatus().equals("UT_ERROR")) continue;
                                            statusObject4.setStatus("UT_ERROR");
                                            statusObject4.setMessage(string19);
                                        }
                                    }
                                    if (!bl) {
                                        string2 = ResultsWriter.mergeTestImplResult(utTestImpl, string, string2, statusObject4, statusObject3, statusObject2, statusObject);
                                    }
                                }
                            }
                        }
                        catch (Exception exception5) {
                            statusObject4.setStatus("UT_ERROR");
                            statusObject4.setMessage(exception5.getStackTrace()[0].toString());
                        }
                        throw throwable;
                    }
                }
            }
            if ("UT_RUNNING".equals(statusObject4.getStatus())) {
                statusObject4.setStatus("UT_SUCCESS");
            }
            statusObject4.endTimer();
        }
        if (!bl) {
            string2 = ResultsWriter.mergeTestImplResult(utTestImpl, string, string2, statusObject4, statusObject3, statusObject2, statusObject);
        }
        if (utRunnerObject.getCoverageManager() != null) {
            utRunnerObject.getCoverageManager().collectStats(utTestImpl.getUtiId(), string2);
        }
        return statusObject4;
    }

    class UtRunnerTaskListener
    extends RaptorTaskAdapter {
        private String _watchedObjId;

        public UtRunnerTaskListener(String string) {
            if (null == string || 0 == string.length()) {
                String string2 = "InternalError: watchedObjId must not be null/empty";
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, string2);
                throw new IllegalArgumentException(string2);
            }
            this._watchedObjId = string;
        }

        public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
            String string = UtRunnerArb.format("UT_TASK_FAIL", raptorTaskEvent.getTaskDescriptor().getName(), raptorTaskEvent.getTaskDescriptor().getMessage());
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, string);
        }

        public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
            Runner.this.closeConn();
        }

        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
            Runner.this.closeConn();
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        UtRunnerTaskListener.this.updateUI();
                    }
                });
            } else {
                this.updateUI();
            }
        }

        private void updateUI() {
            List list = EditorManager.getEditorManager().getAllEditors();
            for (Editor editor : list) {
                UtEditor utEditor;
                if (!(editor instanceof UtEditor) || !this._watchedObjId.equals((utEditor = (UtEditor)editor).getElementId())) continue;
                utEditor.refresh();
                break;
            }
        }
    }
}

