/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.process_validation;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.unit_test.process_validation.AbstractCompare;
import oracle.dbtools.unit_test.process_validation.ValidationArb;
import oracle.dbtools.unit_test.utils.UtUtils;

public class TableCompare
extends AbstractCompare {
    private String _name = ValidationArb.getString("TABLE_COMPARE_NAME");
    private JTextField _sourceTableField = new JTextField("", 30);
    private JTextField _targetTableField = new JTextField("", 30);
    private JButton _sourceBrowseButton = new JButton(ValidationArb.getString("BROWSE_BUTTON_LABEL"));
    private JButton _targetBrowseButton = new JButton(ValidationArb.getString("BROWSE_BUTTON_LABEL"));

    public TableCompare() {
        this.onChangeEditability();
    }

    @Override
    public String getHookName() {
        return this._name;
    }

    @Override
    public String getDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this._sourceTableField.getText());
        stringBuffer.append(" = ");
        stringBuffer.append(this._targetTableField.getText());
        return stringBuffer.toString();
    }

    @Override
    protected Component createComponent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(ValidationArb.getString("SOURCE_TABLE_LABEL") + " ");
        JLabel jLabel2 = new JLabel(ValidationArb.getString("TARGET_TABLE_LABEL") + " ");
        JLabel jLabel3 = new JLabel(ValidationArb.getString("TABLE_COMPARE_NOTE"));
        Insets insets = new Insets(10, 10, 10, 10);
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        jPanel.add((Component)this._sourceTableField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
        jPanel.add((Component)this._sourceBrowseButton, new GridBagConstraints(2, 0, 0, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        jPanel.add((Component)this._targetTableField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
        jPanel.add((Component)this._targetBrowseButton, new GridBagConstraints(2, 1, 0, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, 2, 0, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        this.setUpChangeListener(this._sourceTableField);
        this.setUpChangeListener(this._targetTableField);
        this._sourceBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = UtUtils.selectTableName();
                if (string != null) {
                    TableCompare.this._sourceTableField.setText(string);
                }
            }
        });
        this._targetBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = UtUtils.selectTableName();
                if (string != null) {
                    TableCompare.this._targetTableField.setText(string);
                }
            }
        });
        return jPanel;
    }

    @Override
    public String getXml() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        stringBuilder.append("<validation>");
        stringBuilder.append("<class><![CDATA[" + this.getClass().getCanonicalName() + "]]></class>");
        stringBuilder.append("<name><![CDATA[" + this._name + "]]></name>");
        stringBuilder.append("<description><![CDATA[" + this.getDescription() + "]]></description>");
        stringBuilder.append("<source><![CDATA[" + this._sourceTableField.getText() + "]]></source>");
        stringBuilder.append("<target><![CDATA[" + this._targetTableField.getText() + "]]></target>");
        stringBuilder.append("</validation>");
        return stringBuilder.toString();
    }

    @Override
    public void loadFromXml(String string) {
        String string2 = "";
        String string3 = "";
        if (string != null) {
            string2 = UtUtils.getXmlValue(string, "validation", "source");
            string3 = UtUtils.getXmlValue(string, "validation", "target");
        }
        this._sourceTableField.setText(string2);
        this._targetTableField.setText(string3);
    }

    @Override
    protected void onChangeEditability() {
        this._sourceTableField.setEditable(this.isEditable());
        this._targetTableField.setEditable(this.isEditable());
        this._sourceBrowseButton.setEnabled(this.isEditable());
        this._targetBrowseButton.setEnabled(this.isEditable());
    }

    @Override
    public void runValidation(DataTypeConnectionProvider dataTypeConnectionProvider, Map<String, Object> map) throws Exception {
        String string;
        Connection connection = dataTypeConnectionProvider.getValidDataTypeConnection();
        String string2 = this._sourceTableField.getText();
        String string3 = this._targetTableField.getText();
        String string4 = "select * from " + string2;
        if (!this.compareQueryResults(connection, string4, string = "select * from " + string3)) {
            throw new Exception(ValidationArb.getString("TABLE_COMPARE_CHECK_FAILED"));
        }
    }
}

