/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.navigator.nodes;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.unit_test.navigator.nodes.UtDefaultElement;
import oracle.dbtools.unit_test.navigator.nodes.UtDynamicValueQueryElement;
import oracle.dbtools.unit_test.navigator.nodes.UtLibraryEditorNode;
import oracle.dbtools.unit_test.navigator.nodes.UtLookupEditorNode;
import oracle.dbtools.unit_test.navigator.nodes.UtLookupNode;
import oracle.dbtools.unit_test.navigator.nodes.UtNestedSuiteNode;
import oracle.dbtools.unit_test.navigator.nodes.UtStartupElement;
import oracle.dbtools.unit_test.navigator.nodes.UtSuiteEditorNode;
import oracle.dbtools.unit_test.navigator.nodes.UtSuiteNode;
import oracle.dbtools.unit_test.navigator.nodes.UtSuiteTestNode;
import oracle.dbtools.unit_test.navigator.nodes.UtTeardownElement;
import oracle.dbtools.unit_test.navigator.nodes.UtTestEditorNode;
import oracle.dbtools.unit_test.navigator.nodes.UtTestNode;
import oracle.dbtools.unit_test.navigator.nodes.UtValidationElement;
import oracle.ide.model.Attributes;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;

public class UtEditorNode
extends DefaultContainer
implements Observer {
    private static Map<Class<? extends UtDefaultElement>, Class<? extends UtEditorNode>> _utEditorMap = new HashMap<Class<? extends UtDefaultElement>, Class<? extends UtEditorNode>>();
    private UtDefaultElement _element;
    private static int _elementId;
    private Attributes m_attributes = new ElementAttributes();
    public static final int UT_NODE_CHANGED_MESSAGE_ID;
    public static final int UT_NODE_MODIFIED_MESSAGE_ID;

    protected static void register(Class<? extends UtDefaultElement> clazz, Class<? extends UtEditorNode> clazz2) {
        _utEditorMap.put(clazz, clazz2);
    }

    public static UtEditorNode createUtEditorNode(UtDefaultElement utDefaultElement) {
        UtEditorNode utEditorNode = null;
        Class<? extends UtEditorNode> clazz = _utEditorMap.get(((Object)((Object)utDefaultElement)).getClass());
        if (null != clazz) {
            try {
                utEditorNode = clazz.getConstructor(UtDefaultElement.class).newInstance(new Object[]{utDefaultElement});
            }
            catch (Exception exception) {
                String string = "InternalError: cannot create " + clazz.getSimpleName();
                string = string + "\n   " + exception.getLocalizedMessage();
                string = string + "\n   " + exception.getStackTrace()[0].toString();
                Logger.getLogger(UtEditorNode.class.getName()).log(Level.SEVERE, string);
                throw new IllegalArgumentException(string, exception);
            }
        }
        return utEditorNode;
    }

    protected UtEditorNode(UtDefaultElement utDefaultElement, String string) {
        this._element = utDefaultElement;
        this.setURL(this.makeUrl(utDefaultElement, string));
        this.getAttributes().set(ElementAttributes.CLOSEABLE);
    }

    private URL makeUrl(UtDefaultElement utDefaultElement, String string) {
        String string2 = null == utDefaultElement ? String.valueOf(_elementId++) : utDefaultElement.getName();
        URL uRL = URLFactory.newURL((String)string, (String)(((Object)((Object)this)).getClass().getSimpleName() + "/" + string2));
        return uRL;
    }

    public Attributes getAttributes() {
        return this.m_attributes;
    }

    public UtDefaultElement getElement() {
        return this._element;
    }

    public void setViewedObject(UtDefaultElement utDefaultElement) {
        this._element = utDefaultElement;
        if (null != utDefaultElement) {
            this.ensureOpen();
        } else {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.notifyObservers((Object)this, new UpdateMessage(UT_NODE_CHANGED_MESSAGE_ID, (Object)this));
        this.notifyObservers((Object)this, new UpdateMessage(UpdateMessage.OBJECT_RENAMED, (Object)this));
        this.notifyObservers((Object)this, new UpdateMessage(UpdateMessage.OBJECT_RELOADED, (Object)this));
    }

    public void update(Object object, UpdateMessage updateMessage) {
        if (updateMessage.getMessageID() == UpdateMessage.CONTENT_MODIFIED) {
            this.notifyObservers(object, new UpdateMessage(UT_NODE_MODIFIED_MESSAGE_ID, (Object)this));
        }
    }

    public String getLongLabel() {
        return this._element == null ? "" : this._element.getLongLabel();
    }

    public String getShortLabel() {
        return this._element == null ? "" : this._element.getShortLabel();
    }

    public String getToolTipText() {
        return this._element == null ? null : this._element.getToolTipText();
    }

    protected void closeImpl() throws IOException {
        if (this._element != null) {
            this._element.close();
            this._element = null;
        }
    }

    protected void openImpl() throws IOException {
        if (this._element != null) {
            this._element.open();
        }
    }

    static {
        UtEditorNode.register(UtLookupNode.class, UtLookupEditorNode.class);
        UtEditorNode.register(UtSuiteNode.class, UtSuiteEditorNode.class);
        UtEditorNode.register(UtTestNode.class, UtTestEditorNode.class);
        UtEditorNode.register(UtSuiteTestNode.class, UtTestEditorNode.class);
        UtEditorNode.register(UtNestedSuiteNode.class, UtSuiteEditorNode.class);
        UtEditorNode.register(UtStartupElement.class, UtLibraryEditorNode.class);
        UtEditorNode.register(UtTeardownElement.class, UtLibraryEditorNode.class);
        UtEditorNode.register(UtValidationElement.class, UtLibraryEditorNode.class);
        UtEditorNode.register(UtDynamicValueQueryElement.class, UtLibraryEditorNode.class);
        _elementId = 0;
        UT_NODE_CHANGED_MESSAGE_ID = UpdateMessage.newMessageID((String)(UtEditorNode.class.getName() + ".utNodeChanged"));
        UT_NODE_MODIFIED_MESSAGE_ID = UpdateMessage.newMessageID((String)(UtEditorNode.class.getName() + ".utNodeModified"));
    }
}

