/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import oracle.dbtools.raptor.controls.CustomTabbedPane;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dbtools.unit_test.UtAddinArb;
import oracle.dbtools.unit_test.editor.ResultsTreePanel;
import oracle.dbtools.unit_test.editor.SuiteDetails;
import oracle.dbtools.unit_test.editor.UtEditor;
import oracle.dbtools.unit_test.runner.Runner;
import oracle.dbtools.unit_test.testObjects.ObjectUpdateException;
import oracle.dbtools.unit_test.testObjects.UtSuite;
import oracle.dbtools.unit_test.utils.UiUtils;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.view.View;

public class UtSuiteEditor
extends UtEditor {
    private CustomTabbedPane _tabbed = new CustomTabbedPane();
    private SuiteDetails _details;
    private ResultsTreePanel _results;

    @Override
    protected void init() {
        this._details = new SuiteDetails(this){
            private static final long serialVersionUID = 1L;
            private Toolbar _toolbar;

            @Override
            public Toolbar getToolbar() {
                if (null == this._toolbar) {
                    this._toolbar = new Toolbar();
                    this._toolbar.addToggleButton((ToggleAction)UtSuiteEditor.this.getPinToggleAction());
                    this._toolbar.add((ToggleAction)UtSuiteEditor.this.getRefreshAction());
                    this._toolbar.addSeparator();
                    this._toolbar.add((ToggleAction)UtSuiteEditor.this.getRunAction(UtAddinArb.getString("RUN_SUITE")));
                    this._toolbar.addSeparator();
                    this._toolbar.add((ToggleAction)UtSuiteEditor.this.getEditAction());
                    this._toolbar.add((ToggleAction)UtSuiteEditor.this.getCommitAction());
                    this._toolbar.add((ToggleAction)UtSuiteEditor.this.getRollbackAction());
                    UtSuiteEditor.this.addConnectionCombo(this._toolbar);
                    View.updateToolbarActions((Toolbar)this._toolbar);
                    UiUtils.nameButtonsForQA(this._toolbar, "SuiteDetails");
                }
                return this._toolbar;
            }
        };
        this._results = new ResultsTreePanel(){
            private static final long serialVersionUID = 1L;
            private Toolbar _toolbar;

            @Override
            protected Toolbar getToolbar() {
                if (null == this._toolbar) {
                    this._toolbar = new Toolbar();
                    this._toolbar.addToggleButton((ToggleAction)UtSuiteEditor.this.getPinToggleAction());
                    this._toolbar.add((ToggleAction)UtSuiteEditor.this.getRefreshAction());
                    this._toolbar.addSeparator();
                    this._toolbar.add((ToggleAction)UtSuiteEditor.this.getRunAction(UtAddinArb.getString("RUN_SUITE")));
                    UtSuiteEditor.this.addConnectionCombo(this._toolbar);
                    View.updateToolbarActions((Toolbar)this._toolbar);
                    UiUtils.nameButtonsForQA(this._toolbar, "SuiteResults");
                }
                return this._toolbar;
            }
        };
        JPanel jPanel = this.getEditorPanel();
        jPanel.setLayout(new BorderLayout());
        this._tabbed.addTab(null, UtAddinArb.getString("DETAILS"), (Component)this._details);
        this._tabbed.addTab(null, UtAddinArb.getString("RESULTS"), (Component)this._results);
        jPanel.add((Component)this._tabbed, "Center");
    }

    public void editorShown() {
        View.updateToolbarActions((Toolbar)this._details.getToolbar());
        View.updateToolbarActions((Toolbar)this._results.getToolbar());
    }

    @Override
    protected void commit() throws ObjectUpdateException {
        if (null != this._details) {
            this._details.commit();
        }
    }

    @Override
    protected void rollback() {
        if (null != this._details) {
            this._details.rollback();
        }
    }

    @Override
    public void updateContent(boolean bl) {
        UtSuite utSuite = new UtSuite(this.getElementId());
        this._details.updateUI(utSuite);
        this._results.updateUI(utSuite);
    }

    @Override
    protected void run(String string) {
        try {
            Runner runner = new Runner(string);
            UtSuite utSuite = new UtSuite(this.getElementId());
            runner.executeSuite(utSuite, null, true, true);
            int n = this._tabbed.getPanelIndex((Component)this._results);
            this._tabbed.setSelectedIndex(n);
        }
        catch (ConnectionCanceledException connectionCanceledException) {
            // empty catch block
        }
    }

    @Override
    protected void setHaveEditLock(boolean bl) {
        super.setHaveEditLock(bl);
        if (null != this._details) {
            this._details.setEditable(this.haveEditLock());
        }
    }

    @Override
    protected void stopEditing() {
        if (null != this._details) {
            this._details.stopEditing();
        }
        super.stopEditing();
    }
}

