/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import oracle.dbtools.unit_test.UtAddin;
import oracle.dbtools.unit_test.codehook.CodeHookLookup;
import oracle.dbtools.unit_test.editor.ListTablePanel;
import oracle.dbtools.unit_test.editor.ScrollableJPanel;
import oracle.dbtools.unit_test.editor.StartupListTableModel;
import oracle.dbtools.unit_test.editor.SuiteItemListTableModel;
import oracle.dbtools.unit_test.editor.SuiteItemPickerDialog;
import oracle.dbtools.unit_test.editor.TeardownListTableModel;
import oracle.dbtools.unit_test.editor.UiArb;
import oracle.dbtools.unit_test.editor.UtSuiteEditor;
import oracle.dbtools.unit_test.process_validation.IValidation;
import oracle.dbtools.unit_test.startup.IStartup;
import oracle.dbtools.unit_test.startup.StartupArb;
import oracle.dbtools.unit_test.startup.StartupRegistry;
import oracle.dbtools.unit_test.teardown.ITeardown;
import oracle.dbtools.unit_test.teardown.TearDownRegistry;
import oracle.dbtools.unit_test.teardown.TeardownArb;
import oracle.dbtools.unit_test.testObjects.ObjectUpdateException;
import oracle.dbtools.unit_test.testObjects.UtSuite;
import oracle.ide.controls.Toolbar;
import oracle.ide.view.View;

public abstract class SuiteDetails
extends JPanel {
    private static final long serialVersionUID = 1L;
    private UtSuite _suite;
    private boolean _unsavedChanges;
    private UtSuiteEditor _editor;
    private JPanel _panelCenter = new ScrollableJPanel();
    private JScrollPane _scrollPane = new JScrollPane(this._panelCenter);
    private StartupListTableModel _startupListTableModel;
    private ListTablePanel<IStartup> _startupPanel;
    private TeardownListTableModel _teardownListTableModel;
    private ListTablePanel<ITeardown> _teardownPanel;
    private JCheckBox _coverageCheckBox;
    private ListTablePanel<UtSuite.SuiteItem> _itemsTablePanel;
    private SuiteItemListTableModel _itemsTableModel;
    private boolean _initialized;

    public SuiteDetails(UtSuiteEditor utSuiteEditor) {
        this._editor = utSuiteEditor;
    }

    UtSuite getSuite() {
        return this._suite;
    }

    protected abstract Toolbar getToolbar();

    public void updateUI(UtSuite utSuite) {
        this._suite = utSuite;
        this.setInitialized(false);
        this.removeAll();
        this.validate();
        this.repaint();
        this.setLayout(new BorderLayout());
        Toolbar toolbar = this.getToolbar();
        if (null != toolbar) {
            this.add((Component)toolbar, "North");
        }
        this._panelCenter.removeAll();
        CodeHookLookup codeHookLookup = new CodeHookLookup(){

            @Override
            public String getOwnerName() {
                return SuiteDetails.this._suite.getSuiteName();
            }

            @Override
            public List<IValidation> getValidations() {
                return null;
            }

            @Override
            public List<IStartup> getStartups() {
                return null;
            }

            @Override
            public List<ITeardown> getTeardowns() {
                return null;
            }
        };
        this._startupListTableModel = new StartupListTableModel(codeHookLookup){
            private static final long serialVersionUID = 1L;

            @Override
            protected List<IStartup> add() {
                String string = StartupArb.getString("NONE");
                IStartup iStartup = StartupRegistry.getInstanceFor(string);
                iStartup.loadFromXml(null);
                ArrayList<IStartup> arrayList = new ArrayList<IStartup>();
                arrayList.add(iStartup);
                return arrayList;
            }
        };
        this._startupListTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                SuiteDetails.this.markDirty(true);
            }
        });
        this._startupListTableModel.setRowList(utSuite.getStartupCodeHooks());
        this._startupPanel = new ListTablePanel<IStartup>(this._startupListTableModel);
        this._startupPanel.setName("startupPanel");
        this._teardownListTableModel = new TeardownListTableModel(codeHookLookup){
            private static final long serialVersionUID = 1L;

            @Override
            protected List<ITeardown> add() {
                String string = TeardownArb.getString("NONE");
                ITeardown iTeardown = TearDownRegistry.getInstanceFor(string);
                iTeardown.loadFromXml(null);
                ArrayList<ITeardown> arrayList = new ArrayList<ITeardown>();
                arrayList.add(iTeardown);
                return arrayList;
            }
        };
        this._teardownListTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                SuiteDetails.this.markDirty(true);
            }
        });
        this._teardownListTableModel.setRowList(utSuite.getTeardownCodeHooks());
        this._teardownPanel = new ListTablePanel<ITeardown>(this._teardownListTableModel);
        this._teardownPanel.setName("teardownPanel");
        this._coverageCheckBox = new JCheckBox(UiArb.getString("CODE_COVERAGE_LABEL"), this._suite.getCoverage());
        this._coverageCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SuiteDetails.this.markDirty(true);
            }
        });
        List<UtSuite.SuiteItem> list = utSuite.getItems();
        this._itemsTableModel = new SuiteItemListTableModel(){

            @Override
            protected List<UtSuite.SuiteItem> add() {
                SuiteItemPickerDialog suiteItemPickerDialog = new SuiteItemPickerDialog();
                suiteItemPickerDialog.runDialog(SuiteDetails.this._suite.getSid(), SuiteItemPickerDialog.Tabs.BOTH);
                return suiteItemPickerDialog.getSuiteItems();
            }
        };
        this._itemsTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                SuiteDetails.this.markDirty(true);
            }
        });
        this._itemsTableModel.setRowList(list);
        this._itemsTablePanel = new ListTablePanel<UtSuite.SuiteItem>(this._itemsTableModel);
        int n = UtAddin.testNodeIcon.getIconWidth();
        int n2 = UtAddin.suiteNodeIcon.getIconWidth();
        int n3 = 4 + (n > n2 ? n : n2);
        this._itemsTablePanel.getTable().getColumnModel().getColumn(0).setMaxWidth(n3);
        this.setColumnWidth(2, UiArb.getString("SUITE_DO_STARTUP_LBL"));
        this.setColumnWidth(3, UiArb.getString("SUITE_DO_TEARDOWN_LBL"));
        this.setColumnWidth(4, UiArb.getString("SUITE_NUM_IMPLS_LBL"));
        this._itemsTablePanel.setBorder(new LineBorder(Color.LIGHT_GRAY));
        GroupLayout groupLayout = new GroupLayout(this._panelCenter);
        this._panelCenter.setLayout(groupLayout);
        groupLayout.setAutoCreateGaps(true);
        groupLayout.setAutoCreateContainerGaps(true);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup().addGroup(groupLayout.createSequentialGroup().addComponent(this._startupPanel)).addGroup(groupLayout.createSequentialGroup().addComponent(this._teardownPanel)).addComponent(this._coverageCheckBox).addComponent(this._itemsTablePanel));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup().addComponent(this._startupPanel)).addGroup(groupLayout.createParallelGroup().addComponent(this._teardownPanel)).addComponent(this._coverageCheckBox).addComponent(this._itemsTablePanel));
        this.add((Component)this._scrollPane, "Center");
        this.invalidate();
        this.validate();
        this.setInitialized(true);
        this.toggleButtons();
    }

    private void setColumnWidth(int n, String string) {
        JLabel jLabel = new JLabel(string);
        double d = jLabel.getPreferredSize().width;
        this._itemsTablePanel.getTable().getColumnModel().getColumn(n).setMaxWidth((int)d + 30);
        this._itemsTablePanel.getTable().getColumnModel().getColumn(n).setMinWidth((int)d + 5);
    }

    private void toggleButtons() {
        View.updateToolbarActions((Toolbar)this.getToolbar());
        this.setEditable(this._editor.isEditable());
    }

    void setEditable(boolean bl) {
        if (null != this._startupPanel) {
            this._itemsTablePanel.setEditable(bl);
            this._startupPanel.setEditable(bl);
            this._teardownPanel.setEditable(bl);
            this._coverageCheckBox.setEnabled(bl);
        }
    }

    void stopEditing() {
        this._itemsTablePanel.stopEditing();
    }

    void commit() throws ObjectUpdateException {
        this.stopEditing();
        this.saveImpl();
    }

    private void saveImpl() throws ObjectUpdateException {
        if (this._unsavedChanges) {
            this._suite.setStartupCodeHooks(this._startupListTableModel.getRowList());
            this._suite.setTeardownCodeHooks(this._teardownListTableModel.getRowList());
            this._suite.setCoverage(this._coverageCheckBox.isSelected());
            this._suite.setItems(this._itemsTableModel.getRowList());
            this._suite.save(true);
            this._unsavedChanges = false;
            this.toggleButtons();
        }
    }

    void rollback() {
        this.revertImpl();
    }

    private void revertImpl() {
        if (this._unsavedChanges) {
            this._unsavedChanges = false;
            String string = this._suite.getSid();
            this._suite = new UtSuite(string);
            this.updateUI(this._suite);
        }
    }

    private boolean isInitialized() {
        return this._initialized;
    }

    private void setInitialized(boolean bl) {
        this._initialized = bl;
    }

    private void markDirty(boolean bl) {
        if (this.isInitialized()) {
            this._editor.markDirty(bl);
            this._unsavedChanges = bl;
            this.toggleButtons();
        }
    }
}

