/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.editor;

import java.awt.Color;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.unit_test.runner.UtRunnerArb;

public class ResultsTreeNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 1L;
    private String name;
    private String status;
    private String message;
    private Double duration;
    private boolean root;
    private String trid;
    private String srid;
    public Color color = new Color(0);

    public ResultsTreeNode(String string, String string2, String string3, boolean bl) {
        this(string, string2, string3, null, bl);
    }

    public ResultsTreeNode(String string, String string2, String string3) {
        this(string, string2, string3, null, false);
    }

    public ResultsTreeNode(String string, String string2, String string3, Double d) {
        this(string, string2, string3, d, false);
    }

    public ResultsTreeNode(String string, String string2, String string3, Double d, boolean bl) {
        this.name = string;
        this.status = string2;
        this.message = string3;
        this.duration = d;
        this.root = bl;
    }

    public String getTestResultId() {
        return this.trid;
    }

    public void setTestResultId(String string) {
        this.trid = string;
    }

    public String getSuiteResultId() {
        return this.srid;
    }

    public void setSuiteResultId(String string) {
        this.srid = string;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getStatus() {
        return this.status;
    }

    public String getStatusDisplayValue() {
        if (null == this.status) {
            return "";
        }
        if (this.status.startsWith("UT_")) {
            return UtRunnerArb.getString(this.status);
        }
        return "";
    }

    public void setStatus(String string) {
        this.status = string;
    }

    public Double getDuration() {
        return this.duration;
    }

    public Double getRolledUpDuration() {
        if (this.root) {
            return null;
        }
        int n = this.getChildCount();
        if (this.duration == null && n == 0) {
            return null;
        }
        Double d = 0.0;
        if (this.duration != null) {
            d = d + this.duration;
        }
        for (int i = 0; i < n; ++i) {
            ResultsTreeNode resultsTreeNode = (ResultsTreeNode)this.getChildAt(i);
            Double d2 = resultsTreeNode.getRolledUpDuration();
            if (d2 == null) continue;
            d = d + d2;
        }
        return d;
    }

    public void setDuration(Double d) {
        this.duration = d;
    }

    public String tooltip() {
        return this.message;
    }

    @Override
    public String toString() {
        return this.name;
    }
}

