/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.raptor.navigator.core.NavigatorWindow;
import oracle.dbtools.raptor.navigator.model.NavigatorTree;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.unit_test.UtAddin;
import oracle.dbtools.unit_test.codehook.CodeHookDefaults;
import oracle.dbtools.unit_test.codehook.CodeHookLookup;
import oracle.dbtools.unit_test.codehook.ICodeHook;
import oracle.dbtools.unit_test.editor.UiArb;
import oracle.dbtools.unit_test.navigator.nodes.RootFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtDynamicValueQueriesFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtLibraryFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtStartupsFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtTeardownsFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtValidationsFolder;
import oracle.dbtools.unit_test.testObjects.ObjectUpdateException;
import oracle.dbtools.unit_test.testObjects.UtLibraryItem;
import oracle.dbtools.unit_test.testObjects.UtLibraryRef;
import oracle.dbtools.unit_test.utils.UiUtils;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.dialogs.MessageDialog;

public class CodeHookEditor {
    private ICodeHook _codeHook;
    private CodeHookLookup _lookup;
    private JComboBox _subscribeNameCombo = new JComboBox();
    private JButton _copyButton = new JButton();
    private JCheckBox _subscribeCheck = new JCheckBox();
    private JButton _resetButton = new JButton();
    private JTextField _publishField = new JTextField("", 24);
    private JButton _publishButton = new JButton();
    private TreeMap<String, NameComboEntry> _subscribeMap = new TreeMap();
    private boolean _initialSubscribeChecked;
    private NameComboEntry _initialSubscribeEntry;
    private NameComboEntry _nullEntry = new NameComboEntry();

    public CodeHookEditor(ICodeHook iCodeHook, CodeHookLookup codeHookLookup) {
        this._codeHook = iCodeHook;
        this._lookup = codeHookLookup;
    }

    public boolean runDialog() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder(UiArb.getString("LIBRARY_PANEL_LABEL")));
        this._subscribeNameCombo.setPreferredSize(new Dimension(200, 20));
        UiUtils.nameForQA(this._subscribeNameCombo, "SubscribeName", new String[0]);
        NameComboEntry nameComboEntry = this.loadLibraryRefs();
        if (nameComboEntry == null) {
            this._initialSubscribeEntry = this._nullEntry;
            this._initialSubscribeChecked = false;
        } else {
            this._initialSubscribeEntry = nameComboEntry;
            this._initialSubscribeChecked = true;
        }
        this._subscribeNameCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CodeHookEditor.this.stateChanged();
            }
        });
        this._subscribeNameCombo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                CodeHookEditor.this.stateChanged();
            }
        });
        this._copyButton.setText(UiArb.getString("COPY_BUTTON_LABEL"));
        this._copyButton.setHorizontalTextPosition(0);
        this._copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NameComboEntry nameComboEntry = (NameComboEntry)CodeHookEditor.this._subscribeNameCombo.getSelectedItem();
                UtLibraryItem utLibraryItem = new UtLibraryItem(CodeHookEditor.this._codeHook.getClass().getName(), nameComboEntry.getLibRef().getLibId());
                CodeHookEditor.this._codeHook.loadFromXml(utLibraryItem.getXml());
            }
        });
        this._subscribeCheck.setText(UiArb.getString("SUBSCRIBE_CHECK_LABEL"));
        this._subscribeCheck.setBorderPainted(true);
        this._subscribeCheck.setBorderPaintedFlat(true);
        this._subscribeCheck.setSelected(this._initialSubscribeChecked);
        this._subscribeCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CodeHookEditor.this._subscribeCheck.isSelected()) {
                    NameComboEntry nameComboEntry = (NameComboEntry)CodeHookEditor.this._subscribeNameCombo.getSelectedItem();
                    UtLibraryRef utLibraryRef = nameComboEntry.getLibRef();
                    CodeHookEditor.this._codeHook.setLibraryRef(utLibraryRef);
                    UtLibraryItem utLibraryItem = new UtLibraryItem(CodeHookEditor.this._codeHook.getClass().getName(), utLibraryRef.getLibId());
                    CodeHookEditor.this._codeHook.loadFromXml(utLibraryItem.getXml());
                } else {
                    CodeHookEditor.this._codeHook.setLibraryRef(null);
                    CodeHookEditor.this._codeHook.loadFromXml(CodeHookEditor.this._codeHook.getXml());
                }
                CodeHookEditor.this.stateChanged();
            }
        });
        this._resetButton.setText(UiArb.getString("RESET_BUTTON_LABEL"));
        this._resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CodeHookEditor.this._subscribeCheck.setSelected(CodeHookEditor.this._initialSubscribeChecked);
                CodeHookEditor.this._subscribeNameCombo.setSelectedItem(CodeHookEditor.this._initialSubscribeEntry);
            }
        });
        jPanel2.add((Component)this._subscribeNameCombo, null);
        jPanel2.add((Component)this._subscribeCheck, null);
        jPanel2.add((Component)this._copyButton, null);
        jPanel2.add((Component)this._resetButton, null);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createTitledBorder(UiArb.getString("PUBLISH_PANEL_LABEL")));
        this._publishField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CodeHookEditor.this.stateChanged();
            }
        });
        this._publishField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                CodeHookEditor.this.stateChanged();
            }
        });
        this._publishButton.setText(UiArb.getString("PUBLISH_BUTTON_LABEL"));
        this._publishButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = CodeHookEditor.this._publishField.getText();
                UtLibraryRef utLibraryRef = new UtLibraryRef(null, string);
                UtLibraryItem utLibraryItem = new UtLibraryItem(utLibraryRef, CodeHookEditor.this._codeHook.getClass().getName(), CodeHookEditor.this._codeHook.getXml());
                try {
                    boolean bl = utLibraryItem.save();
                    if (bl) {
                        CodeHookEditor.this.refreshNavigator(utLibraryItem.getKind(), CodeHookEditor.this._codeHook.getHookName());
                        CodeHookEditor.this._codeHook.setLibraryRef(utLibraryRef);
                        CodeHookEditor.this._subscribeCheck.setSelected(true);
                        CodeHookEditor.this._publishField.setText("");
                    } else {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)UiArb.getString("DUPLICATE_LIB_NAME"), (String)UiArb.getString("DUPLICATE_LIB_NAME_TITLE"), null);
                    }
                }
                catch (ObjectUpdateException objectUpdateException) {
                    // empty catch block
                }
                CodeHookEditor.this.loadLibraryRefs();
                CodeHookEditor.this.stateChanged();
            }
        });
        jPanel3.add((Component)this._publishField, null);
        jPanel3.add((Component)this._publishButton, null);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.setBorder(BorderFactory.createTitledBorder(this._codeHook.getHookName()));
        CodeHookDefaults codeHookDefaults = this._lookup != null ? new CodeHookDefaults(this._lookup) : new CodeHookDefaults();
        jPanel4.add(this._codeHook.getComponent(codeHookDefaults), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jPanel4, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jPanel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 16, 1, new Insets(0, 0, 0, 0), 0, 0));
        boolean bl = OnePageWizardDialogFactory.runDialog((Component)jPanel, (Component)this._codeHook.getComponent(codeHookDefaults), (String)this._codeHook.getTitle(), (int)3);
        return bl;
    }

    private NameComboEntry loadLibraryRefs() {
        UtLibraryRef utLibraryRef = this._codeHook.getLibraryRef();
        NameComboEntry nameComboEntry = null;
        UtLibraryRef[] utLibraryRefArray = this._codeHook.getCandidateLibraryRefs();
        this._subscribeMap.clear();
        for (UtLibraryRef utLibraryRef2 : utLibraryRefArray) {
            NameComboEntry nameComboEntry2 = new NameComboEntry(utLibraryRef2);
            if (utLibraryRef != null && utLibraryRef2.getLibId().equals(utLibraryRef.getLibId())) {
                nameComboEntry = nameComboEntry2;
            }
            this._subscribeMap.put(utLibraryRef2.getName(), nameComboEntry2);
        }
        this._subscribeNameCombo.removeAllItems();
        this._subscribeNameCombo.addItem(this._nullEntry);
        for (String string : this._subscribeMap.keySet()) {
            this._subscribeNameCombo.addItem(this._subscribeMap.get(string));
        }
        this._subscribeNameCombo.setSelectedItem(nameComboEntry);
        return nameComboEntry;
    }

    private void stateChanged() {
        NameComboEntry nameComboEntry = (NameComboEntry)this._subscribeNameCombo.getSelectedItem();
        if (nameComboEntry == null) {
            nameComboEntry = this._nullEntry;
        }
        String string = nameComboEntry.toString();
        boolean bl = this._subscribeCheck.isSelected();
        if (bl) {
            this._subscribeNameCombo.setEnabled(false);
            this._subscribeCheck.setEnabled(true);
            this._copyButton.setEnabled(true);
            this._publishButton.setEnabled(false);
            this._publishField.setEnabled(false);
        } else {
            if (string.equals("")) {
                this._subscribeNameCombo.setEnabled(true);
                this._subscribeCheck.setEnabled(false);
                this._copyButton.setEnabled(false);
            } else if (this._subscribeMap.containsKey(string)) {
                this._subscribeNameCombo.setEnabled(true);
                this._subscribeCheck.setEnabled(true);
                this._copyButton.setEnabled(true);
            } else {
                this._subscribeNameCombo.setEnabled(true);
                this._subscribeCheck.setEnabled(false);
                this._copyButton.setEnabled(false);
            }
            this._publishField.setEnabled(true);
            String string2 = this._publishField.getText();
            if (!string2.equals("") && !this._subscribeMap.containsKey(string2)) {
                this._publishButton.setEnabled(true);
            } else {
                this._publishButton.setEnabled(false);
            }
        }
        if (bl == this._initialSubscribeChecked && nameComboEntry.equals(this._initialSubscribeEntry)) {
            this._resetButton.setEnabled(false);
        } else {
            this._resetButton.setEnabled(true);
        }
    }

    private void refreshNavigator(UtLibraryItem.Kind kind, String string) {
        RootFolder rootFolder = RootFolder.getInstance();
        NavigatorWindow navigatorWindow = UtAddin.getNavigatorManager().getNavigatorWindow();
        NavigatorTree navigatorTree = navigatorWindow.getTree();
        NavigatorTreeNode navigatorTreeNode = navigatorTree.findTreeNode((Element)rootFolder, navigatorTree.getRoot());
        Enumeration enumeration = navigatorTreeNode.children();
        while (enumeration.hasMoreElements()) {
            UtLibraryFolder utLibraryFolder;
            NavigatorTreeNode navigatorTreeNode2 = (NavigatorTreeNode)enumeration.nextElement();
            if (!(navigatorTreeNode2.getElement() instanceof UtLibraryFolder) || !(utLibraryFolder = (UtLibraryFolder)navigatorTreeNode2.getElement()).isOpen()) continue;
            this.refreshFolder(kind, string, navigatorTreeNode2);
        }
    }

    private void refreshFolder(UtLibraryItem.Kind kind, String string, NavigatorTreeNode navigatorTreeNode) {
        Node node;
        if (navigatorTreeNode.getElement() instanceof Node && (node = (Node)navigatorTreeNode.getElement()).isOpen()) {
            if (node instanceof UtDynamicValueQueriesFolder || node instanceof UtStartupsFolder || node instanceof UtTeardownsFolder || node instanceof UtValidationsFolder) {
                if (string.equals(node.getShortLabel())) {
                    switch (kind) {
                        case STARTUP: {
                            if (!(node instanceof UtStartupsFolder)) break;
                            UpdateMessage.fireStructureChanged((Subject)node);
                            break;
                        }
                        case TEARDOWN: {
                            if (!(node instanceof UtTeardownsFolder)) break;
                            UpdateMessage.fireStructureChanged((Subject)node);
                            break;
                        }
                        case VALIDATION: {
                            if (!(node instanceof UtValidationsFolder)) break;
                            UpdateMessage.fireStructureChanged((Subject)node);
                            break;
                        }
                        case DYNAMIC_VALUE_QUERY: {
                            if (!(node instanceof UtDynamicValueQueriesFolder)) break;
                            UpdateMessage.fireStructureChanged((Subject)node);
                        }
                    }
                }
            } else {
                Enumeration enumeration = navigatorTreeNode.children();
                while (enumeration.hasMoreElements()) {
                    NavigatorTreeNode navigatorTreeNode2 = (NavigatorTreeNode)enumeration.nextElement();
                    this.refreshFolder(kind, string, navigatorTreeNode2);
                }
            }
        }
    }

    private static class NameComboEntry {
        private UtLibraryRef _libRef;

        NameComboEntry() {
            this._libRef = null;
        }

        NameComboEntry(UtLibraryRef utLibraryRef) {
            this._libRef = utLibraryRef;
        }

        String getLibId() {
            return this._libRef != null ? this._libRef.getLibId() : null;
        }

        UtLibraryRef getLibRef() {
            return this._libRef;
        }

        public String toString() {
            return this._libRef != null ? this._libRef.getName() : "";
        }
    }
}

