/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.create_wizard;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.unit_test.codehook.CodeHookLookup;
import oracle.dbtools.unit_test.codehook.ICodeHook;
import oracle.dbtools.unit_test.create_wizard.CreateWizArb;
import oracle.dbtools.unit_test.manage_objects.PLSQLOperation;
import oracle.dbtools.unit_test.process_validation.IValidation;
import oracle.dbtools.unit_test.startup.IStartup;
import oracle.dbtools.unit_test.teardown.ITeardown;
import oracle.dbtools.unit_test.testObjects.ObjectUpdateException;
import oracle.dbtools.unit_test.testObjects.UtTest;
import oracle.dbtools.unit_test.testObjects.UtTestImpl;
import oracle.dbtools.unit_test.utils.UtUtils;

public class CreateWizContext {
    private boolean _committed = false;
    private String _connName;
    private UtTest _test;
    private PLSQLOperation _plsOp;
    private Boolean _useSeeding;
    private CodeHookLookup _codeHookLookup = new CodeHookLookup(){

        @Override
        public String getOwnerName() {
            return CreateWizContext.this._test.getTestName();
        }

        @Override
        public List<IValidation> getValidations() {
            return CreateWizContext.this._validationHooks;
        }

        @Override
        public List<IStartup> getStartups() {
            return CreateWizContext.this._startupHooks;
        }

        @Override
        public List<ITeardown> getTeardowns() {
            return CreateWizContext.this._teardownHooks;
        }
    };
    private List<IStartup> _startupHooks;
    private List<ITeardown> _teardownHooks;
    private List<IValidation> _validationHooks;
    private static String _lastUsedConnName;
    private static final String _paraSep = "-----------------------------------------------------------------\n";

    public void setConnectionName(String string) {
        this._connName = string;
    }

    public boolean setTestOperation(Component component, PLSQLOperation pLSQLOperation) {
        if (pLSQLOperation != this._plsOp) {
            if (pLSQLOperation == null) {
                this._test = null;
            } else {
                String string = pLSQLOperation.isFunction() ? "FUNCTION" : "PROCEDURE";
                String string2 = null;
                String string3 = null;
                String string4 = pLSQLOperation.getPackage();
                if (string4 != null) {
                    string2 = string4;
                    string3 = pLSQLOperation.getOperation();
                } else {
                    string2 = pLSQLOperation.getOperation();
                }
                UtTest utTest = new UtTest(null, string2, string3, string, pLSQLOperation.getSchema(), pLSQLOperation.getOverload(), this._connName);
                utTest.setTestName(null);
                if (!UtUtils.checkForUnsupportedParamTypes(component, this._connName, utTest)) {
                    return false;
                }
                this._test = utTest;
            }
            this._plsOp = pLSQLOperation;
            this._useSeeding = null;
        }
        return true;
    }

    public void setUseSeeding(boolean bl) {
        if (this._useSeeding == null || bl != this._useSeeding) {
            this._test.removeAllImpls();
            if (bl) {
                this._test.createSeedImpls();
            } else {
                this._test.createTestImpl(null, null, null);
            }
            this._useSeeding = bl;
        }
    }

    public String getConnectionName() {
        return this._connName;
    }

    public String getDisplayConnectionName() {
        return (String)Connections.getInstance().getConnectionInfo(this._connName).get("ConnName");
    }

    public String getLastUsedConnectionName() {
        return _lastUsedConnName;
    }

    public UtTest getTest() {
        return this._test;
    }

    public UtTestImpl getTestImpl() {
        ArrayList<UtTestImpl> arrayList = this._test.getImpls();
        return arrayList.size() == 1 ? arrayList.get(0) : null;
    }

    public boolean getUseSeeding() {
        return this._useSeeding != null ? this._useSeeding : false;
    }

    public CodeHookLookup getCodeHookLookup() {
        return this._codeHookLookup;
    }

    public void setStartupHooks(List<IStartup> list) {
        this._startupHooks = list;
    }

    public void setTeardownHooks(List<ITeardown> list) {
        this._teardownHooks = list;
    }

    public void setValidationHooks(List<IValidation> list) {
        this._validationHooks = list;
    }

    public String getSummary() {
        Iterator<ITeardown> iterator;
        List<ITeardown> list;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(CreateWizArb.getString("CREATE_TEST_SUMMARY_NOTICE"));
        stringBuffer.append('\n');
        stringBuffer.append(_paraSep);
        stringBuffer.append(CreateWizArb.getString("CONNECTION_NOTICE"));
        stringBuffer.append(": ");
        stringBuffer.append(this.getDisplayConnectionName());
        stringBuffer.append('\n');
        stringBuffer.append(CreateWizArb.getString("OPERATION_NOTICE"));
        stringBuffer.append(": ");
        stringBuffer.append(this._plsOp.getQualifiedSignature());
        stringBuffer.append('\n');
        stringBuffer.append(_paraSep);
        stringBuffer.append(CreateWizArb.getString("TEST_NAME_NOTICE"));
        stringBuffer.append(": ");
        stringBuffer.append(this._test.getTestName());
        stringBuffer.append('\n');
        stringBuffer.append(CreateWizArb.getString("OPTION_NOTICE"));
        stringBuffer.append(": ");
        if (this.getUseSeeding()) {
            stringBuffer.append(CreateWizArb.getString("SEED_BUTTON_LABEL"));
        } else {
            stringBuffer.append(CreateWizArb.getString("NO_SEED_BUTTON_LABEL"));
        }
        stringBuffer.append('\n');
        stringBuffer.append(_paraSep);
        List<IStartup> list2 = this._test.getStartupCodeHooks();
        if (list2 != null && list2.size() > 0) {
            list = list2.iterator();
            while (list.hasNext()) {
                iterator = (IStartup)list.next();
                this.appendCodeHookSummary(stringBuffer, (ICodeHook)((Object)iterator));
                stringBuffer.append('\n');
            }
            stringBuffer.append(_paraSep);
        }
        if (!this.getUseSeeding()) {
            list = this.getTestImpl();
            iterator = ((UtTestImpl)((Object)list)).getExpectedStatus();
            stringBuffer.append(CreateWizArb.getString("EXPECTED_STATUS_NOTICE"));
            stringBuffer.append(": ");
            stringBuffer.append((String)(iterator != null ? iterator : "SUCCESS"));
            stringBuffer.append('\n');
            stringBuffer.append(_paraSep);
            List<IValidation> object = ((UtTestImpl)((Object)list)).getValidationCodeHooks();
            if (object != null && object.size() > 0) {
                for (IValidation iValidation : object) {
                    this.appendCodeHookSummary(stringBuffer, iValidation);
                    stringBuffer.append('\n');
                }
                stringBuffer.append(_paraSep);
            }
        }
        if ((list = this._test.getTeardownCodeHooks()) != null && list.size() > 0) {
            for (ITeardown iTeardown : list) {
                this.appendCodeHookSummary(stringBuffer, iTeardown);
                stringBuffer.append('\n');
            }
            stringBuffer.append(_paraSep);
        }
        return stringBuffer.toString();
    }

    private void appendCodeHookSummary(StringBuffer stringBuffer, ICodeHook iCodeHook) {
        stringBuffer.append(iCodeHook.getTitle());
        stringBuffer.append(": ");
        stringBuffer.append(iCodeHook.getHookName());
    }

    public boolean canCommit() {
        return this._connName != null && this._test != null && this._test.getTestName() != null;
    }

    public void commit() {
        if (!this._committed) {
            try {
                this._test.save(true);
                this._committed = true;
                _lastUsedConnName = this._connName;
            }
            catch (ObjectUpdateException objectUpdateException) {
                // empty catch block
            }
        }
    }
}

