/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui.quickmigrate;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTextPane;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.Messages;
import oracle.dbtools.raptor.connections.ConnectionComboRenderer;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBException;
import oracle.jdeveloper.db.DatabaseConnectionEditor;

public class TargetSelector
extends DefaultTraversablePanel {
    private static final long serialVersionUID = -6259962152810412057L;
    private JTextPane m_txtTargetDesc = new JTextPane();
    private JComboBox m_cmbTargetConnection = new JComboBox();
    private JButton m_btnAddTarget = new JButton();
    private String m_targetConnectionName = Messages.getString("TargetSelector.0");
    private boolean runTest = true;
    private static final String HTMLCONTENT = "text/html";
    TraversableContext m_dataContext;

    public TargetSelector() {
        this.setLayout(new GridBagLayout());
        Font font = this.m_btnAddTarget.getFont();
        String string = MigrationUtils.fontToCSSString(font);
        this.m_txtTargetDesc.setContentType(HTMLCONTENT);
        this.m_txtTargetDesc.setText(MigrationAddinArb.format("QUICKMIGRATE_TARGET_DESC", string));
        this.m_txtTargetDesc.setEditable(false);
        this.m_txtTargetDesc.setOpaque(false);
        this.m_txtTargetDesc.setRequestFocusEnabled(false);
        this.m_txtTargetDesc.setFocusable(false);
        this.add(this.m_txtTargetDesc, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        Dimension dimension = new Dimension(72, 22);
        this.m_btnAddTarget.setMinimumSize(dimension);
        this.m_btnAddTarget.setMaximumSize(dimension);
        this.m_btnAddTarget.setPreferredSize(dimension);
        this.m_btnAddTarget.setText(MigrationAddinArb.getString("QUICKMIGRATE_BUTTON_ADD_TARGET"));
        this.m_btnAddTarget.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TargetSelector.this.newSourceOrTarget();
            }
        });
        this.m_btnAddTarget.setMnemonic(StringUtils.getMnemonicKeyCode((String)"MNEM_QUICKMIGRATE_BUTTON_ADD_TARGET"));
        this.m_cmbTargetConnection.setRenderer(new ConnectionComboRenderer());
        this.add(this.m_cmbTargetConnection, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.m_btnAddTarget, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void newSourceOrTarget() {
        DatabaseConnectionEditor.editConnection((String)"IdeConnections", null);
        this.populatecConnectionCombos(true);
    }

    public void setTargetConnection(String string) {
        int n = this.m_cmbTargetConnection.getItemCount();
        String string2 = null;
        for (int i = 0; i < n; ++i) {
            string2 = (String)this.m_cmbTargetConnection.getItemAt(i);
            if (!string2.equals(string)) continue;
            this.m_cmbTargetConnection.setSelectedIndex(i);
            break;
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        this.m_dataContext = traversableContext;
        this.m_dataContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
        if (traversableContext.get(Messages.getString("TargetSelector.2")) != null) {
            this.runTest = (Boolean)traversableContext.get(Messages.getString("TargetSelector.3"));
        }
        this.populatecConnectionCombos(false);
        this.m_cmbTargetConnection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Connections connections = Connections.getInstance();
                Connection connection = null;
                try {
                    connection = connections.getConnection((String)TargetSelector.this.m_cmbTargetConnection.getSelectedItem());
                }
                catch (DBException dBException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
                }
                if (connection != null) {
                    TargetSelector.this.m_dataContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
                    TargetSelector.this.m_targetConnectionName = (String)TargetSelector.this.m_cmbTargetConnection.getItemAt(0);
                } else {
                    TargetSelector.this.m_dataContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
                }
            }
        });
        this.m_targetConnectionName = (String)traversableContext.get(Messages.getString("TargetSelector.4"));
        if (this.m_targetConnectionName != null) {
            this.setTargetConnection(this.m_targetConnectionName);
        } else if (this.m_cmbTargetConnection.getSelectedObjects().length > 0) {
            this.m_cmbTargetConnection.setSelectedIndex(0);
            this.m_targetConnectionName = (String)this.m_cmbTargetConnection.getItemAt(0);
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        traversableContext.put(Messages.getString("TargetSelector.5"), (Object)this.runTest);
        String string = (String)this.m_cmbTargetConnection.getSelectedItem();
        traversableContext.put(Messages.getString("TargetSelector.6"), (Object)string);
        try {
            traversableContext.put(Messages.getString("TargetSelector.7"), (Object)Connections.getInstance().getConnection(string));
        }
        catch (DBException dBException) {
            // empty catch block
        }
    }

    private void populatecConnectionCombos(boolean bl) {
        String[] stringArray;
        Object var2_2 = null;
        String string = null;
        if (bl) {
            string = (String)this.m_cmbTargetConnection.getSelectedItem();
        }
        this.m_cmbTargetConnection.removeAllItems();
        Connections connections = Connections.getInstance();
        for (String string2 : stringArray = connections.getConnNames()) {
            if (!connections.isOracle(string2)) continue;
            this.m_cmbTargetConnection.addItem(string2);
        }
        if (bl && string != null) {
            this.m_cmbTargetConnection.setSelectedItem(string);
        }
        this.targetConnectionSelectionChange();
    }

    private void targetConnectionSelectionChange() {
        String string = (String)this.m_cmbTargetConnection.getSelectedItem();
        if (TargetSelector.stringsDiffer(string, this.m_targetConnectionName)) {
            this.runTest = false;
            this.m_targetConnectionName = string;
        }
    }

    private static boolean stringsDiffer(String string, String string2) {
        if (string == null) {
            return string2 != null;
        }
        if (string2 == null) {
            return true;
        }
        return !string.equals(string2);
    }
}

