/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;
import oracle.dbtools.migration.workbench.core.ui.AbstractUpdatableTableModel;

public class SimpleTablePanel
extends JPanel {
    private JTable m_table;

    public SimpleTablePanel(int n, String string, AbstractUpdatableTableModel abstractUpdatableTableModel) {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(n, 125));
        JScrollPane jScrollPane = new JScrollPane();
        this.add((Component)jScrollPane, "Center");
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        this.m_table = new JTable(){

            @Override
            public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
                Object object = this.getValueAt(n, n2);
                TableCellEditor tableCellEditor2 = this.getDefaultEditor(object.getClass());
                Component component = tableCellEditor2.getTableCellEditorComponent(this, object, this.isCellSelected(n, n2), n, n2);
                if (component instanceof JTextComponent) {
                    ((JTextComponent)component).setEditable(false);
                }
                return component;
            }

            @Override
            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (component instanceof JComponent) {
                    JComponent jComponent = (JComponent)component;
                    if (this.getValueAt(n, n2) instanceof Integer) {
                        jComponent.setToolTipText("<html>" + ((Integer)this.getValueAt(n, n2)).toString().replaceAll("\n", "<br>") + "</html>");
                    } else if (this.getValueAt(n, n2) != null) {
                        jComponent.setToolTipText("<html>" + ((String)this.getValueAt(n, n2)).replaceAll("\n", "<br>") + "</html>");
                    }
                }
                return component;
            }
        };
        TableCellRenderer tableCellRenderer = this.m_table.getTableHeader().getDefaultRenderer();
        if (tableCellRenderer instanceof JLabel) {
            ((JLabel)((Object)tableCellRenderer)).setHorizontalAlignment(10);
        }
        abstractUpdatableTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
            }
        });
        this.setToolTipText(string);
        jScrollPane.setViewportView(this.m_table);
        this.m_table.setModel(abstractUpdatableTableModel);
    }

    public void updateProgress(final Object object) {
        if (object != null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        AbstractUpdatableTableModel abstractUpdatableTableModel = (AbstractUpdatableTableModel)SimpleTablePanel.this.m_table.getModel();
                        abstractUpdatableTableModel.update(object);
                        SimpleTablePanel.this.m_table.scrollRectToVisible(SimpleTablePanel.this.m_table.getCellRect(abstractUpdatableTableModel.getRowCount() - 1, 0, true));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
    }
}

