/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.ui.FullMigrationTopPanel;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskStatus;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.internal.IRaptorTaskUIListener;
import oracle.dbtools.raptor.backgroundTask.ui.IModalTaskUI;
import oracle.dbtools.raptor.backgroundTask.ui.ITaskUI;

public class FullMigrateTaskUI
implements IModalTaskUI {
    private static final Dimension PANEL_DIMENSION = new Dimension(430, 400);
    private JPanel _taskUI = new JPanel();
    protected JLabel nameLabel;
    protected JLabel messageLabel;
    protected JProgressBar progressBar;
    private IRaptorTaskStatus _status;
    protected JTable _jTable;
    private JCheckBox _chkAutoExit;
    private RaptorTaskDescriptor _taskDesc;
    protected DefaultTableModel _jTableModel;

    public FullMigrateTaskUI(RaptorTaskDescriptor raptorTaskDescriptor) {
        this._taskUI.setLayout(new BoxLayout(this._taskUI, 1));
        this._taskDesc = raptorTaskDescriptor;
        this.initGUI();
        this.setState(raptorTaskDescriptor);
    }

    public String getEventString(Object object) {
        return "";
    }

    protected JTable getTopTable() {
        Object[] objectArray = this.getColumnNames();
        this._jTableModel = new DefaultTableModel(null, objectArray){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        return new JTable(this._jTableModel);
    }

    public String[] getColumnNames() {
        return new String[]{"", ""};
    }

    protected void setState(RaptorTaskDescriptor raptorTaskDescriptor) {
        this.nameLabel.setText(raptorTaskDescriptor.getName());
        this.progressBar.setStringPainted(true);
        this.progressBar.setString(raptorTaskDescriptor.getMessage());
        this.nameLabel.setIcon(raptorTaskDescriptor.getIcon());
        if (raptorTaskDescriptor.isInDeterminate()) {
            if (raptorTaskDescriptor.getStatus().equals((Object)IRaptorTaskStatus.RUNNABLE) || raptorTaskDescriptor.getStatus().equals((Object)IRaptorTaskStatus.NEW)) {
                this.progressBar.setIndeterminate(true);
            } else if (raptorTaskDescriptor.getStatus().equals((Object)IRaptorTaskStatus.PAUSED)) {
                this.progressBar.setIndeterminate(false);
                this.progressBar.setValue(50);
            } else {
                this.progressBar.setIndeterminate(false);
                this.progressBar.setValue(100);
            }
        } else {
            this.progressBar.setValue(raptorTaskDescriptor.getProgress());
        }
        this.setStatus(raptorTaskDescriptor.getStatus());
        long l = raptorTaskDescriptor.getElapsedTime() / 1000L;
        int n = (int)(l / 3600L);
        int n2 = (int)((l -= (long)(n * 60 * 60)) / 60L);
        String string = n + ":" + n2 + ":" + (l -= (long)(n2 * 60));
        this.messageLabel.setText(string + " - " + raptorTaskDescriptor.getMessage());
    }

    protected void initGUI() {
        this._taskUI.setBorder(BorderFactory.createEmptyBorder());
        this._taskUI.setLayout(new GridBagLayout());
        this._taskUI.setOpaque(true);
        this._taskUI.setBackground(Color.WHITE);
        this.nameLabel = new JLabel();
        this._taskUI.add((Component)this.nameLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        FullMigrationTopPanel fullMigrationTopPanel = new FullMigrationTopPanel();
        this._taskUI.add((Component)fullMigrationTopPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel = new JPanel(new BorderLayout());
        this.progressBar = new JProgressBar(0, 100);
        jPanel.add((Component)this.progressBar, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        this.messageLabel = new JLabel();
        jPanel2.add(this.messageLabel);
        this._chkAutoExit = new JCheckBox(MigrationAddinArb.getString("MigrationProgressBar_AUTOCLOSE_LABEL"));
        jPanel2.add(this._chkAutoExit);
        jPanel.add((Component)jPanel2, "South");
        this._taskUI.add((Component)jPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel3 = this.getBottomPanel();
        if (jPanel3 != null) {
            this._taskUI.add((Component)jPanel3, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            Dimension dimension = new Dimension(FullMigrateTaskUI.PANEL_DIMENSION.width, FullMigrateTaskUI.PANEL_DIMENSION.height + jPanel3.getPreferredSize().height);
            this._taskUI.setPreferredSize(dimension);
        } else {
            this._taskUI.setPreferredSize(PANEL_DIMENSION);
        }
    }

    protected JPanel getBottomPanel() {
        return null;
    }

    public String getMessage() {
        return this.messageLabel.getText();
    }

    public String getName() {
        return this.nameLabel.getText();
    }

    public IRaptorTaskStatus getStatus() {
        return this._status;
    }

    public void makeProgress(int n) {
        this.progressBar.setValue(this.progressBar.getValue() + n);
    }

    public void setMessage(String string) {
        this.messageLabel.setText(string);
    }

    public void setName(String string) {
        this.nameLabel.setText(string);
    }

    public void setProgress(int n) {
        this.progressBar.setValue(n);
    }

    public void setStatus(IRaptorTaskStatus iRaptorTaskStatus) {
        this._status = iRaptorTaskStatus;
    }

    public void messageChanged(final RaptorTaskEvent raptorTaskEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    FullMigrateTaskUI.this.setState(raptorTaskEvent.getTaskDescriptor());
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }
        });
    }

    public void addListener(IRaptorTaskUIListener iRaptorTaskUIListener) {
    }

    public Component getPanel() {
        return this._taskUI;
    }

    public void removeListener(IRaptorTaskUIListener iRaptorTaskUIListener) {
    }

    public void setCancellable(boolean bl) {
    }

    public void setPausable(boolean bl) {
    }

    public void cancelClicked(RaptorTaskDescriptor raptorTaskDescriptor) {
    }

    public void pauseClicked(RaptorTaskDescriptor raptorTaskDescriptor) {
    }

    public void taskClicked(RaptorTaskDescriptor raptorTaskDescriptor) {
    }

    public boolean canCloseDialog() {
        return this._chkAutoExit.isSelected();
    }

    public RaptorTaskDescriptor getTaskDescriptor() {
        return this._taskDesc;
    }

    public void progressChanged(final RaptorTaskEvent raptorTaskEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    FullMigrateTaskUI.this.setState(raptorTaskEvent.getTaskDescriptor());
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }
        });
    }

    public void stateChanged(final RaptorTaskEvent raptorTaskEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    FullMigrateTaskUI.this.setState(raptorTaskEvent.getTaskDescriptor());
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }
        });
    }

    public ITaskUI getNewTaskUI(RaptorTaskDescriptor raptorTaskDescriptor) {
        return null;
    }
}

