/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.migration.convert.ConvertUtils;
import oracle.dbtools.migration.convert.DataTypeConversionMap;
import oracle.dbtools.migration.convert.DataTypeMappingRule;
import oracle.dbtools.migration.convert.DataTypeSpecification;
import oracle.dbtools.migration.convert.SupportedDataTypesMap;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.workbench.core.Messages;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.ui.ComboCellEditor;
import oracle.dbtools.migration.workbench.core.ui.DataMapValidator;
import oracle.dbtools.migration.workbench.core.ui.NewFieldTypePanel;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;

public class DataMapPanel
extends JPanel {
    private static final long serialVersionUID = -7491951044572680503L;
    static final String SOURCE_DATA_TYPE = StringUtils.stripMnemonic((String)MigrationAddinArb.getString("COLUMN_SOURCE_DATA_TYPE"));
    static final String SOURCE_DATA_TYPE_AMP = MigrationAddinArb.getString("COLUMN_SOURCE_DATA_TYPE");
    static final String TARGET_DATA_TYPE = StringUtils.stripMnemonic((String)MigrationAddinArb.getString("COLUMN_ORACLE_DATA_TYPE"));
    static final String TARGET_DATA_TYPE_AMP = MigrationAddinArb.getString("COLUMN_ORACLE_DATA_TYPE");
    static final String TYPE = MigrationAddinArb.getString("COLUMN_TYPE");
    private static final String RULE_TYPE_USER = MigrationAddinArb.getString("RULE_TYPE_USER");
    private static final String RULE_TYPE_SYSTEM = MigrationAddinArb.getString("RULE_TYPE_SYSTEM");
    static final String PRECISION = MigrationAddinArb.getString("COLUMN_PRECISION");
    static final String PRECISION_ORACLE = MigrationAddinArb.getString("COLUMN_PRECISION_ORACLE");
    static final String SCALE = MigrationAddinArb.getString("COLUMN_SCALE");
    static final String SCALE_ORACLE = MigrationAddinArb.getString("COLUMN_SCALE_ORACLE");
    private JTable _tblDataMap;
    private boolean _enableCellEditors = true;
    private Map<DataTypeSpecification, List<DataTypeSpecification>> _sourceTargetMap;
    private Set<DataTypeSpecification> _allTargetValueList;
    private Set<DataTypeSpecification> _completeTargetValues;
    private List<DataTypeSpecification> _relevantDataTypeSpecifications;
    private SupportedDataTypesMap _supportedDataTypeMap;
    private JLabel _lblErrorMessage;
    private DefaultTableModel _filteredModel;
    private DBObjectId _savedMapId;
    private JCheckBox _chkFilter;
    TableRowSorter<TableModel> m_sorter = null;
    private final JButton btnAdd = new JButton();
    private final JButton btnEdit = new JButton();
    private final JButton btnRemove = new JButton();

    public DataMapPanel(SupportedDataTypesMap supportedDataTypesMap, DataTypeSpecification[] dataTypeSpecificationArray) {
        super(new BorderLayout());
        ResourceUtils.resButton((AbstractButton)this.btnAdd, (String)MigrationAddinArb.getString("BUTTON_ADD"));
        ResourceUtils.resButton((AbstractButton)this.btnEdit, (String)MigrationAddinArb.getString("BUTTON_EDIT"));
        ResourceUtils.resButton((AbstractButton)this.btnRemove, (String)MigrationAddinArb.getString("BUTTON_REMOVE"));
        this._relevantDataTypeSpecifications = Arrays.asList(dataTypeSpecificationArray);
        this._supportedDataTypeMap = supportedDataTypesMap;
        this.initGUI();
        this.initializeValues(false);
        this.createTableModel();
        this.m_sorter = new TableRowSorter<DefaultTableModel>(this._filteredModel);
        this._tblDataMap.setRowSorter(this.m_sorter);
        ArrayList<RowSorter.SortKey> arrayList = new ArrayList<RowSorter.SortKey>();
        arrayList.add(new RowSorter.SortKey(2, SortOrder.ASCENDING));
        arrayList.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
        this.m_sorter.setSortKeys(arrayList);
        this.m_sorter.sort();
        this.setFilter();
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_convertionDataMap_html");
    }

    private void initGUI() {
        BorderLayout borderLayout = new BorderLayout();
        this.setLayout(borderLayout);
        this.setPreferredSize(new Dimension(573, 394));
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        this._lblErrorMessage = new JLabel();
        this._lblErrorMessage.setForeground(Color.RED);
        jPanel.add(this._lblErrorMessage);
        this.createTableUI();
        if (this._relevantDataTypeSpecifications != null && this._relevantDataTypeSpecifications.size() > 0) {
            this._chkFilter = new JCheckBox();
            jPanel.add(this._chkFilter);
            ResourceUtils.resButton((AbstractButton)this._chkFilter, (String)MigrationAddinArb.getString("LABEL_FILTER"));
            this._chkFilter.setSelected(false);
            this._chkFilter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DataMapPanel.this.initializeValues(DataMapPanel.this._chkFilter.isSelected());
                    TableColumn tableColumn = DataMapPanel.this._tblDataMap.getColumn(TARGET_DATA_TYPE);
                    ComboCellEditor comboCellEditor = (ComboCellEditor)tableColumn.getCellEditor();
                    DataMapPanel.this.setFilter();
                    tableColumn = DataMapPanel.this._tblDataMap.getColumn(TARGET_DATA_TYPE);
                    tableColumn.setCellEditor(comboCellEditor);
                }
            });
            this._chkFilter.doClick();
        }
        this.add((Component)jPanel, "North");
    }

    @Override
    public void setEnabled(boolean bl) {
        this._enableCellEditors = bl;
        if (this._chkFilter != null) {
            this._chkFilter.setEnabled(bl);
        }
        this.btnAdd.setEnabled(bl);
        this.btnEdit.setEnabled(bl);
        this.btnRemove.setEnabled(bl);
        this._tblDataMap.setEnabled(bl);
        this.revalidate();
    }

    private void createTableUI() {
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "Center");
        BorderLayout borderLayout = new BorderLayout();
        jPanel.setLayout(borderLayout);
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, "Center");
        jScrollPane.setPreferredSize(new Dimension(573, 218));
        this._tblDataMap = this.createDataSpecTable();
        jScrollPane.setViewportView(this._tblDataMap);
        this._tblDataMap.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (DataMapPanel.this._tblDataMap.getSelectedRowCount() > 0 && mouseEvent.getClickCount() == 2 && DataMapPanel.this._enableCellEditors) {
                    DataMapPanel.this.btnEdit.doClick();
                }
            }
        });
        this._tblDataMap.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\u007f') {
                    DataMapPanel.this.btnRemove.doClick();
                }
            }
        });
        this._tblDataMap.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    boolean bl = DataMapPanel.this._tblDataMap.getSelectedRowCount() > 0;
                    int n = DataMapPanel.this._tblDataMap.getSelectedRow();
                    if (n != -1) {
                        String string = (String)DataMapPanel.this._tblDataMap.getValueAt(n, 2);
                        boolean bl2 = string.equals(RULE_TYPE_USER);
                        DataMapPanel.this.btnEdit.setEnabled(bl && DataMapPanel.this._enableCellEditors);
                        DataMapPanel.this.btnRemove.setEnabled(bl2 && DataMapPanel.this._enableCellEditors);
                    }
                }
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel.add((Component)jPanel2, "South");
        jPanel2.setLayout(new FlowLayout(2));
        jPanel2.add(this.btnAdd);
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DataMapPanel.this._allTargetValueList.size() > 0) {
                    final NewFieldTypePanel newFieldTypePanel = new NewFieldTypePanel(DataMapPanel.this._sourceTargetMap.keySet(), DataMapPanel.this._allTargetValueList, null, null);
                    int n = 10;
                    ActionListener actionListener = new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            if (actionEvent.getActionCommand() == "apply") {
                                if (DataMapPanel.this._tblDataMap.getCellEditor() != null) {
                                    DataMapPanel.this._tblDataMap.getCellEditor().stopCellEditing();
                                }
                                Object[] objectArray = new Object[]{newFieldTypePanel.getSourceSpecification(), newFieldTypePanel.getTargetSpecification(), RULE_TYPE_USER};
                                DataMapPanel.this._filteredModel.addRow(objectArray);
                                ((JEWTDialog)actionEvent.getSource()).closeDialog(true);
                                DataMapPanel.this.setFilter();
                                int n = DataMapPanel.this.findValue(objectArray);
                                if (n != -1) {
                                    DataMapPanel.this._tblDataMap.setRowSelectionInterval(n, n);
                                    DataMapPanel.this._tblDataMap.scrollRectToVisible(DataMapPanel.this._tblDataMap.getCellRect(n, 0, true));
                                }
                                DataMapPanel.this._tblDataMap.repaint();
                            }
                        }
                    };
                    HelpSystem.getHelpSystem().registerTopic((JComponent)newFieldTypePanel, "f1_newDataRule_html");
                    UIUtils.showPanelAsDialog((JPanel)newFieldTypePanel, (String)MigrationAddinArb.getString("NEW_FIELD_ADD_TITLE"), (ActionListener)actionListener, (int)n, (boolean)true);
                } else {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, Messages.getString("MigrationReportManager.14"), Messages.getString("MigrationReportManager.14"));
                }
            }
        });
        jPanel2.add(this.btnEdit);
        this.btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                final int n = DataMapPanel.this._tblDataMap.convertRowIndexToModel(DataMapPanel.this._tblDataMap.getSelectedRow());
                if (n >= 0 && DataMapPanel.this._allTargetValueList.size() > 0) {
                    if (DataMapPanel.this._tblDataMap.getCellEditor() != null) {
                        DataMapPanel.this._tblDataMap.getCellEditor().stopCellEditing();
                    }
                    final TableModel tableModel = DataMapPanel.this._tblDataMap.getModel();
                    final int n2 = DataMapPanel.this._tblDataMap.convertColumnIndexToModel(DataMapPanel.this._tblDataMap.getColumnModel().getColumnIndex(SOURCE_DATA_TYPE));
                    final int n3 = DataMapPanel.this._tblDataMap.convertColumnIndexToModel(DataMapPanel.this._tblDataMap.getColumnModel().getColumnIndex(TARGET_DATA_TYPE));
                    DataTypeSpecification dataTypeSpecification = (DataTypeSpecification)tableModel.getValueAt(n, n2);
                    Set set = DataMapPanel.this._completeTargetValues;
                    final NewFieldTypePanel newFieldTypePanel = new NewFieldTypePanel(DataMapPanel.this._sourceTargetMap.keySet(), set, dataTypeSpecification, (DataTypeSpecification)tableModel.getValueAt(n, n3));
                    if (n < DataMapPanel.this._sourceTargetMap.size()) {
                        newFieldTypePanel.setSourceEditable(false);
                    }
                    int n4 = 10;
                    ActionListener actionListener = new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            if (actionEvent.getActionCommand() == "apply") {
                                tableModel.setValueAt(newFieldTypePanel.getSourceSpecification(), n, n2);
                                tableModel.setValueAt(newFieldTypePanel.getTargetSpecification(), n, n3);
                                ((JEWTDialog)actionEvent.getSource()).closeDialog(true);
                                DataMapPanel.this._tblDataMap.repaint();
                            }
                        }
                    };
                    HelpSystem.getHelpSystem().registerTopic((JComponent)newFieldTypePanel, "f1_newDataRule_html");
                    UIUtils.showPanelAsDialog((JPanel)newFieldTypePanel, (String)MigrationAddinArb.getString("NEW_FIELD_TITLE"), (ActionListener)actionListener, (int)n4, (boolean)true);
                }
            }
        });
        jPanel2.add(this.btnRemove);
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = DataMapPanel.this._tblDataMap.getSelectedRow();
                String string = (String)DataMapPanel.this._tblDataMap.getValueAt(n, 2);
                boolean bl = string.equals(RULE_TYPE_USER);
                if (bl) {
                    TableModel tableModel = DataMapPanel.this._tblDataMap.getModel();
                    DataMapPanel.this._filteredModel.removeRow(DataMapPanel.this._tblDataMap.convertRowIndexToModel(n));
                    if (tableModel.getRowCount() > 0) {
                        int n2 = Math.max(n - 1, 0);
                        if (tableModel.getRowCount() > 0) {
                            DataMapPanel.this._tblDataMap.setRowSelectionInterval(n2, n2);
                        }
                    }
                }
            }
        });
        this.btnEdit.setEnabled(false);
        this.btnRemove.setEnabled(false);
    }

    private JTable createDataSpecTable() {
        DefaultTableModel defaultTableModel;
        Object[] objectArray = new String[]{SOURCE_DATA_TYPE, TARGET_DATA_TYPE, TYPE};
        this._filteredModel = defaultTableModel = new DefaultTableModel(null, objectArray){

            @Override
            public boolean isCellEditable(int n, int n2) {
                int n3 = DataMapPanel.this._tblDataMap.getColumnModel().getColumnIndex(TARGET_DATA_TYPE);
                return DataMapPanel.this._enableCellEditors && n3 == n2;
            }
        };
        JTable jTable = new JTable(this._filteredModel);
        jTable.setToolTipText(MigrationAddinArb.getString("TABLE_TOOLTIP"));
        jTable.setPreferredScrollableViewportSize(new Dimension(100, 70));
        jTable.getSelectionModel().setSelectionMode(0);
        TableColumn tableColumn = jTable.getColumn(TARGET_DATA_TYPE);
        ComboCellEditor comboCellEditor = new ComboCellEditor(new JComboBox());
        tableColumn.setCellEditor(comboCellEditor);
        return jTable;
    }

    public boolean isChanged() {
        for (int i = 0; i < this._tblDataMap.getRowCount(); ++i) {
            String string = ((DataTypeSpecification)this._tblDataMap.getValueAt(i, 1)).getName();
            List<DataTypeSpecification> list = this._sourceTargetMap.get(this._tblDataMap.getValueAt(i, 0));
            if (list == null || list.get(0).getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    private void initializeValues(boolean bl) {
        this._sourceTargetMap = new HashMap<DataTypeSpecification, List<DataTypeSpecification>>();
        this._allTargetValueList = new HashSet<DataTypeSpecification>();
        this._completeTargetValues = new HashSet<DataTypeSpecification>();
        if (this._supportedDataTypeMap == null) {
            return;
        }
        for (DataTypeSpecification dataTypeSpecification : this._supportedDataTypeMap.getSourceDataTypes()) {
            DataTypeSpecification dataTypeSpecification2 = new DataTypeSpecification(dataTypeSpecification.getName());
            List<DataTypeSpecification> list = this.getTargetDataTypeSpecification(this._supportedDataTypeMap, dataTypeSpecification);
            if (bl && this._relevantDataTypeSpecifications.contains(dataTypeSpecification2) || !bl) {
                this._sourceTargetMap.put(dataTypeSpecification, list);
                this._allTargetValueList.addAll(list);
            }
            this._completeTargetValues.addAll(list);
        }
        TableColumn tableColumn = this._tblDataMap.getColumn(TARGET_DATA_TYPE);
        ComboCellEditor comboCellEditor = (ComboCellEditor)tableColumn.getCellEditor();
        comboCellEditor.setSourceTargetMap(this._sourceTargetMap);
    }

    private List<DataTypeSpecification> getTargetDataTypeSpecification(SupportedDataTypesMap supportedDataTypesMap, DataTypeSpecification dataTypeSpecification) {
        DataTypeMappingRule[] dataTypeMappingRuleArray = supportedDataTypesMap.getRulesForDataType(dataTypeSpecification);
        ArrayList<DataTypeSpecification> arrayList = new ArrayList<DataTypeSpecification>(dataTypeMappingRuleArray.length);
        for (int i = 0; i < dataTypeMappingRuleArray.length; ++i) {
            arrayList.add(dataTypeMappingRuleArray[i].getTargetDataType());
        }
        return arrayList;
    }

    private void createTableModel() {
        this._filteredModel.setRowCount(0);
        for (DataTypeSpecification dataTypeSpecification : this._sourceTargetMap.keySet()) {
            List<DataTypeSpecification> list = this._sourceTargetMap.get(dataTypeSpecification);
            this._filteredModel.addRow(new Object[]{dataTypeSpecification, list.get(0), RULE_TYPE_SYSTEM});
        }
    }

    public DataTypeConversionMap getDataTypeConversionMap() {
        DataTypeConversionMap dataTypeConversionMap = new DataTypeConversionMap();
        DefaultTableModel defaultTableModel = this._filteredModel;
        int n = this._tblDataMap.getColumnModel().getColumnIndex(SOURCE_DATA_TYPE);
        int n2 = this._tblDataMap.getColumnModel().getColumnIndex(TARGET_DATA_TYPE);
        for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
            DataTypeSpecification dataTypeSpecification = (DataTypeSpecification)defaultTableModel.getValueAt(i, n);
            DataTypeSpecification dataTypeSpecification2 = (DataTypeSpecification)defaultTableModel.getValueAt(i, n2);
            try {
                dataTypeConversionMap.addRule(new DataTypeMappingRule(dataTypeSpecification, dataTypeSpecification2));
                continue;
            }
            catch (IllegalStateException illegalStateException) {
                int n3 = this._chkFilter.isSelected() ? this._tblDataMap.convertRowIndexToView(i) : i;
                this.setMessage(MessageFormat.format("", dataTypeSpecification, n3 + 1));
                return null;
            }
        }
        return dataTypeConversionMap;
    }

    public DBObjectId save(DBObject dBObject) {
        DataTypeConversionMap dataTypeConversionMap = this.getDataTypeConversionMap();
        if (dataTypeConversionMap == null) {
            return null;
        }
        String string = DataMapValidator.validate(dataTypeConversionMap, this._supportedDataTypeMap);
        if (string != null) {
            this.setMessage(string);
            return null;
        }
        MdConnection mdConnection = MigrationUtils.getConnforDBObject(dBObject);
        try {
            DBObjectId dBObjectId;
            this._savedMapId = dBObjectId = ConvertUtils.persistMap(MigrationAddin.getPersistenceManager(), mdConnection.getProjectId(), "SQLServerDataMap", dataTypeConversionMap);
            return dBObjectId;
        }
        catch (PersistenceException persistenceException) {
            this.setMessage(persistenceException.getMessage());
            Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").warning("DataMap.SAVE_FAILED");
            return null;
        }
    }

    private void setMessage(String string) {
        this._lblErrorMessage.setText(string);
    }

    public void setPersistedRules(DataTypeMappingRule[] dataTypeMappingRuleArray) {
        int n = this._tblDataMap.getColumnModel().getColumnIndex(TARGET_DATA_TYPE);
        for (DataTypeMappingRule dataTypeMappingRule : dataTypeMappingRuleArray) {
            int n2 = this.searchInModel(this._filteredModel, dataTypeMappingRule.getSourceDataType());
            if (n2 >= 0) {
                this._filteredModel.setValueAt(dataTypeMappingRule.getTargetDataType(), n2, n);
            } else {
                this._filteredModel.addRow(new Object[]{dataTypeMappingRule.getSourceDataType(), dataTypeMappingRule.getTargetDataType(), RULE_TYPE_USER});
            }
            n2 = this.searchInModel(this._filteredModel, dataTypeMappingRule.getSourceDataType());
            if (n2 < 0) continue;
            this._filteredModel.setValueAt(dataTypeMappingRule.getTargetDataType(), n2, n);
        }
    }

    private int searchInModel(TableModel tableModel, DataTypeSpecification dataTypeSpecification) {
        int n = this._tblDataMap.getColumnModel().getColumnIndex(SOURCE_DATA_TYPE);
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            if (!tableModel.getValueAt(i, n).equals(dataTypeSpecification)) continue;
            return i;
        }
        return -1;
    }

    public DBObjectId getSavedMapId() {
        return this._savedMapId;
    }

    private void setFilter() {
        RowFilter<TableModel, Integer> rowFilter = new RowFilter<TableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
                boolean bl = false;
                DataTypeSpecification dataTypeSpecification = (DataTypeSpecification)entry.getValue(0);
                String string = (String)entry.getValue(2);
                bl = DataMapPanel.this._chkFilter != null && DataMapPanel.this._chkFilter.isSelected() ? DataMapPanel.this._relevantDataTypeSpecifications.contains(dataTypeSpecification) || string.equals(RULE_TYPE_USER) : true;
                return bl;
            }
        };
        if (this.m_sorter != null) {
            this.m_sorter.setRowFilter(rowFilter);
        }
    }

    private int findValue(Object[] objectArray) {
        int n = -1;
        if (this._tblDataMap != null) {
            for (int i = 0; i < this._tblDataMap.getModel().getRowCount(); ++i) {
                if (!((DataTypeSpecification)objectArray[0]).equals((DataTypeSpecification)this._tblDataMap.getValueAt(i, 0)) || !((DataTypeSpecification)objectArray[1]).equals((DataTypeSpecification)this._tblDataMap.getValueAt(i, 1)) || !((String)objectArray[2]).equals((String)this._tblDataMap.getValueAt(i, 2))) continue;
                return i;
            }
        }
        return n;
    }
}

