/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.migration.convert.ConverterWorker;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.navigator.MigrationProjectNavigatorManager;
import oracle.dbtools.migration.workbench.core.navigator.nodes.MigrationProjectsFolderNode;
import oracle.dbtools.migration.workbench.core.ui.MigrationSchedulingRule;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.ISchedulingRule;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.internal.ConnectionMutexFactory;
import oracle.dbtools.raptor.backgroundTask.internal.ObjectMutexRule;
import oracle.ide.model.Element;

public class ConvertRunnerTask
extends RaptorTask<Object> {
    private int m_uaMask;
    private ConverterWorker m_worker;
    private String m_sourceConnName;

    public ConvertRunnerTask(ConverterWorker converterWorker, int n, String string) {
        super(MigrationAddinArb.getString("CONVERTRUNNER_TITLE"), true, IRaptorTaskRunMode.MODAL_OPTIONAL);
        this.m_worker = converterWorker;
        this.m_uaMask = n;
        this.m_sourceConnName = string;
        this.setMessage(MigrationAddinArb.getString("CONVERTRUNNER_INITIAL_MESSAGE"));
        this.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            private void cleanUp() {
                MdConnection mdConnection = ConvertRunnerTask.this.m_worker.getConvertedConnection();
                if (mdConnection != null) {
                    try {
                        mdConnection.delete(MigrationAddin.getPersistenceManager());
                        MigrationAddin.getPersistenceManager().commit();
                    }
                    catch (PersistenceException persistenceException) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, persistenceException.getStackTrace()[0].toString(), persistenceException);
                    }
                    catch (SQLException sQLException) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    }
                }
            }

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                this.cleanUp();
            }

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                this.cleanUp();
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                Boolean bl = Boolean.FALSE;
                try {
                    bl = (Boolean)ConvertRunnerTask.this.getResult();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (bl != null && bl.booleanValue()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MigrationProjectNavigatorManager.getInstance().refreshElement((Element)MigrationProjectsFolderNode.getInstance());
                        }
                    });
                } else {
                    this.cleanUp();
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object doWork() throws TaskException {
        try {
            if (this.m_worker.runConvert()) {
                Boolean bl = Boolean.TRUE;
                return bl;
            }
            Boolean bl = Boolean.FALSE;
            return bl;
        }
        catch (Exception exception) {
            throw new TaskException((Throwable)exception);
        }
        finally {
            MigrationLogUtil.endMigrationLogSession();
        }
    }

    public ISchedulingRule getSchedulingRule() {
        ISchedulingRule iSchedulingRule = ConnectionMutexFactory.getRule((String)this.m_sourceConnName);
        ISchedulingRule iSchedulingRule2 = ConnectionMutexFactory.getRule((String)MigrationAddin.getRepositoryConnectionName());
        ObjectMutexRule objectMutexRule = new ObjectMutexRule((Object)"MigrationSession");
        return new MigrationSchedulingRule(iSchedulingRule, iSchedulingRule2, objectMutexRule);
    }

    public boolean cancel() {
        this.m_worker.signalCancel();
        return true;
    }
}

