/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.repository;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import oracle.dbtools.metadata.persistence.CloseableResultSet;

public class PrivilegeManager {
    private Hashtable<String, Privilege> m_privileges;
    private Hashtable<String, Privilege> m_roles;
    private boolean m_sysDba = false;

    public PrivilegeManager(Connection connection) throws SQLException {
        this.loadPrivileges(connection);
        if (!this.m_sysDba) {
            this.loadRoles(connection);
        }
    }

    public boolean hasRole(String string) {
        if (this.m_sysDba) {
            return true;
        }
        return this.m_roles.containsKey(string);
    }

    public boolean hasPrivilege(String string) {
        if (this.m_sysDba) {
            return true;
        }
        return this.m_privileges.containsKey(string);
    }

    public boolean hasPrivilegeWithAdmin(String string) {
        if (this.m_sysDba) {
            return true;
        }
        Privilege privilege = this.m_privileges.get(string);
        return privilege != null && privilege.isGrantable();
    }

    public boolean hasRoleWithAdmin(String string) {
        if (this.m_sysDba) {
            return true;
        }
        Privilege privilege = this.m_roles.get(string);
        return privilege != null && privilege.isGrantable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPrivileges(Connection connection) throws SQLException {
        this.m_sysDba = this.checkSysDba(connection);
        if (this.m_sysDba) {
            return;
        }
        this.m_privileges = new Hashtable();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String string = "select PRIVILEGE, ADMIN_OPTION from role_sys_privs UNION select PRIVILEGE, ADMIN_OPTION from user_sys_privs";
            preparedStatement = connection.prepareStatement(string);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = resultSet.getString("PRIVILEGE");
                String string3 = resultSet.getString("ADMIN_OPTION");
                this.m_privileges.put(string2, new Privilege(string2, !string3.equals("NO")));
            }
        }
        finally {
            try {
                resultSet.close();
                preparedStatement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRoles(Connection connection) throws SQLException {
        this.m_roles = new Hashtable();
        String string = "SELECT GRANTED_ROLE, ADMIN_OPTION FROM USER_ROLE_PRIVS A, USER_USERS B WHERE A.USERNAME = B.USERNAME";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(string);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = resultSet.getString("GRANTED_ROLE");
                String string3 = resultSet.getString("ADMIN_OPTION");
                this.m_roles.put(string2, new Privilege(string2, !string3.equals("NO")));
            }
        }
        finally {
            try {
                resultSet.close();
                preparedStatement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkSysDba(Connection connection) throws SQLException {
        boolean bl;
        String string = "select count(*) from session_privs where privilege = 'SYSDBA'";
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            resultSet.next();
            int n = resultSet.getInt(1);
            bl = n != 0;
        }
        catch (Throwable throwable) {
            CloseableResultSet.close(statement, resultSet);
            throw throwable;
        }
        CloseableResultSet.close(statement, resultSet);
        return bl;
    }

    public static class Privilege {
        private String m_name;
        private boolean m_grantable;

        public Privilege(String string, boolean bl) {
            this.setName(string);
            this.setGrantable(bl);
        }

        public boolean isGrantable() {
            return this.m_grantable;
        }

        public String getName() {
            return this.m_name;
        }

        protected void setGrantable(boolean bl) {
            this.m_grantable = bl;
        }

        protected void setName(String string) {
            this.m_name = string;
        }
    }
}

