/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator.nodes;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdStoredProgram;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.raptor.navigator.db.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.impl.ChildObjectElement;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.util.Assert;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;

public class TSQLNode
extends TextNode
implements DatabaseNode {
    public static final String RUNNABLE_KEY = "RUNNABLE";
    private String m_name;
    private String m_cName;
    private String m_type;
    private String m_schema;
    private DBObjectInstance m_node;

    public void setURL(URL uRL) {
        super.setURL(uRL);
        if (uRL != null) {
            this.m_name = DBURLFormatHelper.getName((URL)uRL);
            this.m_cName = DBURLFormatHelper.getConnectionName((URL)uRL);
            this.m_type = DBURLFormatHelper.getBaseType((URL)uRL);
            this.m_schema = DBURLFormatHelper.getSchema((URL)uRL);
        }
    }

    public TSQLNode getRunTarget() {
        return null;
    }

    public final String getSource() {
        return "hello World";
    }

    public void setNodeInstance(DBObjectInstance dBObjectInstance) {
        this.m_node = dBObjectInstance;
    }

    public DBObjectInstance getNodeInstance() {
        return this.m_node;
    }

    public void setProperty(String string, Object object) {
        this.m_node.setProperty(string, object);
    }

    public Object getProperty(String string) {
        Object object = null;
        if ("NAME".equals(string)) {
            object = this.m_name;
        } else if ("SCHEMA".equals(string)) {
            object = this.m_schema;
        } else if ("TYPE".equals(string)) {
            object = this.m_type;
        } else if ("ConnectionName".equals(string)) {
            object = this.m_cName;
        } else if (this.m_node != null) {
            object = this.m_node.getProperty(string);
        }
        return object;
    }

    public String getConnectionName() {
        return this.m_cName;
    }

    public NavigationPoint getNavigationPoint(ChildObjectElement childObjectElement) {
        OffsetNavigationPoint offsetNavigationPoint = null;
        Integer n = (Integer)childObjectElement.getProperty("CODE_OFFSET");
        if (n != null) {
            Integer n2 = (Integer)childObjectElement.getProperty("CODE_LENGTH");
            offsetNavigationPoint = new OffsetNavigationPoint(Context.newIdeContext((Node)this), n.intValue(), n2 != null ? n2 : 0);
            offsetNavigationPoint.setPreferredEditorType(null);
        }
        return offsetNavigationPoint;
    }

    public final boolean isValid() {
        return this.m_type != null;
    }

    private Reader tryMSLoad() {
        Object object = this.getProperty("MSIDSP");
        if (object == null) {
            return null;
        }
        Integer n = (Integer)object;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            Connection connection = Connections.getInstance().getConnection((String)this.getProperty("ConnectionName"));
            preparedStatement = connection.prepareStatement("SELECT TOP 1 CAST(TEXT AS VARCHAR(4000)) from syscomments WHERE ID=?");
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            resultSet.next();
            String string = resultSet.getString(1);
            StringReader stringReader = new StringReader(string);
            return stringReader;
        }
        catch (SQLException sQLException) {
            CloseableResultSet.close(preparedStatement, resultSet);
        }
        catch (DBException dBException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
        }
        return null;
    }

    protected Reader createReader(URL uRL) throws IOException {
        MdStoredProgram mdStoredProgram;
        Object object = this.getProperty("IDSP");
        if (object == null) {
            Reader reader = this.tryMSLoad();
            if (reader != null) {
                return reader;
            }
            return super.createReader(uRL);
        }
        BigDecimal bigDecimal = (BigDecimal)object;
        long l = bigDecimal.longValue();
        DBObjectId dBObjectId = new DBObjectId(l);
        try {
            mdStoredProgram = MdStoredProgram.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), dBObjectId);
        }
        catch (PersistenceException persistenceException) {
            Assert.printStackTrace((Throwable)persistenceException);
            IOException iOException = new IOException();
            iOException.initCause(persistenceException);
            throw iOException;
        }
        catch (NoSuchObjectException noSuchObjectException) {
            Assert.printStackTrace((Throwable)noSuchObjectException);
            IOException iOException = new IOException();
            iOException.initCause(noSuchObjectException);
            throw iOException;
        }
        return mdStoredProgram.getNativeSql().getReader();
    }

    public String getObjectType() {
        return null;
    }

    public String getSchemaName() {
        return null;
    }

    public Object getProviderIdentifier() {
        return null;
    }

    public String getStoreName() {
        return null;
    }

    public String getObjectName() {
        return null;
    }

    public DBObject getDBObject() {
        return null;
    }

    public DBObjectProvider getProvider() {
        return null;
    }

    public void init(DBObject dBObject, DBObjectProvider dBObjectProvider) {
    }

    public String getProviderType() {
        return null;
    }
}

